/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system;

import com.google.inject.Inject;
import io.airlift.node.NodeInfo;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.execution.SqlTaskManager;
import io.trino.execution.TaskInfo;
import io.trino.execution.TaskStatus;
import io.trino.metadata.MetadataUtil;
import io.trino.operator.TaskStats;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.InMemoryRecordSet;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import org.joda.time.DateTime;

public class TaskSystemTable
implements SystemTable {
    public static final SchemaTableName TASK_TABLE_NAME = new SchemaTableName("runtime", "tasks");
    public static final ConnectorTableMetadata TASK_TABLE = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(TASK_TABLE_NAME).column("node_id", (Type)VarcharType.createUnboundedVarcharType()).column("task_id", (Type)VarcharType.createUnboundedVarcharType()).column("stage_id", (Type)VarcharType.createUnboundedVarcharType()).column("query_id", (Type)VarcharType.createUnboundedVarcharType()).column("state", (Type)VarcharType.createUnboundedVarcharType()).column("splits", (Type)BigintType.BIGINT).column("queued_splits", (Type)BigintType.BIGINT).column("running_splits", (Type)BigintType.BIGINT).column("completed_splits", (Type)BigintType.BIGINT).column("split_scheduled_time_ms", (Type)BigintType.BIGINT).column("split_cpu_time_ms", (Type)BigintType.BIGINT).column("split_blocked_time_ms", (Type)BigintType.BIGINT).column("raw_input_bytes", (Type)BigintType.BIGINT).column("raw_input_rows", (Type)BigintType.BIGINT).column("processed_input_bytes", (Type)BigintType.BIGINT).column("processed_input_rows", (Type)BigintType.BIGINT).column("output_bytes", (Type)BigintType.BIGINT).column("output_rows", (Type)BigintType.BIGINT).column("physical_input_bytes", (Type)BigintType.BIGINT).column("physical_written_bytes", (Type)BigintType.BIGINT).column("created", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS).column("start", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS).column("last_heartbeat", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS).column("end", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS).build();
    private final SqlTaskManager taskManager;
    private final String nodeId;

    @Inject
    public TaskSystemTable(SqlTaskManager taskManager, NodeInfo nodeInfo) {
        this.taskManager = taskManager;
        this.nodeId = nodeInfo.getNodeId();
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.ALL_NODES;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return TASK_TABLE;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)TASK_TABLE);
        for (TaskInfo taskInfo : this.taskManager.getAllTaskInfo()) {
            TaskStats stats = taskInfo.getStats();
            TaskStatus taskStatus = taskInfo.getTaskStatus();
            table.addRow(new Object[]{this.nodeId, taskStatus.getTaskId().toString(), taskStatus.getTaskId().getStageId().toString(), taskStatus.getTaskId().getQueryId().toString(), taskStatus.getState().toString(), (long)stats.getTotalDrivers(), (long)stats.getQueuedDrivers(), (long)stats.getRunningDrivers(), (long)stats.getCompletedDrivers(), TaskSystemTable.toMillis(stats.getTotalScheduledTime()), TaskSystemTable.toMillis(stats.getTotalCpuTime()), TaskSystemTable.toMillis(stats.getTotalBlockedTime()), TaskSystemTable.toBytes(stats.getRawInputDataSize()), stats.getRawInputPositions(), TaskSystemTable.toBytes(stats.getProcessedInputDataSize()), stats.getProcessedInputPositions(), TaskSystemTable.toBytes(stats.getOutputDataSize()), stats.getOutputPositions(), TaskSystemTable.toBytes(stats.getPhysicalInputDataSize()), TaskSystemTable.toBytes(stats.getPhysicalWrittenDataSize()), TaskSystemTable.toTimestampWithTimeZoneMillis(stats.getCreateTime()), TaskSystemTable.toTimestampWithTimeZoneMillis(stats.getFirstStartTime()), TaskSystemTable.toTimestampWithTimeZoneMillis(taskInfo.getLastHeartbeat()), TaskSystemTable.toTimestampWithTimeZoneMillis(stats.getEndTime())});
        }
        return table.build().cursor();
    }

    private static Long toMillis(Duration duration) {
        if (duration == null) {
            return null;
        }
        return duration.toMillis();
    }

    private static Long toBytes(DataSize dataSize) {
        if (dataSize == null) {
            return null;
        }
        return dataSize.toBytes();
    }

    private static Long toTimestampWithTimeZoneMillis(DateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return DateTimeEncoding.packDateTimeWithZone((long)dateTime.getMillis(), (TimeZoneKey)TimeZoneKey.UTC_KEY);
    }
}

