/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.faulttolerant;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.ThreadSafe;
import com.google.inject.Inject;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.trino.Session;
import io.trino.execution.TaskId;
import io.trino.execution.scheduler.NodeSchedulerConfig;
import io.trino.execution.scheduler.faulttolerant.NodeAllocator;
import io.trino.execution.scheduler.faulttolerant.NodeAllocatorService;
import io.trino.execution.scheduler.faulttolerant.NodeRequirements;
import io.trino.execution.scheduler.faulttolerant.TaskExecutionClass;
import io.trino.memory.ClusterMemoryManager;
import io.trino.memory.MemoryInfo;
import io.trino.memory.MemoryManagerConfig;
import io.trino.metadata.InternalNode;
import io.trino.metadata.InternalNodeManager;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.HostAddress;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.memory.MemoryPoolInfo;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.assertj.core.util.VisibleForTesting;

@ThreadSafe
public class BinPackingNodeAllocatorService
implements NodeAllocatorService,
NodeAllocator {
    private static final Logger log = Logger.get(BinPackingNodeAllocatorService.class);
    @VisibleForTesting
    static final int PROCESS_PENDING_ACQUIRES_DELAY_SECONDS = 5;
    private final InternalNodeManager nodeManager;
    private final Supplier<Map<String, Optional<MemoryInfo>>> workerMemoryInfoSupplier;
    private final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(2, Threads.daemonThreadsNamed((String)"bin-packing-node-allocator"));
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicBoolean stopped = new AtomicBoolean();
    private final Semaphore processSemaphore = new Semaphore(0);
    private final AtomicReference<Map<String, MemoryPoolInfo>> nodePoolMemoryInfos = new AtomicReference<ImmutableMap>(ImmutableMap.of());
    private final boolean scheduleOnCoordinator;
    private final DataSize taskRuntimeMemoryEstimationOverhead;
    private final DataSize eagerSpeculativeTasksNodeMemoryOvercommit;
    private final Ticker ticker;
    private final Deque<PendingAcquire> pendingAcquires = new ConcurrentLinkedDeque<PendingAcquire>();
    private final Set<BinPackingNodeLease> fulfilledAcquires = Sets.newConcurrentHashSet();
    private final Duration allowedNoMatchingNodePeriod;

    @Inject
    public BinPackingNodeAllocatorService(InternalNodeManager nodeManager, ClusterMemoryManager clusterMemoryManager, NodeSchedulerConfig nodeSchedulerConfig, MemoryManagerConfig memoryManagerConfig) {
        this(nodeManager, clusterMemoryManager::getWorkerMemoryInfo, nodeSchedulerConfig.isIncludeCoordinator(), Duration.ofMillis(nodeSchedulerConfig.getAllowedNoMatchingNodePeriod().toMillis()), memoryManagerConfig.getFaultTolerantExecutionTaskRuntimeMemoryEstimationOverhead(), memoryManagerConfig.getFaultTolerantExecutionEagerSpeculativeTasksNodeMemoryOvercommit(), Ticker.systemTicker());
    }

    @VisibleForTesting
    BinPackingNodeAllocatorService(InternalNodeManager nodeManager, Supplier<Map<String, Optional<MemoryInfo>>> workerMemoryInfoSupplier, boolean scheduleOnCoordinator, Duration allowedNoMatchingNodePeriod, DataSize taskRuntimeMemoryEstimationOverhead, DataSize eagerSpeculativeTasksNodeMemoryOvercommit, Ticker ticker) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.workerMemoryInfoSupplier = Objects.requireNonNull(workerMemoryInfoSupplier, "workerMemoryInfoSupplier is null");
        this.scheduleOnCoordinator = scheduleOnCoordinator;
        this.allowedNoMatchingNodePeriod = Objects.requireNonNull(allowedNoMatchingNodePeriod, "allowedNoMatchingNodePeriod is null");
        this.taskRuntimeMemoryEstimationOverhead = Objects.requireNonNull(taskRuntimeMemoryEstimationOverhead, "taskRuntimeMemoryEstimationOverhead is null");
        this.eagerSpeculativeTasksNodeMemoryOvercommit = eagerSpeculativeTasksNodeMemoryOvercommit;
        this.ticker = Objects.requireNonNull(ticker, "ticker is null");
    }

    @PostConstruct
    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.executor.schedule(() -> {
                while (!this.stopped.get()) {
                    try {
                        this.processSemaphore.tryAcquire(5L, TimeUnit.SECONDS);
                        this.processSemaphore.drainPermits();
                        this.processPendingAcquires();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception e) {
                        log.warn((Throwable)e, "Error updating nodes");
                    }
                }
            }, 0L, TimeUnit.SECONDS);
        }
        this.refreshNodePoolMemoryInfos();
        this.executor.scheduleWithFixedDelay(() -> {
            try {
                this.refreshNodePoolMemoryInfos();
            }
            catch (Throwable e) {
                log.error(e, "Unexpected error while refreshing node pool memory infos");
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    @PreDestroy
    public void stop() {
        this.stopped.set(true);
        this.executor.shutdownNow();
    }

    @VisibleForTesting
    void refreshNodePoolMemoryInfos() {
        ImmutableMap.Builder newNodePoolMemoryInfos = ImmutableMap.builder();
        Map<String, Optional<MemoryInfo>> workerMemoryInfos = this.workerMemoryInfoSupplier.get();
        long maxNodePoolSizeBytes = -1L;
        for (Map.Entry<String, Optional<MemoryInfo>> entry : workerMemoryInfos.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            MemoryPoolInfo poolInfo = entry.getValue().get().getPool();
            newNodePoolMemoryInfos.put((Object)entry.getKey(), (Object)poolInfo);
            maxNodePoolSizeBytes = Math.max(poolInfo.getMaxBytes(), maxNodePoolSizeBytes);
        }
        this.nodePoolMemoryInfos.set((Map<String, MemoryPoolInfo>)newNodePoolMemoryInfos.buildOrThrow());
    }

    @VisibleForTesting
    synchronized void processPendingAcquires() {
        this.processPendingAcquires(TaskExecutionClass.EAGER_SPECULATIVE);
        this.processPendingAcquires(TaskExecutionClass.STANDARD);
        boolean hasNonSpeculativePendingAcquires = this.pendingAcquires.stream().anyMatch(pendingAcquire -> !pendingAcquire.isSpeculative());
        if (!hasNonSpeculativePendingAcquires) {
            this.processPendingAcquires(TaskExecutionClass.SPECULATIVE);
        }
    }

    private void processPendingAcquires(TaskExecutionClass executionClass) {
        Iterator<PendingAcquire> iterator = this.pendingAcquires.iterator();
        BinPackingSimulation simulation = new BinPackingSimulation(this.nodeManager.getActiveNodesSnapshot(), this.nodePoolMemoryInfos.get(), this.fulfilledAcquires, this.scheduleOnCoordinator, this.taskRuntimeMemoryEstimationOverhead, executionClass == TaskExecutionClass.EAGER_SPECULATIVE ? this.eagerSpeculativeTasksNodeMemoryOvercommit : DataSize.ofBytes((long)0L), executionClass == TaskExecutionClass.STANDARD);
        while (iterator.hasNext()) {
            PendingAcquire pendingAcquire = iterator.next();
            if (pendingAcquire.getFuture().isCancelled()) {
                iterator.remove();
                continue;
            }
            if (pendingAcquire.getExecutionClass() != executionClass) continue;
            BinPackingSimulation.ReserveResult result = simulation.tryReserve(pendingAcquire);
            switch (result.getStatus().ordinal()) {
                case 2: {
                    InternalNode reservedNode = result.getNode();
                    this.fulfilledAcquires.add(pendingAcquire.getLease());
                    pendingAcquire.getFuture().set((Object)reservedNode);
                    if (pendingAcquire.getFuture().isCancelled()) {
                        this.fulfilledAcquires.remove(pendingAcquire.getLease());
                        this.wakeupProcessPendingAcquires();
                    }
                    iterator.remove();
                    break;
                }
                case 0: {
                    Duration noMatchingNodePeriod = pendingAcquire.markNoMatchingNodeFound();
                    if (noMatchingNodePeriod.compareTo(this.allowedNoMatchingNodePeriod) <= 0) break;
                    pendingAcquire.getFuture().setException((Throwable)new TrinoException((ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "No nodes available to run query"));
                    iterator.remove();
                    break;
                }
                case 1: {
                    pendingAcquire.resetNoMatchingNodeFound();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown status: " + String.valueOf((Object)result.getStatus()));
                }
            }
        }
    }

    private void wakeupProcessPendingAcquires() {
        this.processSemaphore.release();
    }

    @Override
    public NodeAllocator getNodeAllocator(Session session) {
        return this;
    }

    @Override
    public NodeAllocator.NodeLease acquire(NodeRequirements nodeRequirements, DataSize memoryRequirement, TaskExecutionClass executionClass) {
        BinPackingNodeLease nodeLease = new BinPackingNodeLease(memoryRequirement.toBytes(), executionClass);
        PendingAcquire pendingAcquire = new PendingAcquire(nodeRequirements, nodeLease, this.ticker);
        this.pendingAcquires.add(pendingAcquire);
        this.wakeupProcessPendingAcquires();
        return nodeLease;
    }

    @Override
    public void close() {
    }

    private static class BinPackingSimulation {
        private final InternalNodeManager.NodesSnapshot nodesSnapshot;
        private final List<InternalNode> allNodesSorted;
        private final boolean ignoreAcquiredSpeculative;
        private final Map<String, Long> nodesRemainingMemory;
        private final Map<String, Long> nodesRemainingMemoryRuntimeAdjusted;
        private final Map<String, Long> speculativeMemoryReserved;
        private final Map<String, MemoryPoolInfo> nodeMemoryPoolInfos;
        private final boolean scheduleOnCoordinator;

        public BinPackingSimulation(InternalNodeManager.NodesSnapshot nodesSnapshot, Map<String, MemoryPoolInfo> nodeMemoryPoolInfos, Set<BinPackingNodeLease> fulfilledAcquires, boolean scheduleOnCoordinator, DataSize taskRuntimeMemoryEstimationOverhead, DataSize nodeMemoryOvercommit, boolean ignoreAcquiredSpeculative) {
            MemoryPoolInfo memoryPoolInfo;
            this.nodesSnapshot = Objects.requireNonNull(nodesSnapshot, "nodesSnapshot is null");
            this.allNodesSorted = (List)nodesSnapshot.getAllNodes().stream().sorted(Comparator.comparing(InternalNode::getNodeIdentifier)).collect(ImmutableList.toImmutableList());
            this.ignoreAcquiredSpeculative = ignoreAcquiredSpeculative;
            Objects.requireNonNull(nodeMemoryPoolInfos, "nodeMemoryPoolInfos is null");
            this.nodeMemoryPoolInfos = ImmutableMap.copyOf(nodeMemoryPoolInfos);
            this.scheduleOnCoordinator = scheduleOnCoordinator;
            HashMap<String, Object> realtimeTasksMemoryPerNode = new HashMap<String, Object>();
            for (InternalNode node : nodesSnapshot.getAllNodes()) {
                MemoryPoolInfo memoryPoolInfo2 = nodeMemoryPoolInfos.get(node.getNodeIdentifier());
                if (memoryPoolInfo2 == null) {
                    realtimeTasksMemoryPerNode.put(node.getNodeIdentifier(), ImmutableMap.of());
                    continue;
                }
                realtimeTasksMemoryPerNode.put(node.getNodeIdentifier(), memoryPoolInfo2.getTaskMemoryReservations());
            }
            HashMap<String, Long> preReservedMemory = new HashMap<String, Long>();
            this.speculativeMemoryReserved = new HashMap<String, Long>();
            HashMultimap fulfilledAcquiresByNode = HashMultimap.create();
            for (BinPackingNodeLease fulfilledAcquire : fulfilledAcquires) {
                InternalNode node = fulfilledAcquire.getAssignedNode();
                long memoryLease = fulfilledAcquire.getMemoryLease();
                if (ignoreAcquiredSpeculative && fulfilledAcquire.isSpeculative()) {
                    this.speculativeMemoryReserved.merge(node.getNodeIdentifier(), memoryLease, Long::sum);
                    continue;
                }
                fulfilledAcquiresByNode.put((Object)node.getNodeIdentifier(), (Object)fulfilledAcquire);
                preReservedMemory.merge(node.getNodeIdentifier(), memoryLease, Long::sum);
            }
            this.nodesRemainingMemory = new HashMap<String, Long>();
            for (InternalNode node : nodesSnapshot.getAllNodes()) {
                memoryPoolInfo = nodeMemoryPoolInfos.get(node.getNodeIdentifier());
                if (memoryPoolInfo == null) {
                    this.nodesRemainingMemory.put(node.getNodeIdentifier(), 0L);
                    continue;
                }
                long nodeReservedMemory = preReservedMemory.getOrDefault(node.getNodeIdentifier(), 0L);
                this.nodesRemainingMemory.put(node.getNodeIdentifier(), Math.max(memoryPoolInfo.getMaxBytes() + nodeMemoryOvercommit.toBytes() - nodeReservedMemory, 0L));
            }
            this.nodesRemainingMemoryRuntimeAdjusted = new HashMap<String, Long>();
            for (InternalNode node : nodesSnapshot.getAllNodes()) {
                memoryPoolInfo = nodeMemoryPoolInfos.get(node.getNodeIdentifier());
                if (memoryPoolInfo == null) {
                    this.nodesRemainingMemoryRuntimeAdjusted.put(node.getNodeIdentifier(), 0L);
                    continue;
                }
                Map realtimeNodeMemory = (Map)realtimeTasksMemoryPerNode.get(node.getNodeIdentifier());
                Set nodeFulfilledAcquires = fulfilledAcquiresByNode.get((Object)node.getNodeIdentifier());
                long nodeUsedMemoryRuntimeAdjusted = 0L;
                for (BinPackingNodeLease lease : nodeFulfilledAcquires) {
                    long realtimeTaskMemory = 0L;
                    if (lease.getAttachedTaskId().isPresent()) {
                        realtimeTaskMemory = realtimeNodeMemory.getOrDefault(lease.getAttachedTaskId().get().toString(), 0L);
                        realtimeTaskMemory += taskRuntimeMemoryEstimationOverhead.toBytes();
                    }
                    long reservedTaskMemory = lease.getMemoryLease();
                    nodeUsedMemoryRuntimeAdjusted += Math.max(realtimeTaskMemory, reservedTaskMemory);
                }
                nodeUsedMemoryRuntimeAdjusted = Math.max(nodeUsedMemoryRuntimeAdjusted, memoryPoolInfo.getReservedBytes());
                this.nodesRemainingMemoryRuntimeAdjusted.put(node.getNodeIdentifier(), Math.max(memoryPoolInfo.getMaxBytes() + nodeMemoryOvercommit.toBytes() - nodeUsedMemoryRuntimeAdjusted, 0L));
            }
        }

        private List<InternalNode> dropCoordinatorsIfNecessary(List<InternalNode> candidates) {
            return this.scheduleOnCoordinator ? candidates : (List)candidates.stream().filter(node -> !node.isCoordinator()).collect(ImmutableList.toImmutableList());
        }

        public ReserveResult tryReserve(PendingAcquire acquire) {
            NodeRequirements requirements = acquire.getNodeRequirements();
            Optional<Set> catalogNodes = requirements.getCatalogHandle().map(this.nodesSnapshot::getConnectorNodes);
            List<InternalNode> candidates = new ArrayList<InternalNode>(this.allNodesSorted);
            catalogNodes.ifPresent(candidates::retainAll);
            Set<HostAddress> addresses = requirements.getAddresses();
            candidates = !addresses.isEmpty() ? (List)candidates.stream().filter(node -> addresses.contains(node.getHostAndPort())).collect(ImmutableList.toImmutableList()) : this.dropCoordinatorsIfNecessary(candidates);
            if (candidates.isEmpty()) {
                return ReserveResult.NONE_MATCHING;
            }
            Comparator<InternalNode> comparator = Comparator.comparing(node -> this.nodesRemainingMemoryRuntimeAdjusted.get(node.getNodeIdentifier()));
            if (this.ignoreAcquiredSpeculative) {
                comparator = this.resolveTiesWithSpeculativeMemory(comparator);
            }
            InternalNode selectedNode = candidates.stream().max(comparator).orElseThrow();
            long memoryRequirements = acquire.getMemoryLease();
            if (this.nodesRemainingMemoryRuntimeAdjusted.get(selectedNode.getNodeIdentifier()) >= memoryRequirements || this.isNodeEmpty(selectedNode.getNodeIdentifier())) {
                this.subtractFromRemainingMemory(selectedNode.getNodeIdentifier(), memoryRequirements);
                return ReserveResult.reserved(selectedNode);
            }
            Comparator<InternalNode> fallbackComparator = Comparator.comparing(node -> this.nodesRemainingMemory.get(node.getNodeIdentifier()));
            if (this.ignoreAcquiredSpeculative) {
                fallbackComparator = this.resolveTiesWithSpeculativeMemory(fallbackComparator);
            }
            InternalNode fallbackNode = candidates.stream().max(fallbackComparator).orElseThrow();
            this.subtractFromRemainingMemory(fallbackNode.getNodeIdentifier(), memoryRequirements);
            return ReserveResult.NOT_ENOUGH_RESOURCES_NOW;
        }

        private Comparator<InternalNode> resolveTiesWithSpeculativeMemory(Comparator<InternalNode> comparator) {
            return comparator.thenComparing(node -> -this.speculativeMemoryReserved.getOrDefault(node.getNodeIdentifier(), 0L).longValue());
        }

        private void subtractFromRemainingMemory(String nodeIdentifier, long memoryLease) {
            this.nodesRemainingMemoryRuntimeAdjusted.compute(nodeIdentifier, (key, free) -> Math.max(free - memoryLease, 0L));
            this.nodesRemainingMemory.compute(nodeIdentifier, (key, free) -> Math.max(free - memoryLease, 0L));
        }

        private boolean isNodeEmpty(String nodeIdentifier) {
            return this.nodeMemoryPoolInfos.containsKey(nodeIdentifier) && this.nodesRemainingMemory.get(nodeIdentifier).equals(this.nodeMemoryPoolInfos.get(nodeIdentifier).getMaxBytes());
        }

        public static class ReserveResult {
            public static final ReserveResult NONE_MATCHING = new ReserveResult(ReservationStatus.NONE_MATCHING, Optional.empty());
            public static final ReserveResult NOT_ENOUGH_RESOURCES_NOW = new ReserveResult(ReservationStatus.NOT_ENOUGH_RESOURCES_NOW, Optional.empty());
            private final ReservationStatus status;
            private final Optional<InternalNode> node;

            public static ReserveResult reserved(InternalNode node) {
                return new ReserveResult(ReservationStatus.RESERVED, Optional.of(node));
            }

            private ReserveResult(ReservationStatus status, Optional<InternalNode> node) {
                this.status = Objects.requireNonNull(status, "status is null");
                this.node = Objects.requireNonNull(node, "node is null");
                Preconditions.checkArgument((node.isPresent() == (status == ReservationStatus.RESERVED) ? 1 : 0) != 0, (Object)"node must be set iff status is RESERVED");
            }

            public ReservationStatus getStatus() {
                return this.status;
            }

            public InternalNode getNode() {
                return this.node.orElseThrow(() -> new IllegalStateException("node not set"));
            }
        }

        public static enum ReservationStatus {
            NONE_MATCHING,
            NOT_ENOUGH_RESOURCES_NOW,
            RESERVED;

        }
    }

    private static class PendingAcquire {
        private final NodeRequirements nodeRequirements;
        private final BinPackingNodeLease lease;
        private final Stopwatch noMatchingNodeStopwatch;

        private PendingAcquire(NodeRequirements nodeRequirements, BinPackingNodeLease lease, Ticker ticker) {
            this.nodeRequirements = Objects.requireNonNull(nodeRequirements, "nodeRequirements is null");
            this.lease = Objects.requireNonNull(lease, "lease is null");
            this.noMatchingNodeStopwatch = Stopwatch.createUnstarted((Ticker)ticker);
        }

        public NodeRequirements getNodeRequirements() {
            return this.nodeRequirements;
        }

        public BinPackingNodeLease getLease() {
            return this.lease;
        }

        public SettableFuture<InternalNode> getFuture() {
            return this.lease.getNodeSettableFuture();
        }

        public long getMemoryLease() {
            return this.lease.getMemoryLease();
        }

        public Duration markNoMatchingNodeFound() {
            if (!this.noMatchingNodeStopwatch.isRunning()) {
                this.noMatchingNodeStopwatch.start();
            }
            return this.noMatchingNodeStopwatch.elapsed();
        }

        public void resetNoMatchingNodeFound() {
            this.noMatchingNodeStopwatch.reset();
        }

        public boolean isSpeculative() {
            return this.lease.isSpeculative();
        }

        public TaskExecutionClass getExecutionClass() {
            return this.lease.getExecutionClass();
        }
    }

    private class BinPackingNodeLease
    implements NodeAllocator.NodeLease {
        private final SettableFuture<InternalNode> node = SettableFuture.create();
        private final AtomicBoolean released = new AtomicBoolean();
        private final AtomicLong memoryLease;
        private final AtomicReference<TaskId> taskId = new AtomicReference();
        private final AtomicReference<TaskExecutionClass> executionClass;

        private BinPackingNodeLease(long memoryLease, TaskExecutionClass executionClass) {
            this.memoryLease = new AtomicLong(memoryLease);
            Objects.requireNonNull(executionClass, "executionClass is null");
            this.executionClass = new AtomicReference<TaskExecutionClass>(executionClass);
        }

        @Override
        public ListenableFuture<InternalNode> getNode() {
            return this.node;
        }

        InternalNode getAssignedNode() {
            try {
                return (InternalNode)Futures.getDone(this.node);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        SettableFuture<InternalNode> getNodeSettableFuture() {
            return this.node;
        }

        @Override
        public void attachTaskId(TaskId taskId) {
            if (!this.taskId.compareAndSet(null, taskId)) {
                throw new IllegalStateException("cannot attach taskId " + String.valueOf(taskId) + "; already attached to " + String.valueOf(this.taskId.get()));
            }
        }

        @Override
        public void setExecutionClass(TaskExecutionClass newExecutionClass) {
            TaskExecutionClass changedFrom = this.executionClass.getAndUpdate(oldExecutionClass -> {
                Preconditions.checkArgument((boolean)oldExecutionClass.canTransitionTo(newExecutionClass), (String)"cannot change execution class from %s to %s", (Object)oldExecutionClass, (Object)((Object)newExecutionClass));
                return newExecutionClass;
            });
            if (changedFrom != newExecutionClass) {
                BinPackingNodeAllocatorService.this.wakeupProcessPendingAcquires();
            }
        }

        public boolean isSpeculative() {
            return this.executionClass.get().isSpeculative();
        }

        public TaskExecutionClass getExecutionClass() {
            return this.executionClass.get();
        }

        public Optional<TaskId> getAttachedTaskId() {
            return Optional.ofNullable(this.taskId.get());
        }

        @Override
        public void setMemoryRequirement(DataSize memoryRequirement) {
            long previousBytes;
            long newBytes = memoryRequirement.toBytes();
            if (newBytes < (previousBytes = this.memoryLease.getAndSet(newBytes))) {
                BinPackingNodeAllocatorService.this.wakeupProcessPendingAcquires();
            }
        }

        public long getMemoryLease() {
            return this.memoryLease.get();
        }

        @Override
        public void release() {
            if (this.released.compareAndSet(false, true)) {
                this.node.cancel(true);
                if (this.node.isDone() && !this.node.isCancelled()) {
                    Preconditions.checkState((boolean)BinPackingNodeAllocatorService.this.fulfilledAcquires.remove(this), (String)"node lease %s not found in fulfilledAcquires %s", (Object)this, BinPackingNodeAllocatorService.this.fulfilledAcquires);
                    BinPackingNodeAllocatorService.this.wakeupProcessPendingAcquires();
                }
            } else {
                throw new IllegalStateException("Node " + String.valueOf(this.node) + " already released");
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("node", this.node).add("released", (Object)this.released).add("memoryLease", (Object)this.memoryLease).add("taskId", this.taskId).add("executionClass", this.executionClass).toString();
        }
    }
}

