/*
 * Decompiled with CFR 0.152.
 */
package io.trino.json;

import com.fasterxml.jackson.databind.JsonNode;
import io.trino.json.CachingResolver;
import io.trino.json.PathEvaluationContext;
import io.trino.json.PathEvaluationVisitor;
import io.trino.json.ir.IrJsonPath;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.TypeManager;
import io.trino.sql.InterpretedFunctionInvoker;
import java.util.List;
import java.util.Objects;

public class JsonPathEvaluator {
    private final IrJsonPath path;
    private final Invoker invoker;
    private final CachingResolver resolver;

    public JsonPathEvaluator(IrJsonPath path, ConnectorSession session, Metadata metadata, TypeManager typeManager, FunctionManager functionManager) {
        Objects.requireNonNull(path, "path is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(typeManager, "typeManager is null");
        Objects.requireNonNull(functionManager, "functionManager is null");
        this.path = path;
        this.invoker = new Invoker(session, functionManager);
        this.resolver = new CachingResolver(metadata);
    }

    public List<Object> evaluate(JsonNode input, Object[] parameters) {
        return (List)new PathEvaluationVisitor(this.path.isLax(), input, parameters, this.invoker, this.resolver).process(this.path.getRoot(), new PathEvaluationContext());
    }

    public static class Invoker {
        private final ConnectorSession connectorSession;
        private final InterpretedFunctionInvoker functionInvoker;

        public Invoker(ConnectorSession connectorSession, FunctionManager functionManager) {
            this.connectorSession = connectorSession;
            this.functionInvoker = new InterpretedFunctionInvoker(functionManager);
        }

        public Object invoke(ResolvedFunction function, List<Object> arguments) {
            return this.functionInvoker.invoke(function, this.connectorSession, arguments);
        }
    }
}

