/*
 * Decompiled with CFR 0.152.
 */
package io.trino.likematcher;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

record DFA(int start, IntArrayList acceptStates, List<List<Transition>> transitions) {
    DFA {
        Objects.requireNonNull(acceptStates, "acceptStates is null");
        transitions = ImmutableList.copyOf(transitions);
    }

    public static class Builder {
        private int nextId;
        private int start;
        private final IntArrayList acceptStates = new IntArrayList();
        private final List<List<Transition>> transitions = new ArrayList<List<Transition>>();

        public int addState(boolean accept) {
            int state = this.nextId++;
            this.transitions.add(new ArrayList());
            if (accept) {
                this.acceptStates.add(state);
            }
            return state;
        }

        public int addStartState(boolean accept) {
            this.start = this.addState(accept);
            return this.start;
        }

        public void addTransition(int from, int value, int to) {
            this.transitions.get(from).add(new Transition(value, to));
        }

        public DFA build() {
            return new DFA(this.start, this.acceptStates, this.transitions);
        }
    }

    record Transition(int value, int target) {
        @Override
        public String toString() {
            return String.format("-[%s]-> %s", this.value, this.target);
        }
    }
}

