/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.ImmutableMap;
import io.trino.execution.TaskId;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.LanguageFunctionProvider;
import io.trino.metadata.LanguageScalarFunctionData;
import io.trino.metadata.ResolvedFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.function.FunctionDependencies;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.ScalarFunctionImplementation;
import io.trino.sql.routine.SqlRoutineCompiler;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class WorkerLanguageFunctionProvider
implements LanguageFunctionProvider {
    private final Map<TaskId, Map<ResolvedFunction, LanguageScalarFunctionData>> queryFunctions = new ConcurrentHashMap<TaskId, Map<ResolvedFunction, LanguageScalarFunctionData>>();

    @Override
    public void registerTask(TaskId taskId, List<LanguageScalarFunctionData> functions) {
        this.queryFunctions.computeIfAbsent(taskId, ignored -> (Map)functions.stream().collect(ImmutableMap.toImmutableMap(LanguageScalarFunctionData::resolvedFunction, Function.identity())));
    }

    @Override
    public void unregisterTask(TaskId taskId) {
        this.queryFunctions.remove(taskId);
    }

    @Override
    public ScalarFunctionImplementation specialize(FunctionManager functionManager, ResolvedFunction resolvedFunction, FunctionDependencies functionDependencies, InvocationConvention invocationConvention) {
        LanguageScalarFunctionData functionData = this.queryFunctions.values().stream().map(queryFunctions -> (LanguageScalarFunctionData)queryFunctions.get(resolvedFunction)).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalStateException("Unknown function implementation: " + String.valueOf(resolvedFunction.getFunctionId())));
        SpecializedSqlScalarFunction function = new SqlRoutineCompiler(functionManager).compile(functionData.routine());
        return function.getScalarFunctionImplementation(invocationConvention);
    }
}

