/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class AggregationHeader {
    private final String name;
    private final Set<String> aliases;
    private final Optional<String> description;
    private final boolean decomposable;
    private final boolean orderSensitive;
    private final boolean hidden;
    private final boolean deprecated;

    public AggregationHeader(String name, Set<String> aliases, Optional<String> description, boolean decomposable, boolean orderSensitive, boolean hidden, boolean deprecated) {
        this.name = Objects.requireNonNull(name, "name cannot be null");
        this.aliases = ImmutableSet.copyOf(aliases);
        this.description = Objects.requireNonNull(description, "description cannot be null");
        this.decomposable = decomposable;
        this.orderSensitive = orderSensitive;
        this.hidden = hidden;
        this.deprecated = deprecated;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    public boolean isDecomposable() {
        return this.decomposable;
    }

    public boolean isOrderSensitive() {
        return this.orderSensitive;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("aliases", this.aliases).add("description", this.description).add("decomposable", this.decomposable).add("orderSensitive", this.orderSensitive).add("hidden", this.hidden).toString();
    }
}

