/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.minmaxbyn;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.airlift.slice.SizeOf;
import io.trino.operator.VariableWidthData;
import io.trino.operator.aggregation.minmaxn.TypedHeap;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.Type;
import it.unimi.dsi.fastutil.ints.IntArrays;
import jakarta.annotation.Nullable;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.Objects;

public final class TypedKeyValueHeap {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(TypedKeyValueHeap.class);
    private final boolean min;
    private final MethodHandle keyReadFlat;
    private final MethodHandle keyWriteFlat;
    private final MethodHandle valueReadFlat;
    private final MethodHandle valueWriteFlat;
    private final MethodHandle compareFlatFlat;
    private final MethodHandle compareFlatBlock;
    private final Type keyType;
    private final Type valueType;
    private final int capacity;
    private final int recordValueNullOffset;
    private final int recordKeyOffset;
    private final int recordValueOffset;
    private final int recordSize;
    private final byte[] fixedChunk;
    private final boolean keyVariableWidth;
    private final boolean valueVariableWidth;
    private VariableWidthData variableWidthData;
    private int positionCount;

    public TypedKeyValueHeap(boolean min, MethodHandle keyReadFlat, MethodHandle keyWriteFlat, MethodHandle valueReadFlat, MethodHandle valueWriteFlat, MethodHandle compareFlatFlat, MethodHandle compareFlatBlock, Type keyType, Type valueType, int capacity) {
        this.min = min;
        this.keyReadFlat = Objects.requireNonNull(keyReadFlat, "keyReadFlat is null");
        this.keyWriteFlat = Objects.requireNonNull(keyWriteFlat, "keyWriteFlat is null");
        this.valueReadFlat = Objects.requireNonNull(valueReadFlat, "valueReadFlat is null");
        this.valueWriteFlat = Objects.requireNonNull(valueWriteFlat, "valueWriteFlat is null");
        this.compareFlatFlat = Objects.requireNonNull(compareFlatFlat, "compareFlatFlat is null");
        this.compareFlatBlock = Objects.requireNonNull(compareFlatBlock, "compareFlatBlock is null");
        this.keyType = Objects.requireNonNull(keyType, "keyType is null");
        this.valueType = Objects.requireNonNull(valueType, "valueType is null");
        this.capacity = capacity;
        this.keyVariableWidth = keyType.isFlatVariableWidth();
        this.valueVariableWidth = valueType.isFlatVariableWidth();
        boolean variableWidth = this.keyVariableWidth || this.valueVariableWidth;
        this.variableWidthData = variableWidth ? new VariableWidthData() : null;
        this.recordValueNullOffset = variableWidth ? 12 : 0;
        this.recordKeyOffset = this.recordValueNullOffset + 1;
        this.recordValueOffset = this.recordKeyOffset + keyType.getFlatFixedSize();
        this.recordSize = this.recordValueOffset + valueType.getFlatFixedSize();
        this.fixedChunk = new byte[this.recordSize * (capacity + 1)];
    }

    public TypedKeyValueHeap(TypedKeyValueHeap typedHeap) {
        this.min = typedHeap.min;
        this.keyReadFlat = typedHeap.keyReadFlat;
        this.keyWriteFlat = typedHeap.keyWriteFlat;
        this.valueReadFlat = typedHeap.valueReadFlat;
        this.valueWriteFlat = typedHeap.valueWriteFlat;
        this.compareFlatFlat = typedHeap.compareFlatFlat;
        this.compareFlatBlock = typedHeap.compareFlatBlock;
        this.keyType = typedHeap.keyType;
        this.valueType = typedHeap.valueType;
        this.capacity = typedHeap.capacity;
        this.positionCount = typedHeap.positionCount;
        this.keyVariableWidth = typedHeap.keyVariableWidth;
        this.valueVariableWidth = typedHeap.valueVariableWidth;
        this.recordValueNullOffset = typedHeap.recordValueNullOffset;
        this.recordKeyOffset = typedHeap.recordKeyOffset;
        this.recordValueOffset = typedHeap.recordValueOffset;
        this.recordSize = typedHeap.recordSize;
        this.fixedChunk = Arrays.copyOf(typedHeap.fixedChunk, typedHeap.fixedChunk.length);
        this.variableWidthData = typedHeap.variableWidthData != null ? new VariableWidthData(typedHeap.variableWidthData) : null;
    }

    public Type getKeyType() {
        return this.keyType;
    }

    public Type getValueType() {
        return this.valueType;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public long getEstimatedSize() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((byte[])this.fixedChunk) + (this.variableWidthData == null ? 0L : this.variableWidthData.getRetainedSizeBytes());
    }

    public boolean isEmpty() {
        return this.positionCount == 0;
    }

    public void writeAllUnsorted(BlockBuilder keyBuilder, BlockBuilder valueBuilder) {
        for (int i = 0; i < this.positionCount; ++i) {
            this.write(i, keyBuilder, valueBuilder);
        }
    }

    public void writeValuesSorted(BlockBuilder valueBlockBuilder) {
        int[] indexes = new int[this.positionCount];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = i;
        }
        IntArrays.quickSort((int[])indexes, (a, b) -> this.compare(a, b));
        for (int index : indexes) {
            this.write(index, null, valueBlockBuilder);
        }
    }

    private void write(int index, @Nullable BlockBuilder keyBlockBuilder, BlockBuilder valueBlockBuilder) {
        int recordOffset = this.getRecordOffset(index);
        byte[] variableWidthChunk = VariableWidthData.EMPTY_CHUNK;
        if (this.variableWidthData != null) {
            variableWidthChunk = this.variableWidthData.getChunk(this.fixedChunk, recordOffset);
        }
        if (keyBlockBuilder != null) {
            try {
                this.keyReadFlat.invokeExact(this.fixedChunk, recordOffset + this.recordKeyOffset, variableWidthChunk, keyBlockBuilder);
            }
            catch (Throwable throwable) {
                Throwables.throwIfUnchecked((Throwable)throwable);
                throw new RuntimeException(throwable);
            }
        }
        if (this.fixedChunk[recordOffset + this.recordValueNullOffset] != 0) {
            valueBlockBuilder.appendNull();
        } else {
            try {
                this.valueReadFlat.invokeExact(this.fixedChunk, recordOffset + this.recordValueOffset, variableWidthChunk, valueBlockBuilder);
            }
            catch (Throwable throwable) {
                Throwables.throwIfUnchecked((Throwable)throwable);
                throw new RuntimeException(throwable);
            }
        }
    }

    public void add(ValueBlock keyBlock, int keyPosition, ValueBlock valueBlock, int valuePosition) {
        Preconditions.checkArgument((!keyBlock.isNull(keyPosition) ? 1 : 0) != 0);
        if (this.positionCount == this.capacity) {
            if (!this.shouldConsiderValue(keyBlock, keyPosition)) {
                return;
            }
            this.clear(0);
            this.set(0, keyBlock, keyPosition, valueBlock, valuePosition);
            this.siftDown();
        } else {
            this.set(this.positionCount, keyBlock, keyPosition, valueBlock, valuePosition);
            ++this.positionCount;
            this.siftUp();
        }
    }

    private void clear(int index) {
        if (this.variableWidthData == null) {
            return;
        }
        this.variableWidthData.free(this.fixedChunk, this.getRecordOffset(index));
        this.variableWidthData = TypedHeap.compactIfNecessary(this.variableWidthData, this.fixedChunk, this.recordSize, 0, this.positionCount, (fixedSizeOffset, variableWidthChunk, variableWidthChunkOffset) -> {
            int keyVariableWidth = this.keyType.relocateFlatVariableWidthOffsets(this.fixedChunk, fixedSizeOffset + this.recordKeyOffset, variableWidthChunk, variableWidthChunkOffset);
            if (this.fixedChunk[fixedSizeOffset + this.recordValueNullOffset] == 0) {
                this.valueType.relocateFlatVariableWidthOffsets(this.fixedChunk, fixedSizeOffset + this.recordValueOffset, variableWidthChunk, variableWidthChunkOffset + keyVariableWidth);
            }
        });
    }

    private void set(int index, ValueBlock keyBlock, int keyPosition, ValueBlock valueBlock, int valuePosition) {
        int recordOffset = this.getRecordOffset(index);
        byte[] variableWidthChunk = VariableWidthData.EMPTY_CHUNK;
        int variableWidthChunkOffset = 0;
        int keyVariableWidthLength = 0;
        if (this.variableWidthData != null) {
            if (this.keyVariableWidth) {
                keyVariableWidthLength = this.keyType.getFlatVariableWidthSize((Block)keyBlock, keyPosition);
            }
            int valueVariableWidthLength = this.valueType.getFlatVariableWidthSize((Block)valueBlock, valuePosition);
            variableWidthChunk = this.variableWidthData.allocate(this.fixedChunk, recordOffset, keyVariableWidthLength + valueVariableWidthLength);
            variableWidthChunkOffset = VariableWidthData.getChunkOffset(this.fixedChunk, recordOffset);
        }
        try {
            this.keyWriteFlat.invokeExact(keyBlock, keyPosition, this.fixedChunk, recordOffset + this.recordKeyOffset, variableWidthChunk, variableWidthChunkOffset);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
        if (valueBlock.isNull(valuePosition)) {
            this.fixedChunk[recordOffset + this.recordValueNullOffset] = 1;
        } else {
            try {
                this.valueWriteFlat.invokeExact(valueBlock, valuePosition, this.fixedChunk, recordOffset + this.recordValueOffset, variableWidthChunk, variableWidthChunkOffset + keyVariableWidthLength);
            }
            catch (Throwable throwable) {
                Throwables.throwIfUnchecked((Throwable)throwable);
                throw new RuntimeException(throwable);
            }
        }
    }

    private void siftDown() {
        int leftPosition;
        int position = 0;
        while ((leftPosition = position * 2 + 1) < this.positionCount) {
            int smallerChildPosition;
            int rightPosition = leftPosition + 1;
            if (rightPosition >= this.positionCount) {
                smallerChildPosition = leftPosition;
            } else {
                int n = smallerChildPosition = this.compare(leftPosition, rightPosition) < 0 ? rightPosition : leftPosition;
            }
            if (this.compare(smallerChildPosition, position) < 0) break;
            this.swap(position, smallerChildPosition);
            position = smallerChildPosition;
        }
    }

    private void siftUp() {
        int parentPosition;
        int position = this.positionCount - 1;
        while (position != 0 && this.compare(position, parentPosition = (position - 1) / 2) >= 0) {
            this.swap(position, parentPosition);
            position = parentPosition;
        }
    }

    private void swap(int leftPosition, int rightPosition) {
        int leftOffset = this.getRecordOffset(leftPosition);
        int rightOffset = this.getRecordOffset(rightPosition);
        int tempOffset = this.getRecordOffset(this.capacity);
        System.arraycopy(this.fixedChunk, leftOffset, this.fixedChunk, tempOffset, this.recordSize);
        System.arraycopy(this.fixedChunk, rightOffset, this.fixedChunk, leftOffset, this.recordSize);
        System.arraycopy(this.fixedChunk, tempOffset, this.fixedChunk, rightOffset, this.recordSize);
    }

    private int compare(int leftPosition, int rightPosition) {
        int leftRecordOffset = this.getRecordOffset(leftPosition);
        int rightRecordOffset = this.getRecordOffset(rightPosition);
        byte[] leftVariableWidthChunk = VariableWidthData.EMPTY_CHUNK;
        byte[] rightVariableWidthChunk = VariableWidthData.EMPTY_CHUNK;
        if (this.keyVariableWidth) {
            leftVariableWidthChunk = this.variableWidthData.getChunk(this.fixedChunk, leftRecordOffset);
            rightVariableWidthChunk = this.variableWidthData.getChunk(this.fixedChunk, rightRecordOffset);
        }
        try {
            long result = this.compareFlatFlat.invokeExact(this.fixedChunk, leftRecordOffset + this.recordKeyOffset, leftVariableWidthChunk, this.fixedChunk, rightRecordOffset + this.recordKeyOffset, rightVariableWidthChunk);
            return (int)(this.min ? result : -result);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    private boolean shouldConsiderValue(ValueBlock right, int rightPosition) {
        byte[] leftFixedRecordChunk = this.fixedChunk;
        int leftRecordOffset = this.getRecordOffset(0);
        byte[] leftVariableWidthChunk = VariableWidthData.EMPTY_CHUNK;
        if (this.keyVariableWidth) {
            leftVariableWidthChunk = this.variableWidthData.getChunk(leftFixedRecordChunk, leftRecordOffset);
        }
        try {
            long result = this.compareFlatBlock.invokeExact(leftFixedRecordChunk, leftRecordOffset + this.recordKeyOffset, leftVariableWidthChunk, right, rightPosition);
            return this.min ? result > 0L : result < 0L;
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    private int getRecordOffset(int index) {
        return index * this.recordSize;
    }
}

