/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.operator.aggregation.state.LongDecimalWithOverflowAndLongState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;

public class LongDecimalWithOverflowAndLongStateSerializer
implements AccumulatorStateSerializer<LongDecimalWithOverflowAndLongState> {
    public Type getSerializedType() {
        return VarbinaryType.VARBINARY;
    }

    public void serialize(LongDecimalWithOverflowAndLongState state, BlockBuilder out) {
        long count = state.getLong();
        if (count == 0L) {
            out.appendNull();
            return;
        }
        long overflow = state.getOverflow();
        long[] decimal = state.getDecimalArray();
        int offset = state.getDecimalArrayOffset();
        Slice buffer = Slices.allocate((int)32);
        long high = decimal[offset];
        long low = decimal[offset + 1];
        buffer.setLong(0, low);
        buffer.setLong(8, high);
        int countOffset = 1 + (high == 0L ? 0 : 1);
        buffer.setLong(8 * countOffset, count);
        buffer.setLong(8 * (countOffset + 1), overflow);
        int bufferLength = countOffset + (overflow == 0L & count == 1L ? 0 : 2);
        VarbinaryType.VARBINARY.writeSlice(out, buffer, 0, bufferLength * 8);
    }

    public void deserialize(Block block, int index, LongDecimalWithOverflowAndLongState state) {
        if (block.isNull(index)) {
            return;
        }
        VariableWidthBlock variableWidthBlock = (VariableWidthBlock)block;
        Slice slice = variableWidthBlock.getRawSlice();
        int sliceOffset = variableWidthBlock.getRawSliceOffset(index);
        int sliceLength = variableWidthBlock.getSliceLength(index);
        long[] decimal = state.getDecimalArray();
        int offset = state.getDecimalArrayOffset();
        long low = slice.getLong(sliceOffset);
        long high = 0L;
        long overflow = 0L;
        long count = 1L;
        switch (sliceLength) {
            case 32: {
                overflow = slice.getLong(sliceOffset + 24);
                count = slice.getLong(sliceOffset + 16);
            }
            case 16: {
                high = slice.getLong(sliceOffset + 8);
                break;
            }
            case 24: {
                overflow = slice.getLong(sliceOffset + 16);
                count = slice.getLong(sliceOffset + 8);
            }
        }
        decimal[offset + 1] = low;
        decimal[offset] = high;
        state.setOverflow(overflow);
        state.setLong(count);
    }
}

