/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join.unspilled;

import com.google.common.io.Closer;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.trino.operator.OperatorInfo;
import io.trino.operator.PageBuffer;
import io.trino.operator.ProcessorContext;
import io.trino.operator.WorkProcessor;
import io.trino.operator.WorkProcessorOperatorAdapter;
import io.trino.operator.join.JoinStatisticsCounter;
import io.trino.operator.join.LookupJoinOperatorFactory;
import io.trino.operator.join.LookupSource;
import io.trino.operator.join.unspilled.JoinProbe;
import io.trino.operator.join.unspilled.PageJoiner;
import io.trino.operator.join.unspilled.PartitionedLookupSourceFactory;
import io.trino.spi.Page;
import io.trino.spi.type.Type;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;

public class LookupJoinOperator
implements WorkProcessorOperatorAdapter.AdapterWorkProcessorOperator {
    private final ListenableFuture<LookupSource> lookupSourceFuture;
    private final boolean waitForBuild;
    private final PageBuffer pageBuffer;
    private final WorkProcessor<Page> pages;
    private final JoinStatisticsCounter statisticsCounter;
    private final Runnable afterClose;
    private final PageJoiner sourcePagesJoiner;
    private final WorkProcessor<Page> joinedSourcePages;
    private boolean closed;

    LookupJoinOperator(List<Type> buildOutputTypes, LookupJoinOperatorFactory.JoinType joinType, boolean outputSingleMatch, boolean waitForBuild, PartitionedLookupSourceFactory lookupSourceFactory, JoinProbe.JoinProbeFactory joinProbeFactory, Runnable afterClose, ProcessorContext processorContext, Optional<WorkProcessor<Page>> sourcePages) {
        this.statisticsCounter = new JoinStatisticsCounter(joinType);
        this.waitForBuild = waitForBuild;
        this.lookupSourceFuture = lookupSourceFactory.createLookupSource();
        this.pageBuffer = new PageBuffer();
        this.afterClose = Objects.requireNonNull(afterClose, "afterClose is null");
        this.sourcePagesJoiner = new PageJoiner(processorContext, buildOutputTypes, joinType, outputSingleMatch, joinProbeFactory, this.lookupSourceFuture, this.statisticsCounter);
        this.joinedSourcePages = sourcePages.orElse(this.pageBuffer.pages()).transform(this.sourcePagesJoiner);
        this.pages = WorkProcessor.flatten(WorkProcessor.create(this::process));
    }

    @Override
    public Optional<OperatorInfo> getOperatorInfo() {
        return Optional.of(this.statisticsCounter.get());
    }

    @Override
    public boolean needsInput() {
        return (!this.waitForBuild || this.lookupSourceFuture.isDone()) && this.pageBuffer.isEmpty() && !this.pageBuffer.isFinished();
    }

    @Override
    public void addInput(Page page) {
        this.pageBuffer.add(page);
    }

    @Override
    public void finish() {
        this.pageBuffer.finish();
    }

    @Override
    public WorkProcessor<Page> getOutputPages() {
        return this.pages;
    }

    public WorkProcessor.ProcessState<WorkProcessor<Page>> process() {
        if (this.waitForBuild && !this.lookupSourceFuture.isDone()) {
            return WorkProcessor.ProcessState.blocked(LookupJoinOperator.asVoid(this.lookupSourceFuture));
        }
        if (!this.joinedSourcePages.isFinished()) {
            return WorkProcessor.ProcessState.ofResult(this.joinedSourcePages);
        }
        this.close();
        return WorkProcessor.ProcessState.finished();
    }

    private static <T> ListenableFuture<Void> asVoid(ListenableFuture<T> future) {
        return Futures.transform(future, v -> null, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try (Closer closer = Closer.create();){
            closer.register(this.afterClose::run);
            closer.register((Closeable)this.sourcePagesJoiner);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

