/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import io.trino.type.BlockTypeOperators;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.Arrays;
import java.util.Objects;

public class BlockSet {
    public static final DataSize MAX_FUNCTION_MEMORY = DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private static final float FILL_RATIO = 0.75f;
    private static final int EMPTY_SLOT = -1;
    private final Type elementType;
    private final BlockTypeOperators.BlockPositionIsDistinctFrom elementDistinctFromOperator;
    private final BlockTypeOperators.BlockPositionHashCode elementHashCodeOperator;
    private final int[] blockPositionByHash;
    private final Block[] elementBlocks;
    private final int[] elementPositions;
    private int size;
    private final int maximumSize;
    private final int hashMask;
    private boolean containsNullElement;

    public BlockSet(Type elementType, BlockTypeOperators.BlockPositionIsDistinctFrom elementDistinctFromOperator, BlockTypeOperators.BlockPositionHashCode elementHashCodeOperator, int maximumSize) {
        Preconditions.checkArgument((maximumSize >= 0 ? 1 : 0) != 0, (Object)"maximumSize must not be negative");
        this.elementType = Objects.requireNonNull(elementType, "elementType is null");
        this.elementDistinctFromOperator = Objects.requireNonNull(elementDistinctFromOperator, "elementDistinctFromOperator is null");
        this.elementHashCodeOperator = Objects.requireNonNull(elementHashCodeOperator, "elementHashCodeOperator is null");
        this.maximumSize = maximumSize;
        int hashCapacity = HashCommon.arraySize((int)maximumSize, (float)0.75f);
        this.hashMask = hashCapacity - 1;
        this.blockPositionByHash = new int[hashCapacity];
        Arrays.fill(this.blockPositionByHash, -1);
        this.elementBlocks = new Block[maximumSize];
        this.elementPositions = new int[maximumSize];
        this.containsNullElement = false;
    }

    public boolean contains(Block block, int position) {
        Objects.requireNonNull(block, "block must not be null");
        Preconditions.checkArgument((position >= 0 ? 1 : 0) != 0, (Object)"position must be >= 0");
        if (block.isNull(position)) {
            return this.containsNullElement;
        }
        return this.positionOf(block, position) != -1;
    }

    public boolean add(Block block, int position) {
        int hashPosition;
        Objects.requireNonNull(block, "block must not be null");
        Preconditions.checkArgument((position >= 0 ? 1 : 0) != 0, (Object)"position must be >= 0");
        if (block.isNull(position)) {
            if (this.containsNullElement) {
                return false;
            }
            this.containsNullElement = true;
        }
        if (this.blockPositionByHash[hashPosition = this.getHashPositionOfElement(block, position)] == -1) {
            this.addNewElement(hashPosition, block, position);
            return true;
        }
        return false;
    }

    public int size() {
        return this.size;
    }

    public boolean containsNullElement() {
        return this.containsNullElement;
    }

    public int positionOf(Block block, int position) {
        return this.blockPositionByHash[this.getHashPositionOfElement(block, position)];
    }

    public void getAllWithSizeLimit(BlockBuilder blockBuilder, String functionName, DataSize maxFunctionMemory) {
        long initialSize = blockBuilder.getSizeInBytes();
        long maxBlockMemoryInBytes = Math.toIntExact(maxFunctionMemory.toBytes());
        for (int i = 0; i < this.size; ++i) {
            this.elementType.appendTo(this.elementBlocks[i], this.elementPositions[i], blockBuilder);
            if (blockBuilder.getSizeInBytes() - initialSize <= maxBlockMemoryInBytes) continue;
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.EXCEEDED_FUNCTION_MEMORY_LIMIT, "The input to %s is too large. More than %s of memory is needed to hold the output hash set.".formatted(functionName, maxFunctionMemory));
        }
    }

    private int getHashPositionOfElement(Block block, int position) {
        int hashPosition = this.getMaskedHash(this.elementHashCodeOperator.hashCodeNullSafe(block, position));
        int blockPosition;
        while ((blockPosition = this.blockPositionByHash[hashPosition]) != -1) {
            if (this.isNotDistinct(blockPosition, block, position)) {
                return hashPosition;
            }
            hashPosition = this.getMaskedHash(hashPosition + 1);
        }
        return hashPosition;
    }

    private void addNewElement(int hashPosition, Block block, int position) {
        Preconditions.checkState((this.size < this.maximumSize ? 1 : 0) != 0, (Object)"BlockSet is full");
        this.elementBlocks[this.size] = block;
        this.elementPositions[this.size] = position;
        this.blockPositionByHash[hashPosition] = this.size++;
    }

    private boolean isNotDistinct(int leftPosition, Block rightBlock, int rightPosition) {
        return !this.elementDistinctFromOperator.isDistinctFrom(this.elementBlocks[leftPosition], this.elementPositions[leftPosition], rightBlock, rightPosition);
    }

    private int getMaskedHash(long rawHash) {
        return (int)(rawHash & (long)this.hashMask);
    }
}

