/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.table.json.execution;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Throwables;
import io.trino.json.ir.IrJsonPath;
import io.trino.operator.table.json.execution.Column;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import java.lang.invoke.MethodHandle;
import java.util.Objects;

public class ValueColumn
implements Column {
    private final int outputIndex;
    private final MethodHandle methodHandle;
    private final IrJsonPath path;
    private final long emptyBehavior;
    private final int emptyDefaultInput;
    private final long errorBehavior;
    private final int errorDefaultInput;
    private final Type resultType;

    public ValueColumn(int outputIndex, MethodHandle methodHandle, IrJsonPath path, long emptyBehavior, int emptyDefaultInput, long errorBehavior, int errorDefaultInput, Type resultType) {
        this.outputIndex = outputIndex;
        this.methodHandle = Objects.requireNonNull(methodHandle, "methodHandle is null");
        this.path = Objects.requireNonNull(path, "path is null");
        this.emptyBehavior = emptyBehavior;
        this.emptyDefaultInput = emptyDefaultInput;
        this.errorBehavior = errorBehavior;
        this.errorDefaultInput = errorDefaultInput;
        this.resultType = Objects.requireNonNull(resultType, "resultType is null");
    }

    @Override
    public Object evaluate(long sequentialNumber, JsonNode item, Page input, int position) {
        Object emptyDefault = this.emptyDefaultInput == -1 ? null : TypeUtils.readNativeValue((Type)this.resultType, (Block)input.getBlock(this.emptyDefaultInput), (int)position);
        Object errorDefault = this.errorDefaultInput == -1 ? null : TypeUtils.readNativeValue((Type)this.resultType, (Block)input.getBlock(this.errorDefaultInput), (int)position);
        try {
            return this.methodHandle.invoke(item, this.path, null, this.emptyBehavior, emptyDefault, this.errorBehavior, errorDefault);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    @Override
    public int getOutputIndex() {
        return this.outputIndex;
    }
}

