/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window.matcher;

import io.airlift.slice.SizeOf;
import io.trino.operator.window.matcher.ArrayView;
import java.util.Arrays;

public class IntList {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(IntList.class);
    private int[] values;
    private int next;

    public IntList(int capacity) {
        this.values = new int[capacity];
    }

    private IntList(int[] values, int next) {
        this.values = values;
        this.next = next;
    }

    public void add(int value) {
        this.ensureCapacity(this.next);
        this.values[this.next] = value;
        ++this.next;
    }

    public int get(int index) {
        return this.values[index];
    }

    public void set(int index, int value) {
        this.ensureCapacity(index);
        this.values[index] = value;
        this.next = Math.max(this.next, index + 1);
    }

    public int size() {
        return this.next;
    }

    public void clear() {
        this.next = 0;
    }

    public IntList copy() {
        return new IntList((int[])this.values.clone(), this.next);
    }

    public ArrayView toArrayView() {
        return new ArrayView(this.values, this.next);
    }

    private void ensureCapacity(int index) {
        if (index >= this.values.length) {
            this.values = Arrays.copyOf(this.values, Math.max(this.values.length * 2, index + 1));
        }
    }

    public long getSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.values);
    }
}

