/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import io.trino.client.ProtocolDetectionException;
import io.trino.client.ProtocolHeaders;
import io.trino.server.ProtocolConfig;
import io.trino.server.security.AuthenticationException;
import io.trino.server.security.Authenticator;
import io.trino.server.security.BasicAuthCredentials;
import io.trino.server.security.InsecureAuthenticatorConfig;
import io.trino.server.security.UserMapping;
import io.trino.server.security.UserMappingException;
import io.trino.spi.security.BasicPrincipal;
import io.trino.spi.security.Identity;
import jakarta.ws.rs.container.ContainerRequestContext;
import java.security.Principal;
import java.util.Optional;
import java.util.Set;

public class InsecureAuthenticator
implements Authenticator {
    private final UserMapping userMapping;
    private final Optional<String> alternateHeaderName;

    @Inject
    public InsecureAuthenticator(InsecureAuthenticatorConfig config, ProtocolConfig protocolConfig) {
        this.userMapping = UserMapping.createUserMapping(config.getUserMappingPattern(), config.getUserMappingFile());
        this.alternateHeaderName = protocolConfig.getAlternateHeaderName();
    }

    @Override
    public Identity authenticate(ContainerRequestContext request) throws AuthenticationException {
        String user;
        Optional<BasicAuthCredentials> basicAuthCredentials = BasicAuthCredentials.extractBasicAuthCredentials(request);
        if (basicAuthCredentials.isPresent()) {
            if (basicAuthCredentials.get().getPassword().isPresent()) {
                throw new AuthenticationException("Password not allowed for insecure authentication", "Basic realm=\"Trino\"");
            }
            user = basicAuthCredentials.get().getUser();
        } else {
            try {
                ProtocolHeaders protocolHeaders = ProtocolHeaders.detectProtocol(this.alternateHeaderName, (Set)request.getHeaders().keySet());
                user = Strings.emptyToNull((String)((String)request.getHeaders().getFirst((Object)protocolHeaders.requestOriginalUser())));
                if (user == null) {
                    user = Strings.emptyToNull((String)((String)request.getHeaders().getFirst((Object)protocolHeaders.requestUser())));
                }
            }
            catch (ProtocolDetectionException e) {
                user = null;
            }
        }
        if (user == null) {
            throw new AuthenticationException("Basic authentication or " + ProtocolHeaders.TRINO_HEADERS.requestOriginalUser() + " or " + ProtocolHeaders.TRINO_HEADERS.requestUser() + " must be sent", "Basic realm=\"Trino\"");
        }
        try {
            String authenticatedUser = this.userMapping.mapUser(user);
            return Identity.forUser((String)authenticatedUser).withPrincipal((Principal)new BasicPrincipal(user)).build();
        }
        catch (UserMappingException e) {
            throw new AuthenticationException(e.getMessage());
        }
    }
}

