/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.ui;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Immutable;
import io.trino.execution.QueryState;
import io.trino.operator.RetryPolicy;
import io.trino.server.BasicQueryInfo;
import io.trino.server.BasicQueryStats;
import io.trino.spi.ErrorCode;
import io.trino.spi.ErrorType;
import io.trino.spi.QueryId;
import io.trino.spi.resourcegroups.QueryType;
import io.trino.spi.resourcegroups.ResourceGroupId;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class TrimmedBasicQueryInfo {
    private static final int MAX_QUERY_PREVIEW_LENGTH = 300;
    private final QueryId queryId;
    private final String sessionUser;
    private final Optional<String> sessionPrincipal;
    private final Optional<String> sessionSource;
    private final Optional<ResourceGroupId> resourceGroupId;
    private final QueryState state;
    private final boolean scheduled;
    private final URI self;
    private final String queryTextPreview;
    private final Optional<String> updateType;
    private final Optional<String> preparedQuery;
    private final BasicQueryStats queryStats;
    private final Optional<ErrorType> errorType;
    private final Optional<ErrorCode> errorCode;
    private final Optional<QueryType> queryType;
    private final RetryPolicy retryPolicy;

    public TrimmedBasicQueryInfo(BasicQueryInfo queryInfo) {
        this.queryId = Objects.requireNonNull(queryInfo.getQueryId(), "queryId is null");
        this.sessionUser = Objects.requireNonNull(queryInfo.getSession().getUser(), "user is null");
        this.sessionPrincipal = Objects.requireNonNull(queryInfo.getSession().getPrincipal(), "principal is null");
        this.sessionSource = Objects.requireNonNull(queryInfo.getSession().getSource(), "source is null");
        this.resourceGroupId = Objects.requireNonNull(queryInfo.getResourceGroupId(), "resourceGroupId is null");
        this.state = Objects.requireNonNull(queryInfo.getState(), "state is null");
        this.errorType = Optional.ofNullable(queryInfo.getErrorType());
        this.errorCode = Optional.ofNullable(queryInfo.getErrorCode());
        this.scheduled = queryInfo.isScheduled();
        this.self = Objects.requireNonNull(queryInfo.getSelf(), "self is null");
        String queryText = Objects.requireNonNull(queryInfo.getQuery(), "query is null");
        this.queryTextPreview = queryText.length() <= 300 ? queryText : queryText.substring(0, 299) + " ...";
        this.updateType = Objects.requireNonNull(queryInfo.getUpdateType(), "updateType is null");
        this.preparedQuery = Objects.requireNonNull(queryInfo.getPreparedQuery(), "preparedQuery is null");
        this.queryStats = Objects.requireNonNull(queryInfo.getQueryStats(), "queryStats is null");
        this.queryType = Objects.requireNonNull(queryInfo.getQueryType(), "queryType is null");
        this.retryPolicy = Objects.requireNonNull(queryInfo.getRetryPolicy(), "retryPolicy is null");
    }

    @JsonProperty
    public QueryId getQueryId() {
        return this.queryId;
    }

    @JsonProperty
    public String getSessionUser() {
        return this.sessionUser;
    }

    @JsonProperty
    public Optional<String> getSessionPrincipal() {
        return this.sessionPrincipal;
    }

    @JsonProperty
    public Optional<String> getSessionSource() {
        return this.sessionSource;
    }

    @JsonProperty
    public Optional<ResourceGroupId> getResourceGroupId() {
        return this.resourceGroupId;
    }

    @JsonProperty
    public QueryState getState() {
        return this.state;
    }

    @JsonProperty
    public boolean isScheduled() {
        return this.scheduled;
    }

    @JsonProperty
    public URI getSelf() {
        return this.self;
    }

    @JsonProperty
    public String getQueryTextPreview() {
        return this.queryTextPreview;
    }

    @JsonProperty
    public Optional<String> getUpdateType() {
        return this.updateType;
    }

    @JsonProperty
    public Optional<String> getPreparedQuery() {
        return this.preparedQuery;
    }

    @JsonProperty
    public BasicQueryStats getQueryStats() {
        return this.queryStats;
    }

    @JsonProperty
    public Optional<ErrorType> getErrorType() {
        return this.errorType;
    }

    @JsonProperty
    public Optional<ErrorCode> getErrorCode() {
        return this.errorCode;
    }

    @JsonProperty
    public Optional<QueryType> getQueryType() {
        return this.queryType;
    }

    @JsonProperty
    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("queryId", (Object)this.queryId).add("state", (Object)this.state).toString();
    }
}

