/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spiller;

import com.google.common.util.concurrent.ListenableFuture;
import io.trino.spi.Page;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.IntPredicate;

public interface PartitioningSpiller
extends Closeable {
    public PartitioningSpillResult partitionAndSpill(Page var1, IntPredicate var2);

    public Iterator<Page> getSpilledPages(int var1);

    public void verifyAllPartitionsRead();

    @Override
    public void close() throws IOException;

    public static class PartitioningSpillResult {
        private final ListenableFuture<Void> spillingFuture;
        private final Page retained;

        public PartitioningSpillResult(ListenableFuture<Void> spillingFuture, Page retained) {
            this.spillingFuture = Objects.requireNonNull(spillingFuture, "spillingFuture is null");
            this.retained = Objects.requireNonNull(retained, "retained is null");
        }

        public ListenableFuture<Void> getSpillingFuture() {
            return this.spillingFuture;
        }

        public Page getRetained() {
            return this.retained;
        }
    }
}

