/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.FieldDefinition;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.trino.metadata.FunctionManager;
import io.trino.operator.aggregation.AccumulatorCompiler;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ConnectorSession;
import io.trino.sql.gen.BytecodeGeneratorContext;
import io.trino.sql.gen.BytecodeUtils;
import io.trino.sql.gen.CachedInstanceBinder;
import io.trino.sql.gen.CallSiteBinder;
import io.trino.sql.gen.LambdaCapture;
import io.trino.sql.gen.LambdaExpressionExtractor;
import io.trino.sql.gen.ParameterAndType;
import io.trino.sql.gen.RowExpressionCompiler;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.ConstantExpression;
import io.trino.sql.relational.InputReferenceExpression;
import io.trino.sql.relational.LambdaDefinitionExpression;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.RowExpressionVisitor;
import io.trino.sql.relational.SpecialForm;
import io.trino.sql.relational.VariableReferenceExpression;
import io.trino.util.CompilerUtils;
import io.trino.util.Failures;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;

public final class LambdaBytecodeGenerator {
    private LambdaBytecodeGenerator() {
    }

    public static Map<LambdaDefinitionExpression, CompiledLambda> generateMethodsForLambda(ClassDefinition containerClassDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, RowExpression expression, FunctionManager functionManager) {
        ImmutableSet lambdaExpressions = ImmutableSet.copyOf(LambdaExpressionExtractor.extractLambdaExpressions(expression));
        ImmutableMap.Builder compiledLambdaMap = ImmutableMap.builder();
        int counter = 0;
        for (LambdaDefinitionExpression lambdaExpression : lambdaExpressions) {
            CompiledLambda compiledLambda = LambdaBytecodeGenerator.preGenerateLambdaExpression(lambdaExpression, "lambda_" + counter, containerClassDefinition, (Map<LambdaDefinitionExpression, CompiledLambda>)compiledLambdaMap.buildOrThrow(), callSiteBinder, cachedInstanceBinder, functionManager);
            compiledLambdaMap.put((Object)lambdaExpression, (Object)compiledLambda);
            ++counter;
        }
        return compiledLambdaMap.buildOrThrow();
    }

    public static CompiledLambda preGenerateLambdaExpression(LambdaDefinitionExpression lambdaExpression, String methodName, ClassDefinition classDefinition, Map<LambdaDefinitionExpression, CompiledLambda> compiledLambdaMap, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, FunctionManager functionManager) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        ImmutableMap.Builder parameterMapBuilder = ImmutableMap.builder();
        parameters.add((Object)Parameter.arg((String)"session", ConnectorSession.class));
        for (int i = 0; i < lambdaExpression.getArguments().size(); ++i) {
            Class type = Primitives.wrap((Class)lambdaExpression.getArgumentTypes().get(i).getJavaType());
            String argumentName = lambdaExpression.getArguments().get(i);
            Parameter arg = Parameter.arg((String)("lambda_" + i + "_" + BytecodeUtils.sanitizeName(argumentName)), (Class)type);
            parameters.add((Object)arg);
            parameterMapBuilder.put((Object)argumentName, (Object)new ParameterAndType(arg, type));
        }
        RowExpressionCompiler innerExpressionCompiler = new RowExpressionCompiler(callSiteBinder, cachedInstanceBinder, LambdaBytecodeGenerator.variableReferenceCompiler((Map<String, ParameterAndType>)parameterMapBuilder.buildOrThrow()), functionManager, compiledLambdaMap);
        return LambdaBytecodeGenerator.defineLambdaMethod(innerExpressionCompiler, classDefinition, methodName, (List<Parameter>)parameters.build(), lambdaExpression);
    }

    private static CompiledLambda defineLambdaMethod(RowExpressionCompiler innerExpressionCompiler, ClassDefinition classDefinition, String methodName, List<Parameter> inputParameters, LambdaDefinitionExpression lambda) {
        Failures.checkCondition(inputParameters.size() <= 254, (ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Too many arguments for lambda expression", new Object[0]);
        Class returnType = Primitives.wrap((Class)lambda.getBody().getType().getJavaType());
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), methodName, ParameterizedType.type((Class)returnType), inputParameters);
        Scope scope = method.getScope();
        Variable wasNull = scope.declareVariable(Boolean.TYPE, "wasNull");
        BytecodeNode compiledBody = innerExpressionCompiler.compile(lambda.getBody(), scope);
        method.getBody().putVariable(wasNull, false).append(compiledBody).append(BytecodeUtils.boxPrimitiveIfNecessary(scope, returnType)).ret(returnType);
        Handle lambdaAsmHandle = new Handle(5, method.getThis().getType().getClassName(), method.getName(), method.getMethodDescriptor(), false);
        return new CompiledLambda(lambdaAsmHandle, method.getReturnType(), method.getParameterTypes());
    }

    public static BytecodeNode generateLambda(BytecodeGeneratorContext context, List<RowExpression> captureExpressions, CompiledLambda compiledLambda, Class<?> lambdaInterface) {
        if (!lambdaInterface.isAnnotationPresent(FunctionalInterface.class)) {
            throw new VerifyException("lambda should be generated as class annotated with FunctionalInterface");
        }
        BytecodeBlock block = new BytecodeBlock().setDescription("Partial apply");
        Scope scope = context.getScope();
        Variable wasNull = scope.getVariable("wasNull");
        ImmutableList.Builder captureVariableBuilder = ImmutableList.builder();
        for (RowExpression captureExpression : captureExpressions) {
            Class valueType = Primitives.wrap((Class)captureExpression.getType().getJavaType());
            Variable valueVariable = scope.createTempVariable(valueType);
            block.append(context.generate(captureExpression));
            block.append(BytecodeUtils.boxPrimitiveIfNecessary(scope, valueType));
            block.putVariable(valueVariable);
            block.append((BytecodeNode)wasNull.set(BytecodeExpressions.constantFalse()));
            captureVariableBuilder.add((Object)valueVariable);
        }
        ImmutableList captureVariables = ImmutableList.builder().add((Object[])new BytecodeExpression[]{scope.getThis(), scope.getVariable("session")}).addAll((Iterable)captureVariableBuilder.build()).build();
        Type instantiatedMethodAsmType = Type.getMethodType((Type)compiledLambda.getReturnType().getAsmType(), (Type[])((Type[])compiledLambda.getParameterTypes().stream().skip(captureExpressions.size() + 1).map(ParameterizedType::getAsmType).toArray(Type[]::new)));
        block.append((BytecodeNode)BytecodeExpressions.invokeDynamic((Method)LambdaCapture.LAMBDA_CAPTURE_METHOD, (Iterable)ImmutableList.of((Object)Type.getType((Method)LambdaBytecodeGenerator.getSingleApplyMethod(lambdaInterface)), (Object)compiledLambda.getLambdaAsmHandle(), (Object)instantiatedMethodAsmType), (String)"apply", (ParameterizedType)ParameterizedType.type(lambdaInterface), (Iterable)captureVariables));
        return block;
    }

    public static Class<? extends Supplier<Object>> compileLambdaProvider(LambdaDefinitionExpression lambdaExpression, FunctionManager functionManager, Class<?> lambdaInterface) {
        ClassDefinition lambdaProviderClassDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName("LambdaProvider"), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(Supplier.class, (Class[])new Class[]{Object.class})});
        FieldDefinition sessionField = lambdaProviderClassDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE}), "session", ConnectorSession.class);
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        CachedInstanceBinder cachedInstanceBinder = new CachedInstanceBinder(lambdaProviderClassDefinition, callSiteBinder);
        Map<LambdaDefinitionExpression, CompiledLambda> compiledLambdaMap = LambdaBytecodeGenerator.generateMethodsForLambda(lambdaProviderClassDefinition, callSiteBinder, cachedInstanceBinder, lambdaExpression, functionManager);
        MethodDefinition method = lambdaProviderClassDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "get", ParameterizedType.type(Object.class), (Iterable)ImmutableList.of());
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        scope.declareVariable("wasNull", body, BytecodeExpressions.constantFalse());
        scope.declareVariable("session", body, method.getThis().getField(sessionField));
        RowExpressionCompiler rowExpressionCompiler = new RowExpressionCompiler(callSiteBinder, cachedInstanceBinder, LambdaBytecodeGenerator.variableReferenceCompiler((Map<String, ParameterAndType>)ImmutableMap.of()), functionManager, compiledLambdaMap);
        BytecodeGeneratorContext generatorContext = new BytecodeGeneratorContext(rowExpressionCompiler, scope, callSiteBinder, cachedInstanceBinder, functionManager);
        body.append(LambdaBytecodeGenerator.generateLambda(generatorContext, (List<RowExpression>)ImmutableList.of(), compiledLambdaMap.get(lambdaExpression), lambdaInterface)).retObject();
        Parameter sessionParameter = Parameter.arg((String)"session", ConnectorSession.class);
        MethodDefinition constructorDefinition = lambdaProviderClassDefinition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[]{sessionParameter});
        BytecodeBlock constructorBody = constructorDefinition.getBody();
        Variable constructorThisVariable = constructorDefinition.getThis();
        constructorBody.comment("super();").append((BytecodeNode)constructorThisVariable).invokeConstructor(Object.class, new Class[0]).append((BytecodeNode)constructorThisVariable.setField(sessionField, (BytecodeExpression)sessionParameter));
        cachedInstanceBinder.generateInitializations(constructorThisVariable, constructorBody);
        constructorBody.ret();
        return CompilerUtils.defineClass(lambdaProviderClassDefinition, Supplier.class, callSiteBinder.getBindings(), AccumulatorCompiler.class.getClassLoader());
    }

    private static Method getSingleApplyMethod(Class<?> lambdaFunctionInterface) {
        Failures.checkCondition(lambdaFunctionInterface.isAnnotationPresent(FunctionalInterface.class), (ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR, "Lambda function interface is required to be annotated with FunctionalInterface", new Object[0]);
        List applyMethods = (List)Arrays.stream(lambdaFunctionInterface.getMethods()).filter(method -> method.getName().equals("apply")).collect(ImmutableList.toImmutableList());
        Failures.checkCondition(applyMethods.size() == 1, (ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR, "Expect to have exactly 1 method with name 'apply' in interface %s", lambdaFunctionInterface.getName());
        return (Method)applyMethods.get(0);
    }

    private static RowExpressionVisitor<BytecodeNode, Scope> variableReferenceCompiler(final Map<String, ParameterAndType> parameterMap) {
        return new RowExpressionVisitor<BytecodeNode, Scope>(){

            @Override
            public BytecodeNode visitInputReference(InputReferenceExpression node, Scope scope) {
                throw new UnsupportedOperationException();
            }

            @Override
            public BytecodeNode visitCall(CallExpression call, Scope scope) {
                throw new UnsupportedOperationException();
            }

            @Override
            public BytecodeNode visitSpecialForm(SpecialForm specialForm, Scope context) {
                throw new UnsupportedOperationException();
            }

            @Override
            public BytecodeNode visitConstant(ConstantExpression literal, Scope scope) {
                throw new UnsupportedOperationException();
            }

            @Override
            public BytecodeNode visitLambda(LambdaDefinitionExpression lambda, Scope context) {
                throw new UnsupportedOperationException();
            }

            @Override
            public BytecodeNode visitVariableReference(VariableReferenceExpression reference, Scope context) {
                ParameterAndType parameterAndType = (ParameterAndType)parameterMap.get(reference.getName());
                Parameter parameter = parameterAndType.getParameter();
                Class<?> type = parameterAndType.getType();
                return new BytecodeBlock().append((BytecodeNode)parameter).append((BytecodeNode)BytecodeUtils.unboxPrimitiveIfNecessary(context, type));
            }
        };
    }

    public static class CompiledLambda {
        private final Handle lambdaAsmHandle;
        private final ParameterizedType returnType;
        private final List<ParameterizedType> parameterTypes;

        public CompiledLambda(Handle lambdaAsmHandle, ParameterizedType returnType, List<ParameterizedType> parameterTypes) {
            this.lambdaAsmHandle = Objects.requireNonNull(lambdaAsmHandle, "lambdaAsmHandle is null");
            this.returnType = Objects.requireNonNull(returnType, "returnType is null");
            this.parameterTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(parameterTypes, "parameterTypes is null"));
        }

        public Handle getLambdaAsmHandle() {
            return this.lambdaAsmHandle;
        }

        public ParameterizedType getReturnType() {
            return this.returnType;
        }

        public List<ParameterizedType> getParameterTypes() {
            return this.parameterTypes;
        }
    }
}

