/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.type.UnknownType;
import java.util.Map;

public final class Coercer {
    private Coercer() {
    }

    public static Expression addCoercions(Expression expression, Analysis analysis) {
        return Coercer.addCoercions(expression, analysis.getCoercions());
    }

    public static Expression addCoercions(Expression expression, Map<NodeRef<Expression>, Type> coercions) {
        Preconditions.checkArgument((boolean)coercions.values().stream().noneMatch(arg_0 -> ((UnknownType)UnknownType.UNKNOWN).equals(arg_0)), (Object)"Cannot add coercion to UNKNOWN");
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Rewriter(coercions), (Expression)expression);
    }

    private static class Rewriter
    extends ExpressionRewriter<Void> {
        private final Map<NodeRef<Expression>, Type> coercions;

        public Rewriter(Map<NodeRef<Expression>, Type> coercions) {
            this.coercions = coercions;
        }

        protected Expression rewriteExpression(Expression expression, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Type target = this.coercions.get(NodeRef.of((Node)expression));
            Expression rewritten = treeRewriter.defaultRewrite(expression, null);
            if (target != null) {
                rewritten = new Cast(rewritten, TypeSignatureTranslator.toSqlType(target), false);
            }
            return rewritten;
        }
    }
}

