/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Primitives;
import io.trino.Session;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.operator.scalar.ArraySubscriptOperator;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowValueBuilder;
import io.trino.spi.block.SqlRow;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.function.FunctionNullability;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeUtils;
import io.trino.sql.DynamicFilters;
import io.trino.sql.InterpretedFunctionInvoker;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.gen.VarArgsToMapAdapterGenerator;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.planner.BuiltinFunctionCallBuilder;
import io.trino.sql.planner.DeterminismEvaluator;
import io.trino.sql.planner.IrTypeAnalyzer;
import io.trino.sql.planner.LiteralEncoder;
import io.trino.sql.planner.LiteralInterpreter;
import io.trino.sql.planner.ResolvedFunctionCallBuilder;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolResolver;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.ArithmeticUnaryExpression;
import io.trino.sql.tree.Array;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.BetweenPredicate;
import io.trino.sql.tree.BindExpression;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.CoalesceExpression;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.IfExpression;
import io.trino.sql.tree.InListExpression;
import io.trino.sql.tree.InPredicate;
import io.trino.sql.tree.IsNotNullPredicate;
import io.trino.sql.tree.IsNullPredicate;
import io.trino.sql.tree.LambdaArgumentDeclaration;
import io.trino.sql.tree.LambdaExpression;
import io.trino.sql.tree.Literal;
import io.trino.sql.tree.LogicalExpression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.NotExpression;
import io.trino.sql.tree.NullIfExpression;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.SearchedCaseExpression;
import io.trino.sql.tree.SimpleCaseExpression;
import io.trino.sql.tree.SubscriptExpression;
import io.trino.sql.tree.SymbolReference;
import io.trino.sql.tree.WhenClause;
import io.trino.type.FunctionType;
import io.trino.type.TypeCoercion;
import io.trino.util.Failures;
import io.trino.util.FastutilSetHelper;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class IrExpressionInterpreter {
    private static final CatalogSchemaFunctionName FAIL_NAME = GlobalFunctionCatalog.builtinFunctionName("fail");
    private final Expression expression;
    private final PlannerContext plannerContext;
    private final Metadata metadata;
    private final LiteralInterpreter literalInterpreter;
    private final LiteralEncoder literalEncoder;
    private final Session session;
    private final ConnectorSession connectorSession;
    private final Map<NodeRef<Expression>, Type> expressionTypes;
    private final InterpretedFunctionInvoker functionInvoker;
    private final TypeCoercion typeCoercion;
    private final IdentityHashMap<InListExpression, Set<?>> inListCache = new IdentityHashMap();

    public IrExpressionInterpreter(Expression expression, PlannerContext plannerContext, Session session, Map<NodeRef<Expression>, Type> expressionTypes) {
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.metadata = plannerContext.getMetadata();
        this.literalInterpreter = new LiteralInterpreter(plannerContext, session);
        this.literalEncoder = new LiteralEncoder(plannerContext);
        this.session = Objects.requireNonNull(session, "session is null");
        this.connectorSession = session.toConnectorSession();
        this.expressionTypes = ImmutableMap.copyOf(Objects.requireNonNull(expressionTypes, "expressionTypes is null"));
        Verify.verify((boolean)expressionTypes.containsKey(NodeRef.of((Node)expression)));
        this.functionInvoker = new InterpretedFunctionInvoker(plannerContext.getFunctionManager());
        this.typeCoercion = new TypeCoercion(arg_0 -> ((TypeManager)plannerContext.getTypeManager()).getType(arg_0));
    }

    public static Object evaluateConstantExpression(Expression expression, PlannerContext plannerContext, Session session) {
        Map<NodeRef<Expression>, Type> types = new IrTypeAnalyzer(plannerContext).getTypes(session, TypeProvider.empty(), expression);
        return new IrExpressionInterpreter(expression, plannerContext, session, types).evaluate();
    }

    public Object evaluate() {
        Object result = new Visitor(false).processWithExceptionHandling(this.expression, null);
        Verify.verify((!(result instanceof Expression) ? 1 : 0) != 0, (String)"Expression interpreter returned an unresolved expression", (Object[])new Object[0]);
        return result;
    }

    public Object evaluate(SymbolResolver inputs) {
        Object result = new Visitor(false).processWithExceptionHandling(this.expression, inputs);
        Verify.verify((!(result instanceof Expression) ? 1 : 0) != 0, (String)"Expression interpreter returned an unresolved expression", (Object[])new Object[0]);
        return result;
    }

    public Object optimize(SymbolResolver inputs) {
        return new Visitor(true).processWithExceptionHandling(this.expression, inputs);
    }

    private static boolean isArray(Type type) {
        return type instanceof ArrayType;
    }

    private class Visitor
    extends AstVisitor<Object, Object> {
        private final boolean optimize;

        private Visitor(boolean optimize) {
            this.optimize = optimize;
        }

        private Object processWithExceptionHandling(Expression expression, Object context) {
            if (expression == null) {
                return null;
            }
            try {
                return this.process((Node)expression, context);
            }
            catch (TrinoException e) {
                if (this.optimize) {
                    return expression;
                }
                throw e;
            }
        }

        protected Object visitSymbolReference(SymbolReference node, Object context) {
            return ((SymbolResolver)context).getValue(Symbol.from((Expression)node));
        }

        protected Object visitLiteral(Literal node, Object context) {
            return IrExpressionInterpreter.this.literalInterpreter.evaluate((Expression)node, this.type((Expression)node));
        }

        protected Object visitIsNullPredicate(IsNullPredicate node, Object context) {
            Object value = this.processWithExceptionHandling(node.getValue(), context);
            if (value instanceof Expression) {
                return new IsNullPredicate(this.toExpression(value, this.type(node.getValue())));
            }
            return value == null;
        }

        protected Object visitIsNotNullPredicate(IsNotNullPredicate node, Object context) {
            Object value = this.processWithExceptionHandling(node.getValue(), context);
            if (value instanceof Expression) {
                return new IsNotNullPredicate(this.toExpression(value, this.type(node.getValue())));
            }
            return value != null;
        }

        protected Object visitSearchedCaseExpression(SearchedCaseExpression node, Object context) {
            Object newDefault = null;
            boolean foundNewDefault = false;
            ArrayList<WhenClause> whenClauses = new ArrayList<WhenClause>();
            for (WhenClause whenClause : node.getWhenClauses()) {
                Object whenOperand = this.processWithExceptionHandling(whenClause.getOperand(), context);
                if (whenOperand instanceof Expression) {
                    whenClauses.add(new WhenClause(this.toExpression(whenOperand, this.type(whenClause.getOperand())), this.toExpression(this.processWithExceptionHandling(whenClause.getResult(), context), this.type(whenClause.getResult()))));
                    continue;
                }
                if (!Boolean.TRUE.equals(whenOperand)) continue;
                foundNewDefault = true;
                newDefault = this.processWithExceptionHandling(whenClause.getResult(), context);
                break;
            }
            Object defaultResult = foundNewDefault ? newDefault : this.processWithExceptionHandling(node.getDefaultValue().orElse(null), context);
            if (whenClauses.isEmpty()) {
                return defaultResult;
            }
            Expression defaultExpression = defaultResult == null ? null : this.toExpression(defaultResult, this.type((Expression)node));
            return new SearchedCaseExpression(whenClauses, Optional.ofNullable(defaultExpression));
        }

        protected Object visitIfExpression(IfExpression node, Object context) {
            Object condition = this.processWithExceptionHandling(node.getCondition(), context);
            if (condition instanceof Expression) {
                Object trueValue = this.processWithExceptionHandling(node.getTrueValue(), context);
                Object falseValue = this.processWithExceptionHandling(node.getFalseValue().orElse(null), context);
                return new IfExpression(this.toExpression(condition, this.type(node.getCondition())), this.toExpression(trueValue, this.type(node.getTrueValue())), falseValue == null ? null : this.toExpression(falseValue, this.type((Expression)node.getFalseValue().get())));
            }
            if (Boolean.TRUE.equals(condition)) {
                return this.processWithExceptionHandling(node.getTrueValue(), context);
            }
            return this.processWithExceptionHandling(node.getFalseValue().orElse(null), context);
        }

        protected Object visitSimpleCaseExpression(SimpleCaseExpression node, Object context) {
            Object operand = this.processWithExceptionHandling(node.getOperand(), context);
            Type operandType = this.type(node.getOperand());
            if (operand == null) {
                return this.processWithExceptionHandling(node.getDefaultValue().orElse(null), context);
            }
            Object newDefault = null;
            boolean foundNewDefault = false;
            ArrayList<WhenClause> whenClauses = new ArrayList<WhenClause>();
            for (WhenClause whenClause : node.getWhenClauses()) {
                Object whenOperand = this.processWithExceptionHandling(whenClause.getOperand(), context);
                if (whenOperand instanceof Expression || operand instanceof Expression) {
                    whenClauses.add(new WhenClause(this.toExpression(whenOperand, this.type(whenClause.getOperand())), this.toExpression(this.processWithExceptionHandling(whenClause.getResult(), context), this.type(whenClause.getResult()))));
                    continue;
                }
                if (whenOperand == null || !this.isEqual(operand, operandType, whenOperand, this.type(whenClause.getOperand()))) continue;
                foundNewDefault = true;
                newDefault = this.processWithExceptionHandling(whenClause.getResult(), context);
                break;
            }
            Object defaultResult = foundNewDefault ? newDefault : this.processWithExceptionHandling(node.getDefaultValue().orElse(null), context);
            if (whenClauses.isEmpty()) {
                return defaultResult;
            }
            Expression defaultExpression = defaultResult == null ? null : this.toExpression(defaultResult, this.type((Expression)node));
            return new SimpleCaseExpression(this.toExpression(operand, this.type(node.getOperand())), whenClauses, Optional.ofNullable(defaultExpression));
        }

        private boolean isEqual(Object operand1, Type type1, Object operand2, Type type2) {
            return Boolean.TRUE.equals(this.invokeOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)type1, (Object)type2), (List<Object>)ImmutableList.of((Object)operand1, (Object)operand2)));
        }

        private Type type(Expression expression) {
            Type type = IrExpressionInterpreter.this.expressionTypes.get(NodeRef.of((Node)expression));
            Preconditions.checkState((type != null ? 1 : 0) != 0, (String)"Type not found for expression: %s", (Object)expression);
            return type;
        }

        protected Object visitCoalesceExpression(CoalesceExpression node, Object context) {
            List<Object> newOperands = this.processOperands(node, context);
            if (newOperands.isEmpty()) {
                return null;
            }
            if (newOperands.size() == 1) {
                return Iterables.getOnlyElement(newOperands);
            }
            return new CoalesceExpression((List)newOperands.stream().map(value -> this.toExpression(value, this.type((Expression)node))).collect(ImmutableList.toImmutableList()));
        }

        private List<Object> processOperands(CoalesceExpression node, Object context) {
            ArrayList<Object> newOperands = new ArrayList<Object>();
            HashSet<Expression> uniqueNewOperands = new HashSet<Expression>();
            for (Expression operand : node.getOperands()) {
                Object value = this.processWithExceptionHandling(operand, context);
                if (value instanceof CoalesceExpression) {
                    for (Expression nestedOperand : ((CoalesceExpression)value).getOperands()) {
                        if (!DeterminismEvaluator.isDeterministic(nestedOperand, IrExpressionInterpreter.this.metadata) || uniqueNewOperands.add(nestedOperand)) {
                            newOperands.add(nestedOperand);
                        }
                        if (!IrUtils.isEffectivelyLiteral(IrExpressionInterpreter.this.plannerContext, IrExpressionInterpreter.this.session, nestedOperand)) continue;
                        Verify.verify((!(nestedOperand instanceof NullLiteral) && (!(nestedOperand instanceof Cast) || !(((Cast)nestedOperand).getExpression() instanceof NullLiteral)) ? 1 : 0) != 0, (String)"Null operand should have been removed by recursive coalesce processing", (Object[])new Object[0]);
                        return newOperands;
                    }
                    continue;
                }
                if (value instanceof Expression) {
                    Expression expression = (Expression)value;
                    Verify.verify((!(value instanceof NullLiteral) ? 1 : 0) != 0, (String)"Null value is expected to be represented as null, not NullLiteral", (Object[])new Object[0]);
                    if (DeterminismEvaluator.isDeterministic(expression, IrExpressionInterpreter.this.metadata) && !uniqueNewOperands.add(expression)) continue;
                    newOperands.add(expression);
                    continue;
                }
                if (value == null) continue;
                newOperands.add(value);
                return newOperands;
            }
            return newOperands;
        }

        protected Object visitInPredicate(InPredicate node, Object context) {
            Object value = this.processWithExceptionHandling(node.getValue(), context);
            InListExpression valueList = (InListExpression)node.getValueList();
            if (value == null) {
                return null;
            }
            if (!(value instanceof Expression)) {
                Set<?> set = IrExpressionInterpreter.this.inListCache.get(valueList);
                if (!IrExpressionInterpreter.this.inListCache.containsKey(valueList)) {
                    if (valueList.getValues().stream().allMatch(Literal.class::isInstance)) {
                        if (valueList.getValues().stream().noneMatch(NullLiteral.class::isInstance)) {
                            Set objectSet = valueList.getValues().stream().map(expression -> this.processWithExceptionHandling((Expression)expression, context)).collect(Collectors.toSet());
                            Type type = this.type(node.getValue());
                            set = FastutilSetHelper.toFastutilHashSet(objectSet, type, IrExpressionInterpreter.this.plannerContext.getFunctionManager().getScalarFunctionImplementation(IrExpressionInterpreter.this.metadata.resolveOperator(OperatorType.HASH_CODE, (List<? extends Type>)ImmutableList.of((Object)type)), InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL})).getMethodHandle(), IrExpressionInterpreter.this.plannerContext.getFunctionManager().getScalarFunctionImplementation(IrExpressionInterpreter.this.metadata.resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type)), InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL})).getMethodHandle());
                        }
                    }
                    IrExpressionInterpreter.this.inListCache.put(valueList, set);
                }
                if (set != null) {
                    return set.contains(value);
                }
            }
            boolean hasUnresolvedValue = value instanceof Expression;
            boolean hasNullValue = false;
            boolean found = false;
            ArrayList<Object> values = new ArrayList<Object>(valueList.getValues().size());
            ArrayList<Type> types = new ArrayList<Type>(valueList.getValues().size());
            ResolvedFunction equalsOperator = IrExpressionInterpreter.this.metadata.resolveOperator(OperatorType.EQUAL, this.types(new Expression[]{node.getValue(), valueList}));
            for (Expression expression2 : valueList.getValues()) {
                if (value instanceof Expression && expression2 instanceof Literal) {
                    values.add(expression2);
                    types.add(this.type(expression2));
                    continue;
                }
                Object inValue = this.process((Node)expression2, context);
                if (value instanceof Expression || inValue instanceof Expression) {
                    hasUnresolvedValue = true;
                    values.add(inValue);
                    types.add(this.type(expression2));
                    continue;
                }
                if (inValue == null) {
                    hasNullValue = true;
                    continue;
                }
                Boolean result = (Boolean)IrExpressionInterpreter.this.functionInvoker.invoke(equalsOperator, IrExpressionInterpreter.this.connectorSession, (List<Object>)ImmutableList.of((Object)value, (Object)inValue));
                if (result == null) {
                    hasNullValue = true;
                    continue;
                }
                if (found || !result.booleanValue()) continue;
                found = true;
            }
            if (found) {
                return true;
            }
            if (hasUnresolvedValue) {
                Type type = this.type(node.getValue());
                List<Expression> expressionValues = this.toExpressions(values, types);
                List simplifiedExpressionValues = (List)Stream.concat(expressionValues.stream().filter(expression -> DeterminismEvaluator.isDeterministic(expression, IrExpressionInterpreter.this.metadata)).distinct(), expressionValues.stream().filter(expression -> !DeterminismEvaluator.isDeterministic(expression, IrExpressionInterpreter.this.metadata))).collect(ImmutableList.toImmutableList());
                if (simplifiedExpressionValues.size() == 1) {
                    return new ComparisonExpression(ComparisonExpression.Operator.EQUAL, this.toExpression(value, type), (Expression)simplifiedExpressionValues.get(0));
                }
                return new InPredicate(this.toExpression(value, type), (Expression)new InListExpression(simplifiedExpressionValues));
            }
            if (hasNullValue) {
                return null;
            }
            return false;
        }

        protected Object visitArithmeticUnary(ArithmeticUnaryExpression node, Object context) {
            Object object;
            Object value = this.processWithExceptionHandling(node.getValue(), context);
            if (value == null) {
                return null;
            }
            if (value instanceof Expression) {
                Expression valueExpression = this.toExpression(value, this.type(node.getValue()));
                return switch (node.getSign()) {
                    default -> throw new MatchException(null, null);
                    case ArithmeticUnaryExpression.Sign.PLUS -> valueExpression;
                    case ArithmeticUnaryExpression.Sign.MINUS -> valueExpression instanceof ArithmeticUnaryExpression && ((ArithmeticUnaryExpression)valueExpression).getSign().equals((Object)ArithmeticUnaryExpression.Sign.MINUS) ? ((ArithmeticUnaryExpression)valueExpression).getValue() : new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, valueExpression);
                };
            }
            switch (node.getSign()) {
                default: {
                    throw new MatchException(null, null);
                }
                case PLUS: {
                    Object object2;
                    object = object2 = value;
                    break;
                }
                case MINUS: {
                    ResolvedFunction resolvedOperator = IrExpressionInterpreter.this.metadata.resolveOperator(OperatorType.NEGATION, this.types(node.getValue()));
                    InvocationConvention invocationConvention = new InvocationConvention((List)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, true, false);
                    MethodHandle handle = IrExpressionInterpreter.this.plannerContext.getFunctionManager().getScalarFunctionImplementation(resolvedOperator, invocationConvention).getMethodHandle();
                    if (handle.type().parameterCount() > 0 && handle.type().parameterType(0) == ConnectorSession.class) {
                        handle = handle.bindTo(IrExpressionInterpreter.this.connectorSession);
                    }
                    try {
                        Object object3;
                        object = object3 = handle.invokeWithArguments(value);
                        break;
                    }
                    catch (Throwable throwable) {
                        Throwables.throwIfInstanceOf((Throwable)throwable, RuntimeException.class);
                        Throwables.throwIfInstanceOf((Throwable)throwable, Error.class);
                        throw new RuntimeException(throwable.getMessage(), throwable);
                    }
                }
            }
            return object;
        }

        protected Object visitArithmeticBinary(ArithmeticBinaryExpression node, Object context) {
            Object left = this.processWithExceptionHandling(node.getLeft(), context);
            if (left == null) {
                return null;
            }
            Object right = this.processWithExceptionHandling(node.getRight(), context);
            if (right == null) {
                return null;
            }
            if (this.hasUnresolvedValue(left, right)) {
                return new ArithmeticBinaryExpression(node.getOperator(), this.toExpression(left, this.type(node.getLeft())), this.toExpression(right, this.type(node.getRight())));
            }
            return this.invokeOperator(OperatorType.valueOf((String)node.getOperator().name()), this.types(node.getLeft(), node.getRight()), (List<Object>)ImmutableList.of((Object)left, (Object)right));
        }

        protected Object visitComparisonExpression(ComparisonExpression node, Object context) {
            ComparisonExpression.Operator operator = node.getOperator();
            Expression left = node.getLeft();
            Expression right = node.getRight();
            if (operator == ComparisonExpression.Operator.IS_DISTINCT_FROM) {
                return this.processIsDistinctFrom(context, left, right);
            }
            if (node.getOperator() == ComparisonExpression.Operator.NOT_EQUAL) {
                Object result = this.visitComparisonExpression(this.flipComparison(node), context);
                if (result == null) {
                    return null;
                }
                if (result instanceof ComparisonExpression) {
                    return this.flipComparison((ComparisonExpression)result);
                }
                return (Boolean)result == false;
            }
            if (node.getOperator() == ComparisonExpression.Operator.GREATER_THAN || node.getOperator() == ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL) {
                Object result = this.visitComparisonExpression(this.flipComparison(node), context);
                if (result instanceof ComparisonExpression) {
                    return this.flipComparison((ComparisonExpression)result);
                }
                return result;
            }
            return this.processComparisonExpression(context, operator, left, right);
        }

        private Object processIsDistinctFrom(Object context, Expression leftExpression, Expression rightExpression) {
            Object left = this.processWithExceptionHandling(leftExpression, context);
            Object right = this.processWithExceptionHandling(rightExpression, context);
            if (left == null && right instanceof Expression) {
                return new IsNotNullPredicate((Expression)right);
            }
            if (right == null && left instanceof Expression) {
                return new IsNotNullPredicate((Expression)left);
            }
            if (left instanceof Expression || right instanceof Expression) {
                return new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, this.toExpression(left, this.type(leftExpression)), this.toExpression(right, this.type(rightExpression)));
            }
            return this.invokeOperator(OperatorType.valueOf((String)ComparisonExpression.Operator.IS_DISTINCT_FROM.name()), this.types(leftExpression, rightExpression), Arrays.asList(left, right));
        }

        private Object processComparisonExpression(Object context, ComparisonExpression.Operator operator, Expression leftExpression, Expression rightExpression) {
            Object left = this.processWithExceptionHandling(leftExpression, context);
            if (left == null) {
                return null;
            }
            Object right = this.processWithExceptionHandling(rightExpression, context);
            if (right == null) {
                return null;
            }
            if (left instanceof Expression || right instanceof Expression) {
                return new ComparisonExpression(operator, this.toExpression(left, this.type(leftExpression)), this.toExpression(right, this.type(rightExpression)));
            }
            return this.invokeOperator(OperatorType.valueOf((String)operator.name()), this.types(leftExpression, rightExpression), (List<Object>)ImmutableList.of((Object)left, (Object)right));
        }

        private ComparisonExpression flipComparison(ComparisonExpression comparisonExpression) {
            return switch (comparisonExpression.getOperator()) {
                case ComparisonExpression.Operator.EQUAL -> new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, comparisonExpression.getLeft(), comparisonExpression.getRight());
                case ComparisonExpression.Operator.NOT_EQUAL -> new ComparisonExpression(ComparisonExpression.Operator.EQUAL, comparisonExpression.getLeft(), comparisonExpression.getRight());
                case ComparisonExpression.Operator.LESS_THAN -> new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, comparisonExpression.getRight(), comparisonExpression.getLeft());
                case ComparisonExpression.Operator.LESS_THAN_OR_EQUAL -> new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, comparisonExpression.getRight(), comparisonExpression.getLeft());
                case ComparisonExpression.Operator.GREATER_THAN -> new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, comparisonExpression.getRight(), comparisonExpression.getLeft());
                case ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL -> new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, comparisonExpression.getRight(), comparisonExpression.getLeft());
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(comparisonExpression.getOperator()));
            };
        }

        protected Object visitBetweenPredicate(BetweenPredicate node, Object context) {
            Object value = this.processWithExceptionHandling(node.getValue(), context);
            if (value == null) {
                return null;
            }
            Object min = this.processWithExceptionHandling(node.getMin(), context);
            Object max = this.processWithExceptionHandling(node.getMax(), context);
            if (value instanceof Expression || min instanceof Expression || max instanceof Expression) {
                return new BetweenPredicate(this.toExpression(value, this.type(node.getValue())), this.toExpression(min, this.type(node.getMin())), this.toExpression(max, this.type(node.getMax())));
            }
            Boolean greaterOrEqualToMin = null;
            if (min != null) {
                greaterOrEqualToMin = (Boolean)this.invokeOperator(OperatorType.LESS_THAN_OR_EQUAL, this.types(node.getMin(), node.getValue()), (List<Object>)ImmutableList.of((Object)min, (Object)value));
            }
            Boolean lessThanOrEqualToMax = null;
            if (max != null) {
                lessThanOrEqualToMax = (Boolean)this.invokeOperator(OperatorType.LESS_THAN_OR_EQUAL, this.types(node.getValue(), node.getMax()), (List<Object>)ImmutableList.of((Object)value, (Object)max));
            }
            if (greaterOrEqualToMin == null) {
                return Objects.equals(lessThanOrEqualToMax, Boolean.FALSE) ? Boolean.valueOf(false) : null;
            }
            if (lessThanOrEqualToMax == null) {
                return Objects.equals(greaterOrEqualToMin, Boolean.FALSE) ? Boolean.valueOf(false) : null;
            }
            return greaterOrEqualToMin != false && lessThanOrEqualToMax != false;
        }

        protected Object visitNullIfExpression(NullIfExpression node, Object context) {
            Object first = this.processWithExceptionHandling(node.getFirst(), context);
            if (first == null) {
                return null;
            }
            Object second = this.processWithExceptionHandling(node.getSecond(), context);
            if (second == null) {
                return first;
            }
            Type firstType = this.type(node.getFirst());
            Type secondType = this.type(node.getSecond());
            if (this.hasUnresolvedValue(first, second)) {
                return new NullIfExpression(this.toExpression(first, firstType), this.toExpression(second, secondType));
            }
            Type commonType = IrExpressionInterpreter.this.typeCoercion.getCommonSuperType(firstType, secondType).get();
            ResolvedFunction firstCast = IrExpressionInterpreter.this.metadata.getCoercion(firstType, commonType);
            ResolvedFunction secondCast = IrExpressionInterpreter.this.metadata.getCoercion(secondType, commonType);
            boolean equal = Boolean.TRUE.equals(this.invokeOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)commonType, (Object)commonType), (List<Object>)ImmutableList.of((Object)IrExpressionInterpreter.this.functionInvoker.invoke(firstCast, IrExpressionInterpreter.this.connectorSession, (List<Object>)ImmutableList.of((Object)first)), (Object)IrExpressionInterpreter.this.functionInvoker.invoke(secondCast, IrExpressionInterpreter.this.connectorSession, (List<Object>)ImmutableList.of((Object)second)))));
            if (equal) {
                return null;
            }
            return first;
        }

        protected Object visitNotExpression(NotExpression node, Object context) {
            Object value = this.processWithExceptionHandling(node.getValue(), context);
            if (value == null) {
                return null;
            }
            if (value instanceof Expression) {
                return new NotExpression(this.toExpression(value, this.type(node.getValue())));
            }
            return (Boolean)value == false;
        }

        protected Object visitLogicalExpression(LogicalExpression node, Object context) {
            ArrayList<Object> terms = new ArrayList<Object>();
            ArrayList<Type> types = new ArrayList<Type>();
            for (Expression term : node.getTerms()) {
                Object processed = this.processWithExceptionHandling(term, context);
                switch (node.getOperator()) {
                    case AND: {
                        if (Boolean.FALSE.equals(processed)) {
                            return false;
                        }
                        if (Boolean.TRUE.equals(processed)) break;
                        terms.add(processed);
                        types.add(this.type(term));
                        break;
                    }
                    case OR: {
                        if (Boolean.TRUE.equals(processed)) {
                            return true;
                        }
                        if (Boolean.FALSE.equals(processed)) break;
                        terms.add(processed);
                        types.add(this.type(term));
                    }
                }
            }
            if (terms.isEmpty()) {
                return switch (node.getOperator()) {
                    default -> throw new MatchException(null, null);
                    case LogicalExpression.Operator.AND -> true;
                    case LogicalExpression.Operator.OR -> false;
                };
            }
            if (terms.size() == 1) {
                return terms.get(0);
            }
            if (terms.stream().allMatch(Objects::isNull)) {
                return null;
            }
            ImmutableList.Builder expressions = ImmutableList.builder();
            for (int i = 0; i < terms.size(); ++i) {
                expressions.add((Object)this.toExpression(terms.get(i), (Type)types.get(i)));
            }
            return new LogicalExpression(node.getOperator(), (List)expressions.build());
        }

        protected Object visitBooleanLiteral(BooleanLiteral node, Object context) {
            return node.equals((Object)BooleanLiteral.TRUE_LITERAL);
        }

        protected Object visitFunctionCall(FunctionCall node, Object context) {
            ArrayList<Type> argumentTypes = new ArrayList<Type>();
            ArrayList<Object> argumentValues = new ArrayList<Object>();
            for (Expression expression : node.getArguments()) {
                Object value = this.processWithExceptionHandling(expression, context);
                Type type = this.type(expression);
                argumentValues.add(value);
                argumentTypes.add(type);
            }
            ResolvedFunction resolvedFunction = IrExpressionInterpreter.this.metadata.decodeFunction(node.getName());
            FunctionNullability functionNullability = resolvedFunction.getFunctionNullability();
            for (int i = 0; i < argumentValues.size(); ++i) {
                Object value = argumentValues.get(i);
                if (value != null || functionNullability.isArgumentNullable(i)) continue;
                return null;
            }
            if (this.optimize && (!resolvedFunction.isDeterministic() || this.hasUnresolvedValue(argumentValues) || DynamicFilters.isDynamicFilter((Expression)node) || resolvedFunction.getSignature().getName().equals((Object)FAIL_NAME))) {
                Verify.verify((!node.isDistinct() ? 1 : 0) != 0, (String)"distinct not supported", (Object[])new Object[0]);
                Verify.verify((boolean)node.getOrderBy().isEmpty(), (String)"order by not supported", (Object[])new Object[0]);
                Verify.verify((boolean)node.getFilter().isEmpty(), (String)"filter not supported", (Object[])new Object[0]);
                Verify.verify((boolean)node.getWindow().isEmpty(), (String)"window not supported", (Object[])new Object[0]);
                return ResolvedFunctionCallBuilder.builder(resolvedFunction).setArguments(this.toExpressions(argumentValues, argumentTypes)).build();
            }
            return IrExpressionInterpreter.this.functionInvoker.invoke(resolvedFunction, IrExpressionInterpreter.this.connectorSession, argumentValues);
        }

        protected Object visitLambdaExpression(LambdaExpression node, Object context) {
            if (this.optimize) {
                Expression optimizedBody;
                Object value = this.processWithExceptionHandling(node.getBody(), context);
                if (value instanceof Expression) {
                    optimizedBody = (Expression)value;
                } else {
                    Type type = this.type(node.getBody());
                    optimizedBody = this.toExpression(value, type);
                }
                return new LambdaExpression(node.getArguments(), optimizedBody);
            }
            Expression body = node.getBody();
            List argumentNames = (List)node.getArguments().stream().map(LambdaArgumentDeclaration::getName).map(Identifier::getValue).collect(ImmutableList.toImmutableList());
            FunctionType functionType = (FunctionType)IrExpressionInterpreter.this.expressionTypes.get(NodeRef.of((Node)node));
            Preconditions.checkArgument((argumentNames.size() == functionType.getArgumentTypes().size() ? 1 : 0) != 0);
            return VarArgsToMapAdapterGenerator.generateVarArgsToMapAdapter(Primitives.wrap((Class)functionType.getReturnType().getJavaType()), (List)functionType.getArgumentTypes().stream().map(Type::getJavaType).map(Primitives::wrap).collect(ImmutableList.toImmutableList()), argumentNames, map -> this.processWithExceptionHandling(body, new LambdaSymbolResolver((Map<String, Object>)map)));
        }

        protected Object visitBindExpression(BindExpression node, Object context) {
            List<Object> values = node.getValues().stream().map(value -> this.processWithExceptionHandling((Expression)value, context)).collect(Collectors.toList());
            Object function = this.processWithExceptionHandling(node.getFunction(), context);
            if (this.hasUnresolvedValue(values) || this.hasUnresolvedValue(function)) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (int i = 0; i < values.size(); ++i) {
                    builder.add((Object)this.toExpression(values.get(i), this.type((Expression)node.getValues().get(i))));
                }
                return new BindExpression((List)builder.build(), this.toExpression(function, this.type(node.getFunction())));
            }
            return MethodHandles.insertArguments((MethodHandle)function, 0, values.toArray());
        }

        public Object visitCast(Cast node, Object context) {
            Object value = this.processWithExceptionHandling(node.getExpression(), context);
            Type targetType = IrExpressionInterpreter.this.plannerContext.getTypeManager().getType(TypeSignatureTranslator.toTypeSignature(node.getType()));
            Type sourceType = this.type(node.getExpression());
            if (value instanceof Expression) {
                if (targetType.equals((Object)sourceType)) {
                    return value;
                }
                return new Cast((Expression)value, node.getType(), node.isSafe());
            }
            if (value == null) {
                return null;
            }
            ResolvedFunction operator = IrExpressionInterpreter.this.metadata.getCoercion(sourceType, targetType);
            try {
                return IrExpressionInterpreter.this.functionInvoker.invoke(operator, IrExpressionInterpreter.this.connectorSession, (List<Object>)ImmutableList.of((Object)value));
            }
            catch (RuntimeException e) {
                if (node.isSafe()) {
                    return null;
                }
                throw e;
            }
        }

        protected Object visitArray(Array node, Object context) {
            Type elementType = ((ArrayType)this.type((Expression)node)).getElementType();
            BlockBuilder arrayBlockBuilder = elementType.createBlockBuilder(null, node.getValues().size());
            for (Expression expression : node.getValues()) {
                Object value = this.processWithExceptionHandling(expression, context);
                if (value instanceof Expression) {
                    Failures.checkCondition(node.getValues().size() <= 254, (ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Too many arguments for array constructor", new Object[0]);
                    return this.visitFunctionCall(BuiltinFunctionCallBuilder.resolve(IrExpressionInterpreter.this.metadata).setName("$array").setArguments(this.types(node.getValues()), node.getValues()).build(), context);
                }
                TypeUtils.writeNativeValue((Type)elementType, (BlockBuilder)arrayBlockBuilder, (Object)value);
            }
            return arrayBlockBuilder.build();
        }

        protected Object visitRow(Row node, Object context) {
            RowType rowType = (RowType)this.type((Expression)node);
            List parameterTypes = rowType.getTypeParameters();
            List arguments = node.getItems();
            int cardinality = arguments.size();
            ArrayList<Object> values = new ArrayList<Object>(cardinality);
            for (Expression argument : arguments) {
                values.add(this.processWithExceptionHandling(argument, context));
            }
            if (this.hasUnresolvedValue(values)) {
                return new Row(this.toExpressions(values, parameterTypes));
            }
            return RowValueBuilder.buildRowValue((RowType)rowType, fields -> {
                for (int i = 0; i < cardinality; ++i) {
                    TypeUtils.writeNativeValue((Type)((Type)parameterTypes.get(i)), (BlockBuilder)((BlockBuilder)fields.get(i)), values.get(i));
                }
            });
        }

        protected Object visitSubscriptExpression(SubscriptExpression node, Object context) {
            Object base = this.processWithExceptionHandling(node.getBase(), context);
            if (base == null) {
                return null;
            }
            Object index = this.processWithExceptionHandling(node.getIndex(), context);
            if (index == null) {
                return null;
            }
            if (index instanceof Long && IrExpressionInterpreter.isArray(this.type(node.getBase()))) {
                ArraySubscriptOperator.checkArrayIndex((Long)index);
            }
            if (this.hasUnresolvedValue(base, index)) {
                return new SubscriptExpression(this.toExpression(base, this.type(node.getBase())), this.toExpression(index, this.type(node.getIndex())));
            }
            if (base instanceof SqlRow) {
                SqlRow row = (SqlRow)base;
                int fieldIndex = Math.toIntExact((Long)index - 1L);
                if (fieldIndex < 0 || fieldIndex >= row.getFieldCount()) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "ROW index out of bounds: " + (fieldIndex + 1));
                }
                Type returnType = (Type)this.type(node.getBase()).getTypeParameters().get(fieldIndex);
                return TypeUtils.readNativeValue((Type)returnType, (Block)row.getRawFieldBlock(fieldIndex), (int)row.getRawIndex());
            }
            return this.invokeOperator(OperatorType.SUBSCRIPT, this.types(node.getBase(), node.getIndex()), (List<Object>)ImmutableList.of((Object)base, (Object)index));
        }

        protected Object visitExpression(Expression node, Object context) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "not yet implemented: " + node.getClass().getName());
        }

        private List<Type> types(Expression ... expressions) {
            return (List)Stream.of(expressions).map(NodeRef::of).map(IrExpressionInterpreter.this.expressionTypes::get).collect(ImmutableList.toImmutableList());
        }

        private List<Type> types(List<Expression> expressions) {
            return (List)expressions.stream().map(NodeRef::of).map(IrExpressionInterpreter.this.expressionTypes::get).collect(ImmutableList.toImmutableList());
        }

        private boolean hasUnresolvedValue(Object ... values) {
            return this.hasUnresolvedValue((List<Object>)ImmutableList.copyOf((Object[])values));
        }

        private boolean hasUnresolvedValue(List<Object> values) {
            return values.stream().anyMatch(Predicates.instanceOf(Expression.class));
        }

        private Object invokeOperator(OperatorType operatorType, List<? extends Type> argumentTypes, List<Object> argumentValues) {
            ResolvedFunction operator = IrExpressionInterpreter.this.metadata.resolveOperator(operatorType, argumentTypes);
            return IrExpressionInterpreter.this.functionInvoker.invoke(operator, IrExpressionInterpreter.this.connectorSession, argumentValues);
        }

        private Expression toExpression(Object base, Type type) {
            return IrExpressionInterpreter.this.literalEncoder.toExpression(base, type);
        }

        private List<Expression> toExpressions(List<Object> values, List<Type> types) {
            return IrExpressionInterpreter.this.literalEncoder.toExpressions(values, types);
        }
    }

    private static class LambdaSymbolResolver
    implements SymbolResolver {
        private final Map<String, Object> values;

        public LambdaSymbolResolver(Map<String, Object> values) {
            this.values = Objects.requireNonNull(values, "values is null");
        }

        @Override
        public Object getValue(Symbol symbol) {
            Preconditions.checkState((boolean)this.values.containsKey(symbol.getName()), (String)"values does not contain %s", (Object)symbol);
            return this.values.get(symbol.getName());
        }
    }
}

