/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.Metadata;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.Patterns;
import java.util.Objects;

public class MergeFilters
implements Rule<FilterNode> {
    private static final Capture<FilterNode> CHILD = Capture.newCapture();
    private static final Pattern<FilterNode> PATTERN = Patterns.filter().with(Patterns.source().matching(Patterns.filter().capturedAs(CHILD)));
    private final Metadata metadata;

    public MergeFilters(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public Pattern<FilterNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(FilterNode parent, Captures captures, Rule.Context context) {
        FilterNode child = (FilterNode)captures.get(CHILD);
        return Rule.Result.ofPlanNode(new FilterNode(parent.getId(), child.getSource(), IrUtils.combineConjuncts(this.metadata, child.getPredicate(), parent.getPredicate())));
    }
}

