/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.function.FunctionId;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.optimizations.QueryCardinalityUtil;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.Row;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PruneCountAggregationOverScalar
implements Rule<AggregationNode> {
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation();
    private final Metadata metadata;

    public PruneCountAggregationOverScalar(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode parent, Captures captures, Rule.Context context) {
        if (!parent.hasDefaultOutput() || parent.getOutputSymbols().size() != 1) {
            return Rule.Result.empty();
        }
        FunctionId countFunctionId = this.metadata.resolveBuiltinFunction("count", (List<TypeSignatureProvider>)ImmutableList.of()).getFunctionId();
        Map<Symbol, AggregationNode.Aggregation> assignments = parent.getAggregations();
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : assignments.entrySet()) {
            AggregationNode.Aggregation aggregation = entry.getValue();
            Objects.requireNonNull(aggregation, "aggregation is null");
            ResolvedFunction resolvedFunction = aggregation.getResolvedFunction();
            if (countFunctionId.equals((Object)resolvedFunction.getFunctionId())) continue;
            return Rule.Result.empty();
        }
        if (!assignments.isEmpty() && QueryCardinalityUtil.isScalar(parent.getSource(), context.getLookup())) {
            return Rule.Result.ofPlanNode(new ValuesNode(parent.getId(), parent.getOutputSymbols(), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new GenericLiteral("BIGINT", "1"))))));
        }
        return Rule.Result.empty();
    }
}

