/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ProjectOffPushDownRule;
import io.trino.sql.planner.iterative.rule.Util;
import io.trino.sql.planner.plan.PatternRecognitionNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.RowsPerMatch;
import io.trino.sql.planner.plan.SkipToPosition;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.planner.rowpattern.ExpressionAndValuePointers;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class PrunePattenRecognitionColumns
extends ProjectOffPushDownRule<PatternRecognitionNode> {
    public PrunePattenRecognitionColumns() {
        super(Patterns.patternRecognition());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(Rule.Context context, PatternRecognitionNode patternRecognitionNode, Set<Symbol> referencedOutputs) {
        Map referencedFunctions = Maps.filterKeys(patternRecognitionNode.getWindowFunctions(), referencedOutputs::contains);
        Map referencedMeasures = Maps.filterKeys(patternRecognitionNode.getMeasures(), referencedOutputs::contains);
        if (referencedFunctions.isEmpty() && referencedMeasures.isEmpty() && this.passesAllRows(patternRecognitionNode)) {
            return Optional.of(patternRecognitionNode.getSource());
        }
        ImmutableSet.Builder referencedInputs = ImmutableSet.builder();
        patternRecognitionNode.getSource().getOutputSymbols().stream().filter(referencedOutputs::contains).forEach(arg_0 -> ((ImmutableSet.Builder)referencedInputs).add(arg_0));
        referencedInputs.addAll(patternRecognitionNode.getPartitionBy());
        patternRecognitionNode.getOrderingScheme().ifPresent(orderingScheme -> referencedInputs.addAll(orderingScheme.getOrderBy()));
        patternRecognitionNode.getHashSymbol().ifPresent(arg_0 -> ((ImmutableSet.Builder)referencedInputs).add(arg_0));
        referencedFunctions.values().stream().map(SymbolsExtractor::extractUnique).forEach(arg_0 -> ((ImmutableSet.Builder)referencedInputs).addAll(arg_0));
        referencedMeasures.values().stream().map(PatternRecognitionNode.Measure::getExpressionAndValuePointers).map(ExpressionAndValuePointers::getInputSymbols).forEach(arg_0 -> ((ImmutableSet.Builder)referencedInputs).addAll(arg_0));
        patternRecognitionNode.getCommonBaseFrame().flatMap(WindowNode.Frame::getEndValue).ifPresent(arg_0 -> ((ImmutableSet.Builder)referencedInputs).add(arg_0));
        patternRecognitionNode.getVariableDefinitions().values().stream().map(ExpressionAndValuePointers::getInputSymbols).forEach(arg_0 -> ((ImmutableSet.Builder)referencedInputs).addAll(arg_0));
        Optional<PlanNode> prunedSource = Util.restrictOutputs(context.getIdAllocator(), patternRecognitionNode.getSource(), (Set<Symbol>)referencedInputs.build());
        if (prunedSource.isEmpty() && referencedFunctions.size() == patternRecognitionNode.getWindowFunctions().size() && referencedMeasures.size() == patternRecognitionNode.getMeasures().size()) {
            return Optional.empty();
        }
        return Optional.of(new PatternRecognitionNode(patternRecognitionNode.getId(), prunedSource.orElse(patternRecognitionNode.getSource()), patternRecognitionNode.getSpecification(), patternRecognitionNode.getHashSymbol(), patternRecognitionNode.getPrePartitionedInputs(), patternRecognitionNode.getPreSortedOrderPrefix(), referencedFunctions, referencedMeasures, patternRecognitionNode.getCommonBaseFrame(), patternRecognitionNode.getRowsPerMatch(), patternRecognitionNode.getSkipToLabels(), patternRecognitionNode.getSkipToPosition(), patternRecognitionNode.isInitial(), patternRecognitionNode.getPattern(), patternRecognitionNode.getVariableDefinitions()));
    }

    private boolean passesAllRows(PatternRecognitionNode node) {
        return node.getRowsPerMatch() == RowsPerMatch.WINDOW || node.getRowsPerMatch().isUnmatchedRows() && node.getSkipToPosition() == SkipToPosition.PAST_LAST;
    }
}

