/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.optimizations.QueryCardinalityUtil;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TopNNode;
import java.util.List;

public class PushTopNThroughOuterJoin
implements Rule<TopNNode> {
    private static final Capture<JoinNode> JOIN_CHILD = Capture.newCapture();
    private static final Pattern<TopNNode> PATTERN = Patterns.topN().with(Patterns.TopN.step().equalTo((Object)TopNNode.Step.PARTIAL)).with(Patterns.source().matching(Patterns.join().capturedAs(JOIN_CHILD).with(Patterns.Join.type().matching(type -> type == JoinType.LEFT || type == JoinType.RIGHT))));

    @Override
    public Pattern<TopNNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(TopNNode parent, Captures captures, Rule.Context context) {
        JoinNode joinNode = (JoinNode)captures.get(JOIN_CHILD);
        List<Symbol> orderBySymbols = parent.getOrderingScheme().getOrderBy();
        PlanNode left = joinNode.getLeft();
        PlanNode right = joinNode.getRight();
        JoinType type = joinNode.getType();
        if (type == JoinType.LEFT && ImmutableSet.copyOf(left.getOutputSymbols()).containsAll(orderBySymbols) && !QueryCardinalityUtil.isAtMost(left, context.getLookup(), parent.getCount())) {
            return Rule.Result.ofPlanNode(joinNode.replaceChildren((List<PlanNode>)ImmutableList.of((Object)parent.replaceChildren((List<PlanNode>)ImmutableList.of((Object)left)), (Object)right)));
        }
        if (type == JoinType.RIGHT && ImmutableSet.copyOf(right.getOutputSymbols()).containsAll(orderBySymbols) && !QueryCardinalityUtil.isAtMost(right, context.getLookup(), parent.getCount())) {
            return Rule.Result.ofPlanNode(joinNode.replaceChildren((List<PlanNode>)ImmutableList.of((Object)left, (Object)parent.replaceChildren((List<PlanNode>)ImmutableList.of((Object)right)))));
        }
        return Rule.Result.empty();
    }
}

