/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.iterative.Lookup;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.optimizations.QueryCardinalityUtil;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.BooleanLiteral;

public class RemoveUnreferencedScalarSubqueries
implements Rule<CorrelatedJoinNode> {
    private static final Pattern<CorrelatedJoinNode> PATTERN = Patterns.correlatedJoin().with(Patterns.CorrelatedJoin.filter().equalTo((Object)BooleanLiteral.TRUE_LITERAL));

    @Override
    public Pattern<CorrelatedJoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(CorrelatedJoinNode correlatedJoinNode, Captures captures, Rule.Context context) {
        PlanNode input = correlatedJoinNode.getInput();
        PlanNode subquery = correlatedJoinNode.getSubquery();
        if (this.isUnreferencedScalar(input, context.getLookup()) && correlatedJoinNode.getCorrelation().isEmpty() && (correlatedJoinNode.getType() == JoinType.INNER || correlatedJoinNode.getType() == JoinType.RIGHT || QueryCardinalityUtil.isAtLeastScalar(subquery, context.getLookup()))) {
            return Rule.Result.ofPlanNode(subquery);
        }
        if (this.isUnreferencedScalar(subquery, context.getLookup())) {
            return Rule.Result.ofPlanNode(input);
        }
        return Rule.Result.empty();
    }

    private boolean isUnreferencedScalar(PlanNode planNode, Lookup lookup) {
        return planNode.getOutputSymbols().isEmpty() && QueryCardinalityUtil.isScalar(planNode, lookup);
    }
}

