/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.AggregationDecorrelation;
import io.trino.sql.planner.iterative.rule.Util;
import io.trino.sql.planner.optimizations.PlanNodeDecorrelator;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.AssignUniqueId;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.BooleanLiteral;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class TransformCorrelatedGroupedAggregationWithoutProjection
implements Rule<CorrelatedJoinNode> {
    private static final Capture<AggregationNode> AGGREGATION = Capture.newCapture();
    private static final Capture<PlanNode> SOURCE = Capture.newCapture();
    private static final Pattern<CorrelatedJoinNode> PATTERN = Patterns.correlatedJoin().with(Patterns.CorrelatedJoin.type().equalTo((Object)JoinType.INNER)).with(Pattern.nonEmpty(Patterns.CorrelatedJoin.correlation())).with(Patterns.CorrelatedJoin.filter().equalTo((Object)BooleanLiteral.TRUE_LITERAL)).with(Patterns.CorrelatedJoin.subquery().matching(Patterns.aggregation().with(Pattern.nonEmpty(Patterns.Aggregation.groupingColumns())).matching(aggregation -> aggregation.getGroupingSetCount() == 1).with(Patterns.source().capturedAs(SOURCE)).capturedAs(AGGREGATION)));
    private final PlannerContext plannerContext;

    public TransformCorrelatedGroupedAggregationWithoutProjection(PlannerContext plannerContext) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
    }

    @Override
    public Pattern<CorrelatedJoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(CorrelatedJoinNode correlatedJoinNode, Captures captures, Rule.Context context) {
        PlanNode source = (PlanNode)captures.get(SOURCE);
        AggregationNode distinct = null;
        PlanNodeDecorrelator decorrelator = new PlanNodeDecorrelator(this.plannerContext, context.getSymbolAllocator(), context.getLookup());
        Optional<PlanNodeDecorrelator.DecorrelatedNode> decorrelatedSource = decorrelator.decorrelateFilters(source, correlatedJoinNode.getCorrelation());
        if (decorrelatedSource.isEmpty()) {
            if (AggregationDecorrelation.isDistinctOperator(source)) {
                distinct = (AggregationNode)source;
                source = distinct.getSource();
                decorrelatedSource = decorrelator.decorrelateFilters(source, correlatedJoinNode.getCorrelation());
            }
            if (decorrelatedSource.isEmpty()) {
                return Rule.Result.empty();
            }
        }
        source = decorrelatedSource.get().getNode();
        AssignUniqueId inputWithUniqueId = new AssignUniqueId(context.getIdAllocator().getNextId(), correlatedJoinNode.getInput(), context.getSymbolAllocator().newSymbol("unique", (Type)BigintType.BIGINT));
        JoinNode join = new JoinNode(context.getIdAllocator().getNextId(), JoinType.INNER, inputWithUniqueId, source, (List<JoinNode.EquiJoinClause>)ImmutableList.of(), ((PlanNode)inputWithUniqueId).getOutputSymbols(), source.getOutputSymbols(), false, decorrelatedSource.get().getCorrelatedPredicates(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of(), Optional.empty());
        if (distinct != null) {
            distinct = AggregationDecorrelation.restoreDistinctAggregation(distinct, join, (List<Symbol>)ImmutableList.builder().addAll(join.getLeftOutputSymbols()).addAll(distinct.getGroupingKeys()).build());
        }
        AggregationNode groupedAggregation = (AggregationNode)captures.get(AGGREGATION);
        groupedAggregation = AggregationNode.builderFrom(groupedAggregation).setSource(distinct != null ? distinct : join).setAggregations(groupedAggregation.getAggregations()).setGroupingSets(AggregationNode.singleGroupingSet((List<Symbol>)ImmutableList.builder().addAll(join.getLeftOutputSymbols()).addAll(groupedAggregation.getGroupingKeys()).build())).setPreGroupedSymbols((List<Symbol>)ImmutableList.of()).setHashSymbol(Optional.empty()).setGroupIdSymbol(Optional.empty()).build();
        Optional<PlanNode> project = Util.restrictOutputs(context.getIdAllocator(), groupedAggregation, (Set<Symbol>)ImmutableSet.copyOf(correlatedJoinNode.getOutputSymbols()));
        return Rule.Result.ofPlanNode(project.orElse(groupedAggregation));
    }
}

