/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.SetMultimap;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.cost.CachingStatsProvider;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.StatsCalculator;
import io.trino.cost.StatsProvider;
import io.trino.cost.TableStatsProvider;
import io.trino.cost.TaskCountEstimator;
import io.trino.operator.RetryPolicy;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.GroupingProperty;
import io.trino.spi.connector.LocalProperty;
import io.trino.spi.connector.WriterScalingOptions;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.DomainTranslator;
import io.trino.sql.planner.IrTypeAnalyzer;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.iterative.rule.PushPredicateIntoTableScan;
import io.trino.sql.planner.optimizations.ActualProperties;
import io.trino.sql.planner.optimizations.LocalProperties;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.optimizations.PreferredProperties;
import io.trino.sql.planner.optimizations.PropertyDerivations;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ApplyNode;
import io.trino.sql.planner.plan.AssignUniqueId;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.ChildReplacer;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.DistinctLimitNode;
import io.trino.sql.planner.plan.EnforceSingleRowNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.ExplainAnalyzeNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.GroupIdNode;
import io.trino.sql.planner.plan.IndexJoinNode;
import io.trino.sql.planner.plan.IndexSourceNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.MarkDistinctNode;
import io.trino.sql.planner.plan.MergeWriterNode;
import io.trino.sql.planner.plan.OutputNode;
import io.trino.sql.planner.plan.PatternRecognitionNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.RefreshMaterializedViewNode;
import io.trino.sql.planner.plan.RowNumberNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import io.trino.sql.planner.plan.SimpleTableExecuteNode;
import io.trino.sql.planner.plan.SortNode;
import io.trino.sql.planner.plan.SpatialJoinNode;
import io.trino.sql.planner.plan.StatisticsWriterNode;
import io.trino.sql.planner.plan.TableDeleteNode;
import io.trino.sql.planner.plan.TableExecuteNode;
import io.trino.sql.planner.plan.TableFinishNode;
import io.trino.sql.planner.plan.TableFunctionNode;
import io.trino.sql.planner.plan.TableFunctionProcessorNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.TableUpdateNode;
import io.trino.sql.planner.plan.TableWriterNode;
import io.trino.sql.planner.plan.TopNNode;
import io.trino.sql.planner.plan.TopNRankingNode;
import io.trino.sql.planner.plan.UnionNode;
import io.trino.sql.planner.plan.UnnestNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.SymbolReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AddExchanges
implements PlanOptimizer {
    private final PlannerContext plannerContext;
    private final IrTypeAnalyzer typeAnalyzer;
    private final StatsCalculator statsCalculator;
    private final TaskCountEstimator taskCountEstimator;

    public AddExchanges(PlannerContext plannerContext, IrTypeAnalyzer typeAnalyzer, StatsCalculator statsCalculator, TaskCountEstimator taskCountEstimator) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
        this.taskCountEstimator = Objects.requireNonNull(taskCountEstimator, "taskCountEstimator is null");
    }

    @Override
    public PlanNode optimize(PlanNode plan, PlanOptimizer.Context context) {
        PlanWithProperties result = plan.accept(new Rewriter(context.idAllocator(), context.symbolAllocator(), context.session(), context.tableStatsProvider()), PreferredProperties.any());
        return result.getNode();
    }

    private static Map<Symbol, Symbol> computeIdentityTranslations(Assignments assignments) {
        HashMap<Symbol, Symbol> outputToInput = new HashMap<Symbol, Symbol>();
        for (Map.Entry<Symbol, Expression> assignment : assignments.getMap().entrySet()) {
            if (!(assignment.getValue() instanceof SymbolReference)) continue;
            outputToInput.put(assignment.getKey(), Symbol.from(assignment.getValue()));
        }
        return outputToInput;
    }

    private static int countRepartitionedRemoteExchangeNodes(PlanNode root) {
        return PlanNodeSearcher.searchFrom(root).where(node -> {
            ExchangeNode exchangeNode;
            return node instanceof ExchangeNode && (exchangeNode = (ExchangeNode)node).getScope() == ExchangeNode.Scope.REMOTE && exchangeNode.getType() == ExchangeNode.Type.REPARTITION;
        }).recurseOnlyWhen(AddExchanges::isNotRemoteExchange).findAll().size();
    }

    private static int countPartitionedConnectorSource(PlanNode root) {
        return PlanNodeSearcher.searchFrom(root).where(node -> {
            TableScanNode tableScanNode;
            return node instanceof TableScanNode && (tableScanNode = (TableScanNode)node).getUseConnectorNodePartitioning().orElse(false) != false;
        }).recurseOnlyWhen(AddExchanges::isNotRemoteExchange).findAll().size();
    }

    private static boolean hasMultipleSources(PlanNode ... nodes) {
        return AddExchanges.countSources(nodes) > 1;
    }

    private static int countSources(PlanNode ... nodes) {
        return AddExchanges.countSources(Arrays.asList(nodes));
    }

    private static int countSources(List<PlanNode> nodes) {
        return nodes.stream().mapToInt(node -> PlanNodeSearcher.searchFrom(node).where(TableScanNode.class::isInstance).recurseOnlyWhen(AddExchanges::isNotRemoteExchange).findAll().size()).sum();
    }

    private static Stream<CatalogHandle> collectSourceCatalogs(PlanNode root) {
        return PlanNodeSearcher.searchFrom(root).where(node -> node instanceof TableScanNode).recurseOnlyWhen(AddExchanges::isNotRemoteExchange).findAll().stream().map(TableScanNode.class::cast).map(node -> node.getTable().getCatalogHandle());
    }

    private static boolean isNotRemoteExchange(PlanNode node) {
        ExchangeNode exchangeNode;
        return !(node instanceof ExchangeNode && (exchangeNode = (ExchangeNode)node).getScope() == ExchangeNode.Scope.REMOTE);
    }

    private class Rewriter
    extends PlanVisitor<PlanWithProperties, PreferredProperties> {
        private static final int PREFER_PARENT_PARTITIONING_MIN_PARTITIONS_PER_DRIVER_MULTIPLIER = 128;
        private final PlanNodeIdAllocator idAllocator;
        private final SymbolAllocator symbolAllocator;
        private final TypeProvider types;
        private final StatsProvider statsProvider;
        private final Session session;
        private final DomainTranslator domainTranslator;
        private final boolean redistributeWrites;

        public Rewriter(PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator, Session session, TableStatsProvider tableStatsProvider) {
            this.idAllocator = idAllocator;
            this.symbolAllocator = symbolAllocator;
            this.types = symbolAllocator.getTypes();
            this.statsProvider = new CachingStatsProvider(AddExchanges.this.statsCalculator, session, this.types, tableStatsProvider);
            this.session = session;
            this.domainTranslator = new DomainTranslator(AddExchanges.this.plannerContext);
            this.redistributeWrites = SystemSessionProperties.isRedistributeWrites(session);
        }

        @Override
        protected PlanWithProperties visitPlan(PlanNode node, PreferredProperties preferredProperties) {
            return this.rebaseAndDeriveProperties(node, this.planChild(node, preferredProperties));
        }

        @Override
        public PlanWithProperties visitProject(ProjectNode node, PreferredProperties preferredProperties) {
            Map<Symbol, Symbol> identities = AddExchanges.computeIdentityTranslations(node.getAssignments());
            PreferredProperties translatedPreferred = preferredProperties.translate(symbol -> Optional.ofNullable((Symbol)identities.get(symbol)));
            return this.rebaseAndDeriveProperties((PlanNode)node, this.planChild(node, translatedPreferred));
        }

        @Override
        public PlanWithProperties visitOutput(OutputNode node, PreferredProperties preferredProperties) {
            PlanWithProperties child = this.planChild(node, PreferredProperties.undistributed());
            if (!child.getProperties().isSingleNode() && SystemSessionProperties.isForceSingleNodeOutput(this.session)) {
                child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitEnforceSingleRow(EnforceSingleRowNode node, PreferredProperties preferredProperties) {
            PlanWithProperties child = this.planChild(node, PreferredProperties.any());
            if (!child.getProperties().isSingleNode()) {
                child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitAggregation(AggregationNode node, PreferredProperties parentPreferredProperties) {
            PlanWithProperties child;
            PreferredProperties preferredProperties;
            ImmutableSet partitioningRequirement = ImmutableSet.copyOf(node.getGroupingKeys());
            boolean preferSingleNode = node.hasSingleNodeExecutionPreference(this.session, AddExchanges.this.plannerContext.getMetadata());
            PreferredProperties preferredProperties2 = preferredProperties = preferSingleNode ? PreferredProperties.undistributed() : PreferredProperties.any();
            if (!node.getGroupingKeys().isEmpty()) {
                preferredProperties = this.computePreference(PreferredProperties.partitionedWithLocal((Set<Symbol>)partitioningRequirement, LocalProperties.grouped(node.getGroupingKeys())), parentPreferredProperties);
            }
            if ((child = this.planChild(node, preferredProperties)).getProperties().isSingleNode()) {
                return this.rebaseAndDeriveProperties((PlanNode)node, child);
            }
            if (preferSingleNode) {
                child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode()), child.getProperties());
            } else if (!this.isNodePartitionedOn(child.getProperties(), (Collection<Symbol>)partitioningRequirement) || node.hasEmptyGroupingSet()) {
                List<Symbol> partitioningKeys = parentPreferredProperties.getGlobalProperties().flatMap(PreferredProperties.Global::getPartitioningProperties).map(PreferredProperties.PartitioningProperties::getPartitioningColumns).flatMap(partitioningColumns -> this.useParentPreferredPartitioning(node, (Set<Symbol>)partitioningColumns)).orElse(node.getGroupingKeys());
                child = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode(), partitioningKeys, node.getHashSymbol()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        private Optional<List<Symbol>> useParentPreferredPartitioning(AggregationNode node, Set<Symbol> parentPreferredPartitioningColumns) {
            if (SystemSessionProperties.isUseExactPartitioning(this.session) || !SystemSessionProperties.isUseCostBasedPartitioning(this.session)) {
                return Optional.empty();
            }
            if (parentPreferredPartitioningColumns.isEmpty()) {
                return Optional.empty();
            }
            if (!ImmutableSet.copyOf(node.getGroupingKeys()).containsAll(parentPreferredPartitioningColumns)) {
                return Optional.empty();
            }
            double parentPartitioningNDV = Rewriter.getMinDistinctValueCountEstimate(this.statsProvider.getStats(node), parentPreferredPartitioningColumns);
            if (Double.isNaN(parentPartitioningNDV)) {
                return Optional.empty();
            }
            int maxConcurrentPartitionsCount = AddExchanges.this.taskCountEstimator.estimateHashedTaskCount(this.session) * SystemSessionProperties.getTaskConcurrency(this.session);
            if (parentPartitioningNDV <= (double)(128 * maxConcurrentPartitionsCount)) {
                return Optional.empty();
            }
            ImmutableList newGroupingKeys = ImmutableList.copyOf(parentPreferredPartitioningColumns);
            return Optional.of(newGroupingKeys);
        }

        private static double getMinDistinctValueCountEstimate(PlanNodeStatsEstimate nodeStatsEstimate, Set<Symbol> groupingKeys) {
            double min = Double.NaN;
            for (Symbol groupingKey : groupingKeys) {
                double distinctValuesCount = nodeStatsEstimate.getSymbolStatistics(groupingKey).getDistinctValuesCount();
                if (Double.isNaN(distinctValuesCount)) {
                    return Double.NaN;
                }
                if (!Double.isNaN(min) && !(distinctValuesCount < min)) continue;
                min = distinctValuesCount;
            }
            return min;
        }

        @Override
        public PlanWithProperties visitGroupId(GroupIdNode node, PreferredProperties preferredProperties) {
            PreferredProperties childPreference = preferredProperties.translate(this.translateGroupIdSymbols(node));
            PlanWithProperties child = this.planChild(node, childPreference);
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        private Function<Symbol, Optional<Symbol>> translateGroupIdSymbols(GroupIdNode node) {
            return symbol -> {
                if (node.getAggregationArguments().contains(symbol)) {
                    return Optional.of(symbol);
                }
                if (node.getCommonGroupingColumns().contains(symbol)) {
                    return Optional.of(node.getGroupingColumns().get(symbol));
                }
                return Optional.empty();
            };
        }

        @Override
        public PlanWithProperties visitMarkDistinct(MarkDistinctNode node, PreferredProperties preferredProperties) {
            PreferredProperties preferredChildProperties = this.computePreference(PreferredProperties.partitionedWithLocal((Set<Symbol>)ImmutableSet.copyOf(node.getDistinctSymbols()), LocalProperties.grouped(node.getDistinctSymbols())), preferredProperties);
            PlanWithProperties child = node.getSource().accept(this, preferredChildProperties);
            if (child.getProperties().isSingleNode() || !this.isNodePartitionedOn(child.getProperties(), node.getDistinctSymbols())) {
                child = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode(), node.getDistinctSymbols(), node.getHashSymbol()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitWindow(WindowNode node, PreferredProperties preferredProperties) {
            ArrayList<GroupingProperty> desiredProperties = new ArrayList<GroupingProperty>();
            if (!node.getPartitionBy().isEmpty()) {
                desiredProperties.add(new GroupingProperty(node.getPartitionBy()));
            }
            node.getOrderingScheme().ifPresent(orderingScheme -> desiredProperties.addAll(orderingScheme.toLocalProperties()));
            PlanWithProperties child = this.planChild(node, this.computePreference(PreferredProperties.partitionedWithLocal((Set<Symbol>)ImmutableSet.copyOf(node.getPartitionBy()), desiredProperties), preferredProperties));
            if (!this.isNodePartitionedOn(child.getProperties(), node.getPartitionBy())) {
                child = node.getPartitionBy().isEmpty() ? this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode()), child.getProperties()) : this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode(), node.getPartitionBy(), node.getHashSymbol()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitPatternRecognition(PatternRecognitionNode node, PreferredProperties preferredProperties) {
            ArrayList<GroupingProperty> desiredProperties = new ArrayList<GroupingProperty>();
            if (!node.getPartitionBy().isEmpty()) {
                desiredProperties.add(new GroupingProperty(node.getPartitionBy()));
            }
            node.getOrderingScheme().ifPresent(orderingScheme -> desiredProperties.addAll(orderingScheme.toLocalProperties()));
            PlanWithProperties child = this.planChild(node, this.computePreference(PreferredProperties.partitionedWithLocal((Set<Symbol>)ImmutableSet.copyOf(node.getPartitionBy()), desiredProperties), preferredProperties));
            if (!this.isNodePartitionedOn(child.getProperties(), node.getPartitionBy())) {
                child = node.getPartitionBy().isEmpty() ? this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode()), child.getProperties()) : this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode(), node.getPartitionBy(), node.getHashSymbol()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitTableFunction(TableFunctionNode node, PreferredProperties preferredProperties) {
            throw new IllegalStateException(String.format("Unexpected node: TableFunctionNode (%s)", node.getName()));
        }

        @Override
        public PlanWithProperties visitTableFunctionProcessor(TableFunctionProcessorNode node, PreferredProperties preferredProperties) {
            if (node.getSource().isEmpty()) {
                return new PlanWithProperties(node, this.deriveProperties((PlanNode)node, (List<ActualProperties>)ImmutableList.of()));
            }
            if (node.getSpecification().isEmpty()) {
                PlanWithProperties child = this.planChild(node, PreferredProperties.any());
                return this.rebaseAndDeriveProperties((PlanNode)node, child);
            }
            List<Symbol> partitionBy = node.getSpecification().orElseThrow().getPartitionBy();
            ArrayList<GroupingProperty> desiredProperties = new ArrayList<GroupingProperty>();
            if (!partitionBy.isEmpty()) {
                desiredProperties.add(new GroupingProperty(partitionBy));
            }
            node.getSpecification().orElseThrow().getOrderingScheme().ifPresent(orderingScheme -> desiredProperties.addAll(orderingScheme.toLocalProperties()));
            PlanWithProperties child = this.planChild(node, PreferredProperties.partitionedWithLocal((Set<Symbol>)ImmutableSet.copyOf(partitionBy), desiredProperties));
            if (!node.isPruneWhenEmpty()) {
                child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode()), child.getProperties());
            } else if (!this.isNodePartitionedOn(child.getProperties(), partitionBy)) {
                child = partitionBy.isEmpty() ? this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode()), child.getProperties()) : this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode(), partitionBy, node.getHashSymbol()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitRowNumber(RowNumberNode node, PreferredProperties preferredProperties) {
            if (node.getPartitionBy().isEmpty()) {
                PlanWithProperties child = this.planChild(node, PreferredProperties.undistributed());
                if (!child.getProperties().isSingleNode()) {
                    child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode()), child.getProperties());
                }
                return this.rebaseAndDeriveProperties((PlanNode)node, child);
            }
            PlanWithProperties child = this.planChild(node, this.computePreference(PreferredProperties.partitionedWithLocal((Set<Symbol>)ImmutableSet.copyOf(node.getPartitionBy()), LocalProperties.grouped(node.getPartitionBy())), preferredProperties));
            if (!this.isNodePartitionedOn(child.getProperties(), node.getPartitionBy())) {
                child = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode(), node.getPartitionBy(), node.getHashSymbol()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitTopNRanking(TopNRankingNode node, PreferredProperties preferredProperties) {
            Function<PlanNode, PlanNode> addExchange;
            PreferredProperties preferredChildProperties;
            if (node.getPartitionBy().isEmpty()) {
                preferredChildProperties = PreferredProperties.any();
                addExchange = partial -> ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, partial);
            } else {
                preferredChildProperties = this.computePreference(PreferredProperties.partitionedWithLocal((Set<Symbol>)ImmutableSet.copyOf(node.getPartitionBy()), LocalProperties.grouped(node.getPartitionBy())), preferredProperties);
                addExchange = partial -> ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, partial, node.getPartitionBy(), node.getHashSymbol());
            }
            PlanWithProperties child = this.planChild(node, preferredChildProperties);
            if (!this.isNodePartitionedOn(child.getProperties(), node.getPartitionBy())) {
                child = this.withDerivedProperties(new TopNRankingNode(this.idAllocator.getNextId(), child.getNode(), node.getSpecification(), node.getRankingType(), node.getRankingSymbol(), node.getMaxRankingPerPartition(), true, node.getHashSymbol()), child.getProperties());
                child = this.withDerivedProperties(addExchange.apply(child.getNode()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitTopN(TopNNode node, PreferredProperties preferredProperties) {
            return switch (node.getStep()) {
                default -> throw new MatchException(null, null);
                case TopNNode.Step.SINGLE, TopNNode.Step.FINAL -> {
                    PlanWithProperties child = this.planChild(node, PreferredProperties.undistributed());
                    if (!child.getProperties().isSingleNode()) {
                        child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode()), child.getProperties());
                    }
                    yield this.rebaseAndDeriveProperties((PlanNode)node, child);
                }
                case TopNNode.Step.PARTIAL -> {
                    PlanWithProperties child = this.planChild(node, PreferredProperties.any());
                    List desiredProperties = node.getOrderingScheme().toLocalProperties();
                    boolean sortingSatisfied = LocalProperties.match(child.getProperties().getLocalProperties(), desiredProperties).stream().allMatch(Optional::isEmpty);
                    if (sortingSatisfied) {
                        yield this.withDerivedProperties(new LimitNode(node.getId(), child.getNode(), node.getCount(), Optional.empty(), true, node.getOrderingScheme().getOrderBy()), child.getProperties());
                    }
                    yield this.rebaseAndDeriveProperties((PlanNode)node, child);
                }
            };
        }

        @Override
        public PlanWithProperties visitSort(SortNode node, PreferredProperties preferredProperties) {
            PlanWithProperties child = this.planChild(node, PreferredProperties.undistributed());
            if (SystemSessionProperties.isDistributedSortEnabled(this.session)) {
                child = this.planChild(node, PreferredProperties.any());
                ExchangeNode source = ExchangeNode.roundRobinExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode());
                return this.withDerivedProperties(ExchangeNode.mergingExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, new SortNode(this.idAllocator.getNextId(), source, node.getOrderingScheme(), true), node.getOrderingScheme()), child.getProperties());
            }
            if (!child.getProperties().isSingleNode()) {
                child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitLimit(LimitNode node, PreferredProperties preferredProperties) {
            if (node.isWithTies()) {
                throw new IllegalStateException("Unexpected node: LimitNode with ties");
            }
            PlanWithProperties child = this.planChild(node, PreferredProperties.any());
            if (!node.isPartial() && !child.getProperties().isSingleNode()) {
                child = this.withDerivedProperties(new LimitNode(this.idAllocator.getNextId(), child.getNode(), node.getCount(), true), child.getProperties());
                child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitDistinctLimit(DistinctLimitNode node, PreferredProperties preferredProperties) {
            PlanWithProperties child = this.planChild(node, PreferredProperties.any());
            if (!child.getProperties().isSingleNode() && SystemSessionProperties.isUsePartialDistinctLimit(this.session)) {
                child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, new DistinctLimitNode(this.idAllocator.getNextId(), child.getNode(), node.getLimit(), true, node.getDistinctSymbols(), node.getHashSymbol())), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitFilter(FilterNode node, PreferredProperties preferredProperties) {
            Optional<PlanNode> plan;
            if (node.getSource() instanceof TableScanNode && (plan = PushPredicateIntoTableScan.pushFilterIntoTableScan(node, (TableScanNode)node.getSource(), true, this.session, this.symbolAllocator, AddExchanges.this.plannerContext, AddExchanges.this.typeAnalyzer, this.statsProvider, this.domainTranslator)).isPresent()) {
                return new PlanWithProperties(plan.get(), this.derivePropertiesRecursively(plan.get()));
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, this.planChild(node, preferredProperties));
        }

        @Override
        public PlanWithProperties visitTableScan(TableScanNode node, PreferredProperties preferredProperties) {
            return new PlanWithProperties(node, this.deriveProperties((PlanNode)node, (List<ActualProperties>)ImmutableList.of()));
        }

        @Override
        public PlanWithProperties visitRefreshMaterializedView(RefreshMaterializedViewNode node, PreferredProperties preferredProperties) {
            return new PlanWithProperties(node, this.deriveProperties((PlanNode)node, (List<ActualProperties>)ImmutableList.of()));
        }

        @Override
        public PlanWithProperties visitTableWriter(TableWriterNode node, PreferredProperties preferredProperties) {
            return this.visitTableWriter(node, node.getPartitioningScheme(), node.getSource(), preferredProperties, node.getTarget(), SystemSessionProperties.isScaleWriters(this.session));
        }

        @Override
        public PlanWithProperties visitTableExecute(TableExecuteNode node, PreferredProperties preferredProperties) {
            boolean scaleWriters = node.getPartitioningScheme().isEmpty() && SystemSessionProperties.isScaleWriters(this.session);
            return this.visitTableWriter(node, node.getPartitioningScheme(), node.getSource(), preferredProperties, node.getTarget(), scaleWriters);
        }

        @Override
        public PlanWithProperties visitSimpleTableExecuteNode(SimpleTableExecuteNode node, PreferredProperties context) {
            return new PlanWithProperties(node, ActualProperties.builder().global(ActualProperties.Global.singlePartition()).build());
        }

        private PlanWithProperties visitTableWriter(PlanNode node, Optional<PartitioningScheme> partitioningScheme, PlanNode source, PreferredProperties preferredProperties, TableWriterNode.WriterTarget writerTarget, boolean scaleWriters) {
            PlanWithProperties newSource = source.accept(this, preferredProperties);
            PlanWithProperties partitionedSource = this.getWriterPlanWithProperties(partitioningScheme, newSource, writerTarget, scaleWriters);
            return this.rebaseAndDeriveProperties(node, partitionedSource);
        }

        @Override
        public PlanWithProperties visitMergeWriter(MergeWriterNode node, PreferredProperties preferredProperties) {
            PlanWithProperties source = node.getSource().accept(this, preferredProperties);
            Optional<PartitioningScheme> partitioningScheme = node.getPartitioningScheme();
            PlanWithProperties partitionedSource = this.getWriterPlanWithProperties(partitioningScheme, source, node.getTarget(), false);
            return this.rebaseAndDeriveProperties((PlanNode)node, partitionedSource);
        }

        private PlanWithProperties getWriterPlanWithProperties(Optional<PartitioningScheme> partitioningScheme, PlanWithProperties newSource, TableWriterNode.WriterTarget writerTarget, boolean scaleWriters) {
            WriterScalingOptions scalingOptions = writerTarget.getWriterScalingOptions(AddExchanges.this.plannerContext.getMetadata(), this.session);
            if (partitioningScheme.isEmpty()) {
                Optional<Integer> maxWritersNodesCount;
                int maxWriterTasks = writerTarget.getMaxWriterTasks(AddExchanges.this.plannerContext.getMetadata(), this.session).orElse(SystemSessionProperties.getMaxWriterTaskCount(this.session));
                Optional<Integer> optional = maxWritersNodesCount = SystemSessionProperties.getRetryPolicy(this.session) != RetryPolicy.TASK ? Optional.of(Math.min(maxWriterTasks, SystemSessionProperties.getMaxWriterTaskCount(this.session))) : Optional.empty();
                if (scaleWriters && scalingOptions.isWriterTasksScalingEnabled()) {
                    partitioningScheme = Optional.of(new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SCALED_WRITER_ROUND_ROBIN_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), newSource.getNode().getOutputSymbols(), Optional.empty(), false, Optional.empty(), maxWritersNodesCount));
                } else if (this.redistributeWrites) {
                    partitioningScheme = Optional.of(new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), newSource.getNode().getOutputSymbols(), Optional.empty(), false, Optional.empty(), maxWritersNodesCount));
                }
            } else if (scaleWriters && scalingOptions.isWriterTasksScalingEnabled() && writerTarget.supportsMultipleWritersPerPartition(AddExchanges.this.plannerContext.getMetadata(), this.session) && !newSource.getProperties().isCompatibleTablePartitioningWith(partitioningScheme.get().getPartitioning(), false, AddExchanges.this.plannerContext.getMetadata(), this.session)) {
                if (partitioningScheme.get().getPartitioning().getHandle().equals(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION)) {
                    partitioningScheme = Optional.of(partitioningScheme.get().withPartitioningHandle(SystemPartitioningHandle.SCALED_WRITER_HASH_DISTRIBUTION));
                } else {
                    PartitioningHandle partitioningHandle = partitioningScheme.get().getPartitioning().getHandle();
                    Verify.verify((!(partitioningHandle.getConnectorHandle() instanceof SystemPartitioningHandle) ? 1 : 0) != 0);
                    Verify.verify((boolean)partitioningScheme.get().getPartitioning().getArguments().stream().noneMatch(Partitioning.ArgumentBinding::isConstant), (String)"Table writer partitioning has constant arguments", (Object[])new Object[0]);
                    partitioningScheme = Optional.of(partitioningScheme.get().withPartitioningHandle(new PartitioningHandle(partitioningHandle.getCatalogHandle(), partitioningHandle.getTransactionHandle(), partitioningHandle.getConnectorHandle(), true)));
                }
            }
            if (partitioningScheme.isPresent() && !newSource.getProperties().isCompatibleTablePartitioningWith(partitioningScheme.get().getPartitioning(), false, AddExchanges.this.plannerContext.getMetadata(), this.session)) {
                newSource = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, newSource.getNode(), partitioningScheme.get()), newSource.getProperties());
            }
            return newSource;
        }

        @Override
        public PlanWithProperties visitValues(ValuesNode node, PreferredProperties preferredProperties) {
            return new PlanWithProperties(node, ActualProperties.builder().global(ActualProperties.Global.singlePartition()).build());
        }

        @Override
        public PlanWithProperties visitTableDelete(TableDeleteNode node, PreferredProperties context) {
            return new PlanWithProperties(node, ActualProperties.builder().global(ActualProperties.Global.singlePartition()).build());
        }

        @Override
        public PlanWithProperties visitTableUpdate(TableUpdateNode node, PreferredProperties context) {
            return new PlanWithProperties(node, ActualProperties.builder().global(ActualProperties.Global.singlePartition()).build());
        }

        @Override
        public PlanWithProperties visitExplainAnalyze(ExplainAnalyzeNode node, PreferredProperties preferredProperties) {
            PlanWithProperties child = this.planChild(node, PreferredProperties.any());
            if (child.getNode() instanceof ExchangeNode && ((ExchangeNode)child.getNode()).getType() == ExchangeNode.Type.GATHER) {
                return this.rebaseAndDeriveProperties((PlanNode)node, child);
            }
            child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode()), child.getProperties());
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitStatisticsWriterNode(StatisticsWriterNode node, PreferredProperties context) {
            PlanWithProperties child = this.planChild(node, PreferredProperties.any());
            if (child.getNode() instanceof ExchangeNode && ((ExchangeNode)child.getNode()).getType() == ExchangeNode.Type.GATHER) {
                return this.rebaseAndDeriveProperties((PlanNode)node, child);
            }
            if (!child.getProperties().isCoordinatorOnly()) {
                child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitTableFinish(TableFinishNode node, PreferredProperties preferredProperties) {
            PlanWithProperties child = this.planChild(node, PreferredProperties.any());
            if (child.getNode() instanceof ExchangeNode && ((ExchangeNode)child.getNode()).getType() == ExchangeNode.Type.GATHER) {
                return this.rebaseAndDeriveProperties((PlanNode)node, child);
            }
            if (!child.getProperties().isCoordinatorOnly()) {
                child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, child.getNode()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        private <T> SetMultimap<T, T> createMapping(List<T> keys, List<T> values) {
            Preconditions.checkArgument((keys.size() == values.size() ? 1 : 0) != 0, (Object)"Inputs must have the same size");
            ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
            for (int i = 0; i < keys.size(); ++i) {
                builder.put(keys.get(i), values.get(i));
            }
            return builder.build();
        }

        private <T> Function<T, Optional<T>> createTranslator(SetMultimap<T, T> inputToOutput) {
            return input -> inputToOutput.get(input).stream().findAny();
        }

        private <T> Function<T, T> createDirectTranslator(SetMultimap<T, T> inputToOutput) {
            return input -> inputToOutput.get(input).iterator().next();
        }

        @Override
        public PlanWithProperties visitJoin(JoinNode node, PreferredProperties preferredProperties) {
            List leftSymbols = (List)node.getCriteria().stream().map(JoinNode.EquiJoinClause::getLeft).collect(ImmutableList.toImmutableList());
            List rightSymbols = (List)node.getCriteria().stream().map(JoinNode.EquiJoinClause::getRight).collect(ImmutableList.toImmutableList());
            JoinNode.DistributionType distributionType = node.getDistributionType().orElseThrow(() -> new IllegalArgumentException("distributionType not yet set"));
            if (distributionType == JoinNode.DistributionType.REPLICATED) {
                PlanWithProperties left = node.getLeft().accept(this, PreferredProperties.any());
                if (!node.getCriteria().isEmpty() && this.isNodePartitionedOn(left.getProperties(), leftSymbols) && !left.getProperties().isSingleNode()) {
                    return this.planPartitionedJoin(node, leftSymbols, rightSymbols, left);
                }
                return this.planReplicatedJoin(node, left);
            }
            return this.planPartitionedJoin(node, leftSymbols, rightSymbols);
        }

        private PlanWithProperties planPartitionedJoin(JoinNode node, List<Symbol> leftSymbols, List<Symbol> rightSymbols) {
            return this.planPartitionedJoin(node, leftSymbols, rightSymbols, node.getLeft().accept(this, PreferredProperties.partitioned((Set<Symbol>)ImmutableSet.copyOf(leftSymbols))));
        }

        private PlanWithProperties planPartitionedJoin(JoinNode node, List<Symbol> leftSymbols, List<Symbol> rightSymbols, PlanWithProperties left) {
            PlanWithProperties right;
            Partitioning rightPartitioning;
            SetMultimap<Symbol, Symbol> rightToLeft = this.createMapping(rightSymbols, leftSymbols);
            SetMultimap<Symbol, Symbol> leftToRight = this.createMapping(leftSymbols, rightSymbols);
            if (this.isNodePartitionedOn(left.getProperties(), leftSymbols) && !left.getProperties().isSingleNode()) {
                rightPartitioning = left.getProperties().translate(this.createTranslator(leftToRight)).getNodePartitioning().get();
                right = node.getRight().accept(this, PreferredProperties.partitioned(rightPartitioning));
                if (!right.getProperties().isCompatibleTablePartitioningWith(left.getProperties(), arg_0 -> rightToLeft.get(arg_0), AddExchanges.this.plannerContext.getMetadata(), this.session)) {
                    right = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, right.getNode(), new PartitioningScheme(rightPartitioning, right.getNode().getOutputSymbols())), right.getProperties());
                }
            } else {
                right = node.getRight().accept(this, PreferredProperties.partitioned((Set<Symbol>)ImmutableSet.copyOf(rightSymbols)));
                if (this.isNodePartitionedOn(right.getProperties(), rightSymbols) && !right.getProperties().isSingleNode()) {
                    Partitioning leftPartitioning = right.getProperties().translate(this.createTranslator(rightToLeft)).getNodePartitioning().get();
                    left = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, left.getNode(), new PartitioningScheme(leftPartitioning, left.getNode().getOutputSymbols())), left.getProperties());
                } else {
                    left = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, left.getNode(), leftSymbols, Optional.empty()), left.getProperties());
                    right = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, right.getNode(), rightSymbols, Optional.empty()), right.getProperties());
                }
            }
            Verify.verify((boolean)left.getProperties().isCompatibleTablePartitioningWith(right.getProperties(), arg_0 -> leftToRight.get(arg_0), AddExchanges.this.plannerContext.getMetadata(), this.session));
            if (!SystemSessionProperties.isColocatedJoinEnabled(this.session) && AddExchanges.hasMultipleSources(left.getNode(), right.getNode())) {
                rightPartitioning = left.getProperties().translate(this.createTranslator(leftToRight)).getNodePartitioning().get();
                right = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, right.getNode(), new PartitioningScheme(rightPartitioning, right.getNode().getOutputSymbols())), right.getProperties());
            }
            return this.buildJoin(node, left, right, JoinNode.DistributionType.PARTITIONED);
        }

        private PlanWithProperties planReplicatedJoin(JoinNode node, PlanWithProperties left) {
            PlanWithProperties right = node.getRight().accept(this, PreferredProperties.any());
            if (left.getProperties().isSingleNode()) {
                if (!right.getProperties().isSingleNode() || !SystemSessionProperties.isColocatedJoinEnabled(this.session) && AddExchanges.hasMultipleSources(left.getNode(), right.getNode())) {
                    right = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, right.getNode()), right.getProperties());
                }
            } else {
                right = this.withDerivedProperties(ExchangeNode.replicatedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, right.getNode()), right.getProperties());
            }
            return this.buildJoin(node, left, right, JoinNode.DistributionType.REPLICATED);
        }

        private PlanWithProperties buildJoin(JoinNode node, PlanWithProperties newLeft, PlanWithProperties newRight, JoinNode.DistributionType newDistributionType) {
            JoinNode result = new JoinNode(node.getId(), node.getType(), newLeft.getNode(), newRight.getNode(), node.getCriteria(), node.getLeftOutputSymbols(), node.getRightOutputSymbols(), node.isMaySkipOutputDuplicates(), node.getFilter(), node.getLeftHashSymbol(), node.getRightHashSymbol(), Optional.of(newDistributionType), node.isSpillable(), node.getDynamicFilters(), node.getReorderJoinStatsAndCost());
            return new PlanWithProperties(result, this.deriveProperties((PlanNode)result, (List<ActualProperties>)ImmutableList.of((Object)newLeft.getProperties(), (Object)newRight.getProperties())));
        }

        @Override
        public PlanWithProperties visitSpatialJoin(SpatialJoinNode node, PreferredProperties preferredProperties) {
            SpatialJoinNode.DistributionType distributionType = node.getDistributionType();
            PlanWithProperties left = node.getLeft().accept(this, PreferredProperties.any());
            PlanWithProperties right = node.getRight().accept(this, PreferredProperties.any());
            if (distributionType == SpatialJoinNode.DistributionType.REPLICATED) {
                if (left.getProperties().isSingleNode()) {
                    if (!right.getProperties().isSingleNode()) {
                        right = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, right.getNode()), right.getProperties());
                    }
                } else {
                    right = this.withDerivedProperties(ExchangeNode.replicatedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, right.getNode()), right.getProperties());
                }
            } else {
                left = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, left.getNode(), (List<Symbol>)ImmutableList.of((Object)node.getLeftPartitionSymbol().get()), Optional.empty()), left.getProperties());
                right = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, right.getNode(), (List<Symbol>)ImmutableList.of((Object)node.getRightPartitionSymbol().get()), Optional.empty()), right.getProperties());
            }
            PlanNode newJoinNode = node.replaceChildren((List<PlanNode>)ImmutableList.of((Object)left.getNode(), (Object)right.getNode()));
            return new PlanWithProperties(newJoinNode, this.deriveProperties(newJoinNode, (List<ActualProperties>)ImmutableList.of((Object)left.getProperties(), (Object)right.getProperties())));
        }

        @Override
        public PlanWithProperties visitUnnest(UnnestNode node, PreferredProperties preferredProperties) {
            PreferredProperties translatedPreferred = preferredProperties.translate(symbol -> node.getReplicateSymbols().contains(symbol) ? Optional.of(symbol) : Optional.empty());
            return this.rebaseAndDeriveProperties((PlanNode)node, this.planChild(node, translatedPreferred));
        }

        @Override
        public PlanWithProperties visitSemiJoin(SemiJoinNode node, PreferredProperties preferredProperties) {
            PlanWithProperties filteringSource;
            PlanWithProperties source;
            SemiJoinNode.DistributionType distributionType = node.getDistributionType().orElseThrow(() -> new IllegalArgumentException("distributionType not yet set"));
            if (distributionType == SemiJoinNode.DistributionType.PARTITIONED) {
                Partitioning filteringPartitioning;
                ImmutableList sourceSymbols = ImmutableList.of((Object)node.getSourceJoinSymbol());
                ImmutableList filteringSourceSymbols = ImmutableList.of((Object)node.getFilteringSourceJoinSymbol());
                SetMultimap sourceToFiltering = this.createMapping((List)sourceSymbols, (List)filteringSourceSymbols);
                SetMultimap filteringToSource = this.createMapping((List)filteringSourceSymbols, (List)sourceSymbols);
                source = node.getSource().accept(this, PreferredProperties.partitioned((Set<Symbol>)ImmutableSet.copyOf((Collection)sourceSymbols)));
                if (this.isNodePartitionedOn(source.getProperties(), (Collection<Symbol>)sourceSymbols) && !source.getProperties().isSingleNode()) {
                    filteringPartitioning = source.getProperties().translate(this.createTranslator(sourceToFiltering)).getNodePartitioning().get();
                    filteringSource = node.getFilteringSource().accept(this, PreferredProperties.partitionedWithNullsAndAnyReplicated(filteringPartitioning));
                    if (!source.getProperties().withReplicatedNulls(true).isCompatibleTablePartitioningWith(filteringSource.getProperties(), arg_0 -> sourceToFiltering.get(arg_0), AddExchanges.this.plannerContext.getMetadata(), this.session)) {
                        filteringSource = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, filteringSource.getNode(), new PartitioningScheme(filteringPartitioning, filteringSource.getNode().getOutputSymbols(), Optional.empty(), true, Optional.empty(), Optional.empty())), filteringSource.getProperties());
                    }
                } else {
                    filteringSource = node.getFilteringSource().accept(this, PreferredProperties.partitionedWithNullsAndAnyReplicated((Set<Symbol>)ImmutableSet.copyOf((Collection)filteringSourceSymbols)));
                    if (filteringSource.getProperties().isNodePartitionedOn((Collection<Symbol>)filteringSourceSymbols, true, SystemSessionProperties.isUseExactPartitioning(this.session)) && !filteringSource.getProperties().isSingleNode()) {
                        Partitioning sourcePartitioning = filteringSource.getProperties().translate(this.createTranslator(filteringToSource)).getNodePartitioning().get();
                        source = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, source.getNode(), new PartitioningScheme(sourcePartitioning, source.getNode().getOutputSymbols())), source.getProperties());
                    } else {
                        source = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, source.getNode(), (List<Symbol>)sourceSymbols, Optional.empty()), source.getProperties());
                        filteringSource = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, filteringSource.getNode(), (List<Symbol>)filteringSourceSymbols, Optional.empty(), true), filteringSource.getProperties());
                    }
                }
                Verify.verify((boolean)source.getProperties().withReplicatedNulls(true).isCompatibleTablePartitioningWith(filteringSource.getProperties(), arg_0 -> sourceToFiltering.get(arg_0), AddExchanges.this.plannerContext.getMetadata(), this.session));
                if (!SystemSessionProperties.isColocatedJoinEnabled(this.session) && AddExchanges.hasMultipleSources(source.getNode(), filteringSource.getNode())) {
                    filteringPartitioning = source.getProperties().translate(this.createTranslator(sourceToFiltering)).getNodePartitioning().get();
                    filteringSource = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, filteringSource.getNode(), new PartitioningScheme(filteringPartitioning, filteringSource.getNode().getOutputSymbols(), Optional.empty(), true, Optional.empty(), Optional.empty())), filteringSource.getProperties());
                }
            } else {
                source = node.getSource().accept(this, PreferredProperties.any());
                filteringSource = node.getFilteringSource().accept(this, PreferredProperties.any());
                if (source.getProperties().isSingleNode()) {
                    if (!filteringSource.getProperties().isSingleNode() || !SystemSessionProperties.isColocatedJoinEnabled(this.session) && AddExchanges.hasMultipleSources(source.getNode(), filteringSource.getNode())) {
                        filteringSource = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, filteringSource.getNode()), filteringSource.getProperties());
                    }
                } else {
                    filteringSource = this.withDerivedProperties(ExchangeNode.replicatedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, filteringSource.getNode()), filteringSource.getProperties());
                }
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, (List<PlanWithProperties>)ImmutableList.of((Object)source, (Object)filteringSource));
        }

        @Override
        public PlanWithProperties visitIndexJoin(IndexJoinNode node, PreferredProperties preferredProperties) {
            List joinColumns = (List)node.getCriteria().stream().map(IndexJoinNode.EquiJoinClause::getProbe).collect(ImmutableList.toImmutableList());
            Object desiredLocalProperties = preferredProperties.getLocalProperties().isEmpty() ? LocalProperties.grouped(joinColumns) : ImmutableList.of();
            PlanWithProperties probeSource = node.getProbeSource().accept(this, this.computePreference(PreferredProperties.partitionedWithLocal((Set<Symbol>)ImmutableSet.copyOf((Collection)joinColumns), (List<? extends LocalProperty<Symbol>>)desiredLocalProperties), preferredProperties));
            PlanWithProperties indexSource = node.getIndexSource().accept(this, PreferredProperties.any());
            PlanNode result = ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)probeSource.getNode(), (Object)node.getIndexSource()));
            return new PlanWithProperties(result, this.deriveProperties(result, (List<ActualProperties>)ImmutableList.of((Object)probeSource.getProperties(), (Object)indexSource.getProperties())));
        }

        @Override
        public PlanWithProperties visitIndexSource(IndexSourceNode node, PreferredProperties preferredProperties) {
            return new PlanWithProperties(node, ActualProperties.builder().global(ActualProperties.Global.singlePartition()).build());
        }

        private Function<Symbol, Optional<Symbol>> outputToInputTranslator(UnionNode node, int sourceIndex) {
            return symbol -> Optional.of((Symbol)node.getSymbolMapping().get(symbol).get(sourceIndex));
        }

        private Partitioning selectUnionPartitioning(UnionNode node, PreferredProperties.PartitioningProperties parentPreference) {
            if (parentPreference.getPartitioning().isPresent()) {
                return parentPreference.getPartitioning().get();
            }
            boolean nullsAndAnyReplicated = parentPreference.isNullsAndAnyReplicated();
            for (int sourceIndex = 0; sourceIndex < node.getSources().size(); ++sourceIndex) {
                PreferredProperties.PartitioningProperties childPartitioning = parentPreference.translate(this.outputToInputTranslator(node, sourceIndex)).get();
                PreferredProperties childPreferred = PreferredProperties.builder().global(PreferredProperties.Global.distributed(childPartitioning.withNullsAndAnyReplicated(nullsAndAnyReplicated))).build();
                PlanWithProperties child = node.getSources().get(sourceIndex).accept(this, childPreferred);
                if (!child.getProperties().isNodePartitionedOn(childPartitioning.getPartitioningColumns(), nullsAndAnyReplicated, SystemSessionProperties.isUseExactPartitioning(this.session)) || child.getProperties().isSingleNode()) continue;
                Function<Symbol, Optional<Symbol>> childToParent = this.createTranslator(this.createMapping(node.sourceOutputLayout(sourceIndex), node.getOutputSymbols()));
                return child.getProperties().translate(childToParent).getNodePartitioning().get();
            }
            return Partitioning.create(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, (List<Symbol>)ImmutableList.copyOf(parentPreference.getPartitioningColumns()));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public PlanWithProperties visitUnion(UnionNode node, PreferredProperties parentPreference) {
            PlanNode result;
            Optional<PreferredProperties.Global> parentGlobal = parentPreference.getGlobalProperties();
            if (parentGlobal.isPresent() && parentGlobal.get().isDistributed() && parentGlobal.get().getPartitioningProperties().isPresent()) {
                PreferredProperties.PartitioningProperties parentPartitioningPreference = parentGlobal.get().getPartitioningProperties().get();
                boolean nullsAndAnyReplicated = parentPartitioningPreference.isNullsAndAnyReplicated();
                Partitioning desiredParentPartitioning = this.selectUnionPartitioning(node, parentPartitioningPreference);
                ImmutableList.Builder partitionedSources = ImmutableList.builder();
                ImmutableListMultimap.Builder outputToSourcesMapping = ImmutableListMultimap.builder();
                for (int sourceIndex = 0; sourceIndex < node.getSources().size(); ++sourceIndex) {
                    void var12_23;
                    Partitioning childPartitioning = desiredParentPartitioning.translate(this.createDirectTranslator(this.createMapping(node.getOutputSymbols(), node.sourceOutputLayout(sourceIndex))));
                    PreferredProperties childPreferred = PreferredProperties.builder().global(PreferredProperties.Global.distributed(PreferredProperties.PartitioningProperties.partitioned(childPartitioning).withNullsAndAnyReplicated(nullsAndAnyReplicated))).build();
                    PlanWithProperties planWithProperties = node.getSources().get(sourceIndex).accept(this, childPreferred);
                    if (!planWithProperties.getProperties().isCompatibleTablePartitioningWith(childPartitioning, nullsAndAnyReplicated, AddExchanges.this.plannerContext.getMetadata(), this.session)) {
                        PlanWithProperties planWithProperties2 = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE, planWithProperties.getNode(), new PartitioningScheme(childPartitioning, planWithProperties.getNode().getOutputSymbols(), Optional.empty(), nullsAndAnyReplicated, Optional.empty(), Optional.empty())), planWithProperties.getProperties());
                    }
                    partitionedSources.add((Object)var12_23.getNode());
                    for (int column = 0; column < node.getOutputSymbols().size(); ++column) {
                        outputToSourcesMapping.put((Object)node.getOutputSymbols().get(column), (Object)node.sourceOutputLayout(sourceIndex).get(column));
                    }
                }
                UnionNode newNode = new UnionNode(node.getId(), (List<PlanNode>)partitionedSources.build(), (ListMultimap<Symbol, Symbol>)outputToSourcesMapping.build(), (List<Symbol>)ImmutableList.copyOf((Collection)outputToSourcesMapping.build().keySet()));
                return new PlanWithProperties(newNode, ActualProperties.builder().global(ActualProperties.Global.partitionedOn(desiredParentPartitioning)).build().withReplicatedNulls(parentPartitioningPreference.isNullsAndAnyReplicated()));
            }
            ArrayList<PlanNode> unpartitionedChildren = new ArrayList<PlanNode>();
            ArrayList<List<Symbol>> unpartitionedOutputLayouts = new ArrayList<List<Symbol>>();
            ArrayList<PlanNode> partitionedChildren = new ArrayList<PlanNode>();
            ArrayList<List<Symbol>> partitionedOutputLayouts = new ArrayList<List<Symbol>>();
            for (int i = 0; i < node.getSources().size(); ++i) {
                PlanWithProperties child = node.getSources().get(i).accept(this, PreferredProperties.any());
                if (child.getProperties().isSingleNode()) {
                    unpartitionedChildren.add(child.getNode());
                    unpartitionedOutputLayouts.add(node.sourceOutputLayout(i));
                    continue;
                }
                partitionedChildren.add(child.getNode());
                partitionedOutputLayouts.add(node.sourceOutputLayout(i));
            }
            if (!partitionedChildren.isEmpty() && unpartitionedChildren.isEmpty()) {
                if (parentGlobal.isEmpty() || parentGlobal.get().isDistributed()) {
                    return this.arbitraryDistributeUnion(node, partitionedChildren, partitionedOutputLayouts);
                }
                result = new ExchangeNode(this.idAllocator.getNextId(), ExchangeNode.Type.GATHER, ExchangeNode.Scope.REMOTE, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), node.getOutputSymbols()), partitionedChildren, partitionedOutputLayouts, Optional.empty());
            } else if (!unpartitionedChildren.isEmpty()) {
                if (!partitionedChildren.isEmpty()) {
                    List exchangeOutputLayout = (List)node.getOutputSymbols().stream().map(outputSymbol -> this.symbolAllocator.newSymbol(outputSymbol.getName(), this.types.get((Symbol)outputSymbol))).collect(ImmutableList.toImmutableList());
                    ExchangeNode result2 = new ExchangeNode(this.idAllocator.getNextId(), ExchangeNode.Type.GATHER, ExchangeNode.Scope.REMOTE, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), exchangeOutputLayout), partitionedChildren, partitionedOutputLayouts, Optional.empty());
                    unpartitionedChildren.add(result2);
                    unpartitionedOutputLayouts.add(((PlanNode)result2).getOutputSymbols());
                }
                ImmutableListMultimap.Builder mappings = ImmutableListMultimap.builder();
                for (int i = 0; i < node.getOutputSymbols().size(); ++i) {
                    for (List list : unpartitionedOutputLayouts) {
                        mappings.put((Object)node.getOutputSymbols().get(i), (Object)((Symbol)list.get(i)));
                    }
                }
                result = new UnionNode(node.getId(), unpartitionedChildren, (ListMultimap<Symbol, Symbol>)mappings.build(), (List<Symbol>)ImmutableList.copyOf((Collection)mappings.build().keySet()));
            } else {
                throw new IllegalStateException("both unpartitionedChildren partitionedChildren are empty");
            }
            return new PlanWithProperties(result, ActualProperties.builder().global(ActualProperties.Global.singlePartition()).build());
        }

        private PlanWithProperties arbitraryDistributeUnion(UnionNode unionNode, List<PlanNode> partitionedChildren, List<List<Symbol>> partitionedOutputLayouts) {
            if (AddExchanges.countSources(partitionedChildren) == 0) {
                return new PlanWithProperties(unionNode.replaceChildren(partitionedChildren));
            }
            int repartitionedRemoteExchangeNodesCount = partitionedChildren.stream().mapToInt(AddExchanges::countRepartitionedRemoteExchangeNodes).sum();
            int partitionedConnectorSourceCount = partitionedChildren.stream().mapToInt(AddExchanges::countPartitionedConnectorSource).sum();
            long uniqueSourceCatalogCount = partitionedChildren.stream().flatMap(AddExchanges::collectSourceCatalogs).distinct().count();
            if (repartitionedRemoteExchangeNodesCount == 0 && partitionedConnectorSourceCount == 0 && uniqueSourceCatalogCount == 1L) {
                return new PlanWithProperties(unionNode.replaceChildren(partitionedChildren));
            }
            return new PlanWithProperties(new ExchangeNode(this.idAllocator.getNextId(), ExchangeNode.Type.REPARTITION, ExchangeNode.Scope.REMOTE, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), unionNode.getOutputSymbols()), partitionedChildren, partitionedOutputLayouts, Optional.empty()));
        }

        @Override
        public PlanWithProperties visitApply(ApplyNode node, PreferredProperties preferredProperties) {
            throw new IllegalStateException("Unexpected node: " + node.getClass().getName());
        }

        @Override
        public PlanWithProperties visitCorrelatedJoin(CorrelatedJoinNode node, PreferredProperties preferredProperties) {
            throw new IllegalStateException("Unexpected node: " + node.getClass().getName());
        }

        private PlanWithProperties planChild(PlanNode node, PreferredProperties preferredProperties) {
            return ((PlanNode)Iterables.getOnlyElement(node.getSources())).accept(this, preferredProperties);
        }

        private PlanWithProperties rebaseAndDeriveProperties(PlanNode node, PlanWithProperties child) {
            return this.withDerivedProperties(ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)child.getNode())), child.getProperties());
        }

        @Override
        public PlanWithProperties visitAssignUniqueId(AssignUniqueId node, PreferredProperties preferredProperties) {
            PreferredProperties translatedPreferred = preferredProperties.translate(symbol -> node.getIdColumn().equals(symbol) ? Optional.empty() : Optional.of(symbol));
            return this.rebaseAndDeriveProperties((PlanNode)node, this.planChild(node, translatedPreferred));
        }

        private PlanWithProperties rebaseAndDeriveProperties(PlanNode node, List<PlanWithProperties> children) {
            PlanNode result = node.replaceChildren(children.stream().map(PlanWithProperties::getNode).collect(Collectors.toList()));
            return new PlanWithProperties(result, this.deriveProperties(result, children.stream().map(PlanWithProperties::getProperties).collect(Collectors.toList())));
        }

        private PlanWithProperties withDerivedProperties(PlanNode node, ActualProperties inputProperties) {
            return new PlanWithProperties(node, this.deriveProperties(node, inputProperties));
        }

        private ActualProperties deriveProperties(PlanNode result, ActualProperties inputProperties) {
            return this.deriveProperties(result, (List<ActualProperties>)ImmutableList.of((Object)inputProperties));
        }

        private ActualProperties deriveProperties(PlanNode result, List<ActualProperties> inputProperties) {
            ActualProperties outputProperties = PropertyDerivations.deriveProperties(result, inputProperties, AddExchanges.this.plannerContext, this.session, this.types, AddExchanges.this.typeAnalyzer);
            Verify.verify((result instanceof SemiJoinNode || inputProperties.stream().noneMatch(ActualProperties::isNullsAndAnyReplicated) || outputProperties.isNullsAndAnyReplicated() ? 1 : 0) != 0, (String)"SemiJoinNode is the only node that can strip null replication", (Object[])new Object[0]);
            return outputProperties;
        }

        private ActualProperties derivePropertiesRecursively(PlanNode result) {
            return PropertyDerivations.derivePropertiesRecursively(result, AddExchanges.this.plannerContext, this.session, this.types, AddExchanges.this.typeAnalyzer);
        }

        private PreferredProperties computePreference(PreferredProperties preferredProperties, PreferredProperties parentPreferredProperties) {
            if (!SystemSessionProperties.ignoreDownStreamPreferences(this.session)) {
                return preferredProperties.mergeWithParent(parentPreferredProperties);
            }
            return preferredProperties;
        }

        private boolean isNodePartitionedOn(ActualProperties properties, Collection<Symbol> columns) {
            return properties.isNodePartitionedOn(columns, SystemSessionProperties.isUseExactPartitioning(this.session));
        }
    }

    @VisibleForTesting
    static class PlanWithProperties {
        private final PlanNode node;
        private final ActualProperties properties;

        public PlanWithProperties(PlanNode node) {
            this(node, ActualProperties.builder().build());
        }

        public PlanWithProperties(PlanNode node, ActualProperties properties) {
            this.node = node;
            this.properties = properties;
        }

        public PlanNode getNode() {
            return this.node;
        }

        public ActualProperties getProperties() {
            return this.properties;
        }
    }
}

