/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import io.trino.Session;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.Metadata;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.sql.planner.IrTypeAnalyzer;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.ConstantExpression;
import io.trino.sql.relational.InputReferenceExpression;
import io.trino.sql.relational.LambdaDefinitionExpression;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.RowExpressionVisitor;
import io.trino.sql.relational.SpecialForm;
import io.trino.sql.relational.SqlToRowExpressionTranslator;
import io.trino.sql.relational.VariableReferenceExpression;
import io.trino.sql.tree.Expression;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ExpressionEquivalence {
    private static final Ordering<RowExpression> ROW_EXPRESSION_ORDERING = Ordering.from((Comparator)new RowExpressionComparator());
    private final Metadata metadata;
    private final FunctionManager functionManager;
    private final TypeManager typeManager;
    private final IrTypeAnalyzer typeAnalyzer;
    private final CanonicalizationVisitor canonicalizationVisitor;

    public ExpressionEquivalence(Metadata metadata, FunctionManager functionManager, TypeManager typeManager, IrTypeAnalyzer typeAnalyzer) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        this.canonicalizationVisitor = new CanonicalizationVisitor();
    }

    public boolean areExpressionsEquivalent(Session session, Expression leftExpression, Expression rightExpression, TypeProvider types) {
        HashMap<Symbol, Integer> symbolInput = new HashMap<Symbol, Integer>();
        int inputId = 0;
        for (Map.Entry<Symbol, Type> entry : types.allTypes().entrySet()) {
            symbolInput.put(entry.getKey(), inputId);
            ++inputId;
        }
        RowExpression leftRowExpression = this.toRowExpression(session, leftExpression, symbolInput, types);
        RowExpression rightRowExpression = this.toRowExpression(session, rightExpression, symbolInput, types);
        RowExpression canonicalizedLeft = leftRowExpression.accept(this.canonicalizationVisitor, null);
        RowExpression canonicalizedRight = rightRowExpression.accept(this.canonicalizationVisitor, null);
        return canonicalizedLeft.equals(canonicalizedRight);
    }

    private RowExpression toRowExpression(Session session, Expression expression, Map<Symbol, Integer> symbolInput, TypeProvider types) {
        return SqlToRowExpressionTranslator.translate(expression, this.typeAnalyzer.getTypes(session, types, expression), symbolInput, this.metadata, this.functionManager, this.typeManager, session, false);
    }

    private static <T> List<T> swapPair(List<T> pair) {
        Objects.requireNonNull(pair, "pair is null");
        Preconditions.checkArgument((pair.size() == 2 ? 1 : 0) != 0, (Object)"Expected pair to have two elements");
        return ImmutableList.of(pair.get(1), pair.get(0));
    }

    private static class CanonicalizationVisitor
    implements RowExpressionVisitor<RowExpression, Void> {
        private CanonicalizationVisitor() {
        }

        @Override
        public RowExpression visitCall(CallExpression call, Void context) {
            CatalogSchemaFunctionName callName = (call = new CallExpression(call.getResolvedFunction(), (List)call.getArguments().stream().map(expression -> expression.accept(this, context)).collect(ImmutableList.toImmutableList()))).getResolvedFunction().getSignature().getName();
            if (callName.equals((Object)GlobalFunctionCatalog.builtinFunctionName(OperatorType.EQUAL)) || callName.equals((Object)GlobalFunctionCatalog.builtinFunctionName(OperatorType.IS_DISTINCT_FROM))) {
                return new CallExpression(call.getResolvedFunction(), ROW_EXPRESSION_ORDERING.sortedCopy(call.getArguments()));
            }
            return call;
        }

        @Override
        public RowExpression visitSpecialForm(SpecialForm specialForm, Void context) {
            if ((specialForm = new SpecialForm(specialForm.getForm(), specialForm.getType(), (List)specialForm.getArguments().stream().map(expression -> expression.accept(this, context)).collect(ImmutableList.toImmutableList()), specialForm.getFunctionDependencies())).getForm() == SpecialForm.Form.AND || specialForm.getForm() == SpecialForm.Form.OR) {
                List<RowExpression> flattenedArguments = CanonicalizationVisitor.flattenNestedCallArgs(specialForm);
                ImmutableSet distinctArguments = ImmutableSet.copyOf(flattenedArguments);
                if (distinctArguments.size() == 1) {
                    return (RowExpression)Iterables.getOnlyElement((Iterable)distinctArguments);
                }
                List sortedArguments = ROW_EXPRESSION_ORDERING.sortedCopy((Iterable)distinctArguments);
                return new SpecialForm(specialForm.getForm(), (Type)BooleanType.BOOLEAN, sortedArguments, specialForm.getFunctionDependencies());
            }
            return specialForm;
        }

        public static List<RowExpression> flattenNestedCallArgs(SpecialForm specialForm) {
            SpecialForm.Form form = specialForm.getForm();
            ImmutableList.Builder newArguments = ImmutableList.builder();
            for (RowExpression argument : specialForm.getArguments()) {
                if (argument instanceof SpecialForm && form == ((SpecialForm)argument).getForm()) {
                    newArguments.addAll(CanonicalizationVisitor.flattenNestedCallArgs((SpecialForm)argument));
                    continue;
                }
                newArguments.add((Object)argument);
            }
            return newArguments.build();
        }

        @Override
        public RowExpression visitConstant(ConstantExpression constant, Void context) {
            return constant;
        }

        @Override
        public RowExpression visitInputReference(InputReferenceExpression node, Void context) {
            return node;
        }

        @Override
        public RowExpression visitLambda(LambdaDefinitionExpression lambda, Void context) {
            return new LambdaDefinitionExpression(lambda.getArgumentTypes(), lambda.getArguments(), lambda.getBody().accept(this, context));
        }

        @Override
        public RowExpression visitVariableReference(VariableReferenceExpression reference, Void context) {
            return reference;
        }
    }

    private static class RowExpressionComparator
    implements Comparator<RowExpression> {
        private final Comparator<Object> classComparator = Ordering.arbitrary();
        private final ListComparator<RowExpression> argumentComparator = new ListComparator<RowExpression>(this);

        private RowExpressionComparator() {
        }

        @Override
        public int compare(RowExpression left, RowExpression right) {
            int result = this.classComparator.compare(left.getClass(), right.getClass());
            if (result != 0) {
                return result;
            }
            if (left instanceof CallExpression) {
                CallExpression leftCall = (CallExpression)left;
                CallExpression rightCall = (CallExpression)right;
                return ComparisonChain.start().compare((Comparable)((Object)leftCall.getResolvedFunction().toString()), (Comparable)((Object)rightCall.getResolvedFunction().toString())).compare(leftCall.getArguments(), rightCall.getArguments(), this.argumentComparator).result();
            }
            if (left instanceof SpecialForm) {
                SpecialForm leftForm = (SpecialForm)left;
                SpecialForm rightForm = (SpecialForm)right;
                return ComparisonChain.start().compare((Comparable)((Object)leftForm.getForm()), (Comparable)((Object)rightForm.getForm())).compare(leftForm.getArguments(), rightForm.getArguments(), this.argumentComparator).result();
            }
            if (left instanceof ConstantExpression) {
                ConstantExpression leftConstant = (ConstantExpression)left;
                ConstantExpression rightConstant = (ConstantExpression)right;
                result = leftConstant.getType().getTypeSignature().toString().compareTo(right.getType().getTypeSignature().toString());
                if (result != 0) {
                    return result;
                }
                Object leftValue = leftConstant.getValue();
                Object rightValue = rightConstant.getValue();
                if (leftValue == null) {
                    if (rightValue == null) {
                        return 0;
                    }
                    return -1;
                }
                if (rightValue == null) {
                    return 1;
                }
                Class javaType = leftConstant.getType().getJavaType();
                if (javaType == Boolean.TYPE) {
                    return ((Boolean)leftValue).compareTo((Boolean)rightValue);
                }
                if (javaType == Byte.TYPE || javaType == Short.TYPE || javaType == Integer.TYPE || javaType == Long.TYPE) {
                    return Long.compare(((Number)leftValue).longValue(), ((Number)rightValue).longValue());
                }
                if (javaType == Float.TYPE || javaType == Double.TYPE) {
                    return Double.compare(((Number)leftValue).doubleValue(), ((Number)rightValue).doubleValue());
                }
                if (leftValue instanceof Comparable) {
                    try {
                        return ((Comparable)leftValue).compareTo(rightValue);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                return -1;
            }
            if (left instanceof InputReferenceExpression) {
                InputReferenceExpression leftInputReferenceExpression = (InputReferenceExpression)left;
                return Integer.compare(leftInputReferenceExpression.getField(), ((InputReferenceExpression)right).getField());
            }
            if (left instanceof LambdaDefinitionExpression) {
                LambdaDefinitionExpression leftLambda = (LambdaDefinitionExpression)left;
                LambdaDefinitionExpression rightLambda = (LambdaDefinitionExpression)right;
                return ComparisonChain.start().compare(leftLambda.getArgumentTypes(), rightLambda.getArgumentTypes(), new ListComparator<Type>(Comparator.comparing(Object::toString))).compare(leftLambda.getArguments(), rightLambda.getArguments(), new ListComparator(Comparator.naturalOrder())).compare((Object)leftLambda.getBody(), (Object)rightLambda.getBody(), (Comparator)this).result();
            }
            if (left instanceof VariableReferenceExpression) {
                VariableReferenceExpression leftVariableReference = (VariableReferenceExpression)left;
                VariableReferenceExpression rightVariableReference = (VariableReferenceExpression)right;
                return ComparisonChain.start().compare((Comparable)((Object)leftVariableReference.getName()), (Comparable)((Object)rightVariableReference.getName())).compare((Object)leftVariableReference.getType(), (Object)rightVariableReference.getType(), Comparator.comparing(Object::toString)).result();
            }
            throw new IllegalArgumentException("Unsupported RowExpression type " + left.getClass().getSimpleName());
        }
    }

    private static class ListComparator<T>
    implements Comparator<List<T>> {
        private final Comparator<T> elementComparator;

        public ListComparator(Comparator<T> elementComparator) {
            this.elementComparator = Objects.requireNonNull(elementComparator, "elementComparator is null");
        }

        @Override
        public int compare(List<T> left, List<T> right) {
            int compareLength = Integer.min(left.size(), right.size());
            for (int i = 0; i < compareLength; ++i) {
                int result = this.elementComparator.compare(left.get(i), right.get(i));
                if (result == 0) continue;
                return result;
            }
            return Integer.compare(left.size(), right.size());
        }
    }
}

