/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.planprinter;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.FormatMethod;
import io.trino.cost.LocalCostEstimate;
import io.trino.cost.PlanCostEstimate;
import io.trino.cost.PlanNodeStatsAndCostSummary;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.planprinter.PlanNodeStats;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NodeRepresentation {
    private final PlanNodeId id;
    private final String name;
    private final String type;
    private final Map<String, String> descriptor;
    private final List<TypedSymbol> outputs;
    private final List<PlanNodeId> children;
    private final List<PlanFragmentId> remoteSources;
    private final Optional<PlanNodeStats> stats;
    private final List<PlanNodeStatsEstimate> estimatedStats;
    private final List<PlanCostEstimate> estimatedCost;
    private final Optional<PlanNodeStatsAndCostSummary> reorderJoinStatsAndCost;
    private final ImmutableList.Builder<String> details = ImmutableList.builder();

    public NodeRepresentation(PlanNodeId id, String name, String type, Map<String, String> descriptor, List<TypedSymbol> outputs, Optional<PlanNodeStats> stats, List<PlanNodeStatsEstimate> estimatedStats, List<PlanCostEstimate> estimatedCost, Optional<PlanNodeStatsAndCostSummary> reorderJoinStatsAndCost, List<PlanNodeId> children, List<PlanFragmentId> remoteSources) {
        this.id = Objects.requireNonNull(id, "id is null");
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.descriptor = Objects.requireNonNull(descriptor, "descriptor is null");
        this.outputs = Objects.requireNonNull(outputs, "outputs is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.estimatedStats = Objects.requireNonNull(estimatedStats, "estimatedStats is null");
        this.estimatedCost = Objects.requireNonNull(estimatedCost, "estimatedCost is null");
        this.reorderJoinStatsAndCost = Objects.requireNonNull(reorderJoinStatsAndCost, "reorderJoinStatsAndCost is null");
        this.children = Objects.requireNonNull(children, "children is null");
        this.remoteSources = Objects.requireNonNull(remoteSources, "remoteSources is null");
        Preconditions.checkArgument((estimatedCost.size() == estimatedStats.size() ? 1 : 0) != 0, (Object)"size of cost and stats list does not match");
    }

    @FormatMethod
    public void appendDetails(String string, Object ... args) {
        if (args.length == 0) {
            this.details.add((Object)string);
        } else {
            this.details.add((Object)String.format(string, args));
        }
    }

    public PlanNodeId getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, String> getDescriptor() {
        return this.descriptor;
    }

    public List<TypedSymbol> getOutputs() {
        return this.outputs;
    }

    public List<PlanNodeId> getChildren() {
        return this.children;
    }

    public List<PlanFragmentId> getRemoteSources() {
        return this.remoteSources;
    }

    public List<String> getDetails() {
        return this.details.build();
    }

    public Optional<PlanNodeStats> getStats() {
        return this.stats;
    }

    public List<PlanNodeStatsEstimate> getEstimatedStats() {
        return this.estimatedStats;
    }

    public List<PlanCostEstimate> getEstimatedCost() {
        return this.estimatedCost;
    }

    public Optional<PlanNodeStatsAndCostSummary> getReorderJoinStatsAndCost() {
        return this.reorderJoinStatsAndCost;
    }

    public List<PlanNodeStatsAndCostSummary> getEstimates() {
        if (this.getEstimatedStats().stream().allMatch(PlanNodeStatsEstimate::isOutputRowCountUnknown) && this.getEstimatedCost().stream().allMatch(c -> c.getRootNodeLocalCostEstimate().equals(LocalCostEstimate.unknown()))) {
            return ImmutableList.of();
        }
        ImmutableList.Builder estimates = ImmutableList.builder();
        TypeProvider typeProvider = TypeProvider.copyOf((Map)this.outputs.stream().distinct().collect(ImmutableMap.toImmutableMap(TypedSymbol::getSymbol, TypedSymbol::getTrinoType)));
        for (int i = 0; i < this.getEstimatedStats().size(); ++i) {
            PlanNodeStatsEstimate stats = this.getEstimatedStats().get(i);
            LocalCostEstimate cost = this.getEstimatedCost().get(i).getRootNodeLocalCostEstimate();
            List outputSymbols = (List)this.getOutputs().stream().map(TypedSymbol::getSymbol).collect(ImmutableList.toImmutableList());
            estimates.add((Object)new PlanNodeStatsAndCostSummary(stats.getOutputRowCount(), stats.getOutputSizeInBytes(outputSymbols, typeProvider), cost.getCpuCost(), cost.getMaxMemory(), cost.getNetworkCost()));
        }
        return estimates.build();
    }

    public static class TypedSymbol {
        private final Symbol symbol;
        private final Type trinoType;

        public TypedSymbol(Symbol symbol, Type trinoType) {
            this.symbol = symbol;
            this.trinoType = trinoType;
        }

        @JsonProperty
        public Symbol getSymbol() {
            return this.symbol;
        }

        @JsonProperty
        public String getType() {
            return this.trinoType.getDisplayName();
        }

        @JsonIgnore
        public Type getTrinoType() {
            return this.trinoType;
        }

        public static TypedSymbol typedSymbol(String symbol, Type type) {
            return new TypedSymbol(new Symbol(symbol), type);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TypedSymbol)) {
                return false;
            }
            TypedSymbol that = (TypedSymbol)o;
            return this.symbol.equals(that.symbol) && this.trinoType.equals((Object)that.trinoType);
        }

        public int hashCode() {
            return Objects.hash(this.symbol, this.trinoType);
        }
    }
}

