/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.sanity;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.execution.warnings.WarningCollector;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.ExpressionExtractor;
import io.trino.sql.planner.IrTypeAnalyzer;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.sanity.PlanSanityChecker;
import io.trino.sql.tree.Array;
import io.trino.sql.tree.AtTimeZone;
import io.trino.sql.tree.CurrentCatalog;
import io.trino.sql.tree.CurrentPath;
import io.trino.sql.tree.CurrentSchema;
import io.trino.sql.tree.CurrentTime;
import io.trino.sql.tree.CurrentUser;
import io.trino.sql.tree.DefaultExpressionTraversalVisitor;
import io.trino.sql.tree.DereferenceExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Extract;
import io.trino.sql.tree.Format;
import io.trino.sql.tree.LikePredicate;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.TryExpression;

public final class SugarFreeChecker
implements PlanSanityChecker.Checker {
    private static final Visitor VISITOR = new Visitor();

    @Override
    public void validate(PlanNode planNode, Session session, PlannerContext plannerContext, IrTypeAnalyzer typeAnalyzer, TypeProvider types, WarningCollector warningCollector) {
        ExpressionExtractor.forEachExpression(planNode, SugarFreeChecker::validate);
    }

    public static void validate(Expression expression) {
        VISITOR.process((Node)expression, null);
    }

    private static class Visitor
    extends DefaultExpressionTraversalVisitor<ImmutableList.Builder<Symbol>> {
        private Visitor() {
        }

        protected Void visitExtract(Extract node, ImmutableList.Builder<Symbol> context) {
            throw Visitor.createIllegalNodeException((Node)node);
        }

        protected Void visitTryExpression(TryExpression node, ImmutableList.Builder<Symbol> context) {
            throw Visitor.createIllegalNodeException((Node)node);
        }

        protected Void visitAtTimeZone(AtTimeZone node, ImmutableList.Builder<Symbol> context) {
            throw Visitor.createIllegalNodeException((Node)node);
        }

        protected Void visitCurrentPath(CurrentPath node, ImmutableList.Builder<Symbol> context) {
            throw Visitor.createIllegalNodeException((Node)node);
        }

        protected Void visitCurrentCatalog(CurrentCatalog node, ImmutableList.Builder<Symbol> context) {
            throw Visitor.createIllegalNodeException((Node)node);
        }

        protected Void visitCurrentSchema(CurrentSchema node, ImmutableList.Builder<Symbol> context) {
            throw Visitor.createIllegalNodeException((Node)node);
        }

        protected Void visitCurrentUser(CurrentUser node, ImmutableList.Builder<Symbol> context) {
            throw Visitor.createIllegalNodeException((Node)node);
        }

        protected Void visitLikePredicate(LikePredicate node, ImmutableList.Builder<Symbol> context) {
            throw Visitor.createIllegalNodeException((Node)node);
        }

        protected Void visitFormat(Format node, ImmutableList.Builder<Symbol> context) {
            throw Visitor.createIllegalNodeException((Node)node);
        }

        protected Void visitArray(Array node, ImmutableList.Builder<Symbol> context) {
            throw Visitor.createIllegalNodeException((Node)node);
        }

        protected Void visitCurrentTime(CurrentTime node, ImmutableList.Builder<Symbol> context) {
            throw Visitor.createIllegalNodeException((Node)node);
        }

        protected Void visitDereferenceExpression(DereferenceExpression node, ImmutableList.Builder<Symbol> context) {
            throw new IllegalArgumentException("DereferenceExpression should've been replaced with SubscriptExpression");
        }

        private static IllegalArgumentException createIllegalNodeException(Node node) {
            return new IllegalArgumentException(node.getClass().getSimpleName() + " should have been replaced with a function call");
        }
    }
}

