/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.AbstractVariableWidthType;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.type.LikePattern;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

public class LikePatternType
extends AbstractVariableWidthType {
    public static final LikePatternType LIKE_PATTERN = new LikePatternType();
    public static final String NAME = "LikePattern";

    private LikePatternType() {
        super(new TypeSignature(NAME, new TypeSignatureParameter[0]), LikePattern.class);
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        throw new UnsupportedOperationException();
    }

    public Object getObject(Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        VariableWidthBlock valueBlock = (VariableWidthBlock)block.getUnderlyingValueBlock();
        int valuePosition = block.getUnderlyingValuePosition(position);
        Slice slice = valueBlock.getSlice(valuePosition);
        int length = slice.getInt(0);
        String pattern = slice.toString(4, length, StandardCharsets.UTF_8);
        boolean hasEscape = slice.getByte(4 + length) != 0;
        Optional<Character> escape = Optional.empty();
        if (hasEscape) {
            escape = Optional.of(Character.valueOf((char)slice.getInt(4 + length + 1)));
        }
        return LikePattern.compile(pattern, escape);
    }

    public void writeObject(BlockBuilder blockBuilder, Object value) {
        LikePattern likePattern = (LikePattern)value;
        Slice pattern = Slices.utf8Slice((String)likePattern.getPattern());
        Slice slice = Slices.allocate((int)(4 + pattern.length() + 1 + (likePattern.getEscape().isPresent() ? 4 : 0)));
        slice.setInt(0, pattern.length());
        slice.setBytes(4, pattern);
        if (likePattern.getEscape().isEmpty()) {
            slice.setByte(4 + pattern.length(), 0);
        } else {
            slice.setByte(4 + pattern.length(), 1);
            slice.setInt(4 + pattern.length() + 1, (int)likePattern.getEscape().get().charValue());
        }
        ((VariableWidthBlockBuilder)blockBuilder).writeEntry(slice);
    }
}

