/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.hnsw;

import java.io.IOException;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.util.hnsw.RandomAccessVectorValues;
import org.apache.lucene.util.hnsw.RandomVectorScorer;

public interface RandomVectorScorerSupplier {
    public RandomVectorScorer scorer(int var1) throws IOException;

    public RandomVectorScorerSupplier copy() throws IOException;

    public static RandomVectorScorerSupplier createFloats(RandomAccessVectorValues<float[]> vectors, VectorSimilarityFunction similarityFunction) throws IOException {
        return new FloatScoringSupplier(vectors, similarityFunction);
    }

    public static RandomVectorScorerSupplier createBytes(RandomAccessVectorValues<byte[]> vectors, VectorSimilarityFunction similarityFunction) throws IOException {
        return new ByteScoringSupplier(vectors, similarityFunction);
    }

    public static final class FloatScoringSupplier
    implements RandomVectorScorerSupplier {
        private final RandomAccessVectorValues<float[]> vectors;
        private final RandomAccessVectorValues<float[]> vectors1;
        private final RandomAccessVectorValues<float[]> vectors2;
        private final VectorSimilarityFunction similarityFunction;

        private FloatScoringSupplier(RandomAccessVectorValues<float[]> vectors, VectorSimilarityFunction similarityFunction) throws IOException {
            this.vectors = vectors;
            this.vectors1 = vectors.copy();
            this.vectors2 = vectors.copy();
            this.similarityFunction = similarityFunction;
        }

        @Override
        public RandomVectorScorer scorer(final int ord) throws IOException {
            return new RandomVectorScorer.AbstractRandomVectorScorer<float[]>(this.vectors){

                @Override
                public float score(int cand) throws IOException {
                    return similarityFunction.compare(vectors1.vectorValue(ord), vectors2.vectorValue(cand));
                }
            };
        }

        @Override
        public RandomVectorScorerSupplier copy() throws IOException {
            return new FloatScoringSupplier(this.vectors, this.similarityFunction);
        }
    }

    public static final class ByteScoringSupplier
    implements RandomVectorScorerSupplier {
        private final RandomAccessVectorValues<byte[]> vectors;
        private final RandomAccessVectorValues<byte[]> vectors1;
        private final RandomAccessVectorValues<byte[]> vectors2;
        private final VectorSimilarityFunction similarityFunction;

        private ByteScoringSupplier(RandomAccessVectorValues<byte[]> vectors, VectorSimilarityFunction similarityFunction) throws IOException {
            this.vectors = vectors;
            this.vectors1 = vectors.copy();
            this.vectors2 = vectors.copy();
            this.similarityFunction = similarityFunction;
        }

        @Override
        public RandomVectorScorer scorer(final int ord) throws IOException {
            return new RandomVectorScorer.AbstractRandomVectorScorer<byte[]>(this.vectors){

                @Override
                public float score(int cand) throws IOException {
                    return similarityFunction.compare(vectors1.vectorValue(ord), vectors2.vectorValue(cand));
                }
            };
        }

        @Override
        public RandomVectorScorerSupplier copy() throws IOException {
            return new ByteScoringSupplier(this.vectors, this.similarityFunction);
        }
    }
}

