/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.server;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import io.airlift.discovery.server.DiscoveryConfig;
import io.airlift.discovery.server.DynamicAnnouncement;
import io.airlift.discovery.server.DynamicServiceAnnouncement;
import io.airlift.discovery.server.DynamicStore;
import io.airlift.discovery.server.ForDynamicStore;
import io.airlift.discovery.server.Id;
import io.airlift.discovery.server.Node;
import io.airlift.discovery.server.Service;
import io.airlift.discovery.store.DistributedStore;
import io.airlift.discovery.store.Entry;
import io.airlift.json.JsonCodec;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ReplicatedDynamicStore
implements DynamicStore {
    private final DistributedStore store;
    private final Duration maxAge;
    private final JsonCodec<List<Service>> codec;
    private final Supplier<Set<Service>> servicesSupplier;

    @Inject
    public ReplicatedDynamicStore(@ForDynamicStore DistributedStore store, DiscoveryConfig config, JsonCodec<List<Service>> codec) {
        this.store = (DistributedStore)Preconditions.checkNotNull((Object)store, (Object)"store is null");
        this.maxAge = ((DiscoveryConfig)Preconditions.checkNotNull((Object)config, (Object)"config is null")).getMaxAge();
        this.codec = (JsonCodec)Preconditions.checkNotNull(codec, (Object)"codec is null");
        this.servicesSupplier = ReplicatedDynamicStore.cachingSupplier(this.servicesSupplier(), config.getStoreCacheTtl());
    }

    @Override
    public void put(Id<Node> nodeId, DynamicAnnouncement announcement) {
        ImmutableList services = FluentIterable.from(announcement.getServiceAnnouncements()).transform(DynamicServiceAnnouncement.toServiceWith(nodeId, announcement.getLocation(), announcement.getPool())).toList();
        byte[] key = nodeId.getBytes();
        byte[] value = this.codec.toJsonBytes((Object)services);
        this.store.put(key, value, this.maxAge);
    }

    @Override
    public void delete(Id<Node> nodeId) {
        this.store.delete(nodeId.getBytes());
    }

    @Override
    public Set<Service> getAll() {
        return (Set)this.servicesSupplier.get();
    }

    @Override
    public Set<Service> get(String type) {
        return ImmutableSet.copyOf((Iterable)Iterables.filter(this.getAll(), Service.matchesType(type)));
    }

    @Override
    public Set<Service> get(String type, String pool) {
        return ImmutableSet.copyOf((Iterable)Iterables.filter(this.getAll(), (Predicate)Predicates.and(Service.matchesType(type), Service.matchesPool(pool))));
    }

    private Supplier<Set<Service>> servicesSupplier() {
        return new Supplier<Set<Service>>(){

            public Set<Service> get() {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                for (Entry entry : ReplicatedDynamicStore.this.store.getAll()) {
                    builder.addAll((Iterable)ReplicatedDynamicStore.this.codec.fromJson(entry.getValue()));
                }
                return builder.build();
            }
        };
    }

    private static <T> Supplier<T> cachingSupplier(Supplier<T> supplier, Duration ttl) {
        if (ttl.toMillis() == 0L) {
            return supplier;
        }
        return Suppliers.memoizeWithExpiration(supplier, (long)ttl.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
    }
}

