/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift;

import io.airlift.bootstrap.LifeCycleManager;
import io.trino.plugin.thrift.ThriftIndexProvider;
import io.trino.plugin.thrift.ThriftMetadata;
import io.trino.plugin.thrift.ThriftPageSourceProvider;
import io.trino.plugin.thrift.ThriftSessionProperties;
import io.trino.plugin.thrift.ThriftSplitManager;
import io.trino.plugin.thrift.ThriftTransactionHandle;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorIndexProvider;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.transaction.IsolationLevel;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class ThriftConnector
implements Connector {
    private final LifeCycleManager lifeCycleManager;
    private final ThriftMetadata metadata;
    private final ThriftSplitManager splitManager;
    private final ThriftPageSourceProvider pageSourceProvider;
    private final ThriftSessionProperties sessionProperties;
    private final ThriftIndexProvider indexProvider;

    @Inject
    public ThriftConnector(LifeCycleManager lifeCycleManager, ThriftMetadata metadata, ThriftSplitManager splitManager, ThriftPageSourceProvider pageSourceProvider, ThriftSessionProperties sessionProperties, ThriftIndexProvider indexProvider) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.sessionProperties = Objects.requireNonNull(sessionProperties, "sessionProperties is null");
        this.indexProvider = Objects.requireNonNull(indexProvider, "indexProvider is null");
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
        return ThriftTransactionHandle.INSTANCE;
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties.getSessionProperties();
    }

    public ConnectorIndexProvider getIndexProvider() {
        return this.indexProvider;
    }

    public final void shutdown() {
        this.lifeCycleManager.stop();
    }
}

