/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.drift.transport.netty.client.DriftNettyClientModule;
import io.trino.plugin.base.jmx.ConnectorObjectNameGeneratorModule;
import io.trino.plugin.base.jmx.MBeanServerModule;
import io.trino.plugin.thrift.ThriftConnector;
import io.trino.plugin.thrift.ThriftHandleResolver;
import io.trino.plugin.thrift.ThriftModule;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorHandleResolver;
import io.trino.spi.type.TypeManager;
import java.util.Map;
import java.util.Objects;
import org.weakref.jmx.guice.MBeanModule;

public class ThriftConnectorFactory
implements ConnectorFactory {
    private final String name;
    private final Module locationModule;

    public ThriftConnectorFactory(String name, Module locationModule) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.locationModule = Objects.requireNonNull(locationModule, "locationModule is null");
    }

    public String getName() {
        return this.name;
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new ThriftHandleResolver();
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Bootstrap app = new Bootstrap(new Module[]{new MBeanModule(), new MBeanServerModule(), new ConnectorObjectNameGeneratorModule(catalogName, "io.trino.plugin.thrift", "trino.plugin.thrift"), new DriftNettyClientModule(), binder -> binder.bind(TypeManager.class).toInstance((Object)context.getTypeManager()), this.locationModule, new ThriftModule()});
        Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
        return (Connector)injector.getInstance(ThriftConnector.class);
    }
}

