/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.airlift.drift.client.DriftClient;
import io.trino.plugin.thrift.ThriftColumnHandle;
import io.trino.plugin.thrift.ThriftConnectorSplit;
import io.trino.plugin.thrift.ThriftConnectorStats;
import io.trino.plugin.thrift.api.TrinoThriftId;
import io.trino.plugin.thrift.api.TrinoThriftNullableToken;
import io.trino.plugin.thrift.api.TrinoThriftPageResult;
import io.trino.plugin.thrift.api.TrinoThriftService;
import io.trino.plugin.thrift.util.ThriftExceptions;
import io.trino.spi.HostAddress;
import io.trino.spi.Page;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class ThriftPageSource
implements ConnectorPageSource {
    private final TrinoThriftId splitId;
    private final TrinoThriftService client;
    private final List<String> columnNames;
    private final List<Type> columnTypes;
    private final long maxBytesPerResponse;
    private final AtomicLong readTimeNanos = new AtomicLong(0L);
    private TrinoThriftId nextToken;
    private boolean firstCall = true;
    private CompletableFuture<TrinoThriftPageResult> future;
    private final ThriftConnectorStats stats;
    private long completedBytes;

    public ThriftPageSource(DriftClient<TrinoThriftService> client, Map<String, String> thriftHeader, ThriftConnectorSplit split, List<ColumnHandle> columns, ThriftConnectorStats stats, long maxBytesPerResponse) {
        Objects.requireNonNull(columns, "columns is null");
        ImmutableList.Builder columnNames = new ImmutableList.Builder();
        ImmutableList.Builder columnTypes = new ImmutableList.Builder();
        for (ColumnHandle columnHandle : columns) {
            ThriftColumnHandle thriftColumnHandle = (ThriftColumnHandle)columnHandle;
            columnNames.add((Object)thriftColumnHandle.getColumnName());
            columnTypes.add((Object)thriftColumnHandle.getColumnType());
        }
        this.columnNames = columnNames.build();
        this.columnTypes = columnTypes.build();
        this.stats = Objects.requireNonNull(stats, "stats is null");
        Preconditions.checkArgument((maxBytesPerResponse > 0L ? 1 : 0) != 0, (Object)"maxBytesPerResponse is zero or negative");
        this.maxBytesPerResponse = maxBytesPerResponse;
        Objects.requireNonNull(split, "split is null");
        this.splitId = split.getSplitId();
        Objects.requireNonNull(client, "client is null");
        if (split.getAddresses().isEmpty()) {
            this.client = (TrinoThriftService)client.get(thriftHeader);
        } else {
            String hosts = split.getAddresses().stream().map(HostAddress::toString).collect(Collectors.joining(","));
            this.client = (TrinoThriftService)client.get(Optional.of(hosts), thriftHeader);
        }
    }

    public long getCompletedBytes() {
        return this.completedBytes;
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos.get();
    }

    public long getSystemMemoryUsage() {
        return 0L;
    }

    public boolean isFinished() {
        return !this.firstCall && !ThriftPageSource.canGetMoreData(this.nextToken);
    }

    public Page getNextPage() {
        if (this.future == null) {
            if (this.firstCall || ThriftPageSource.canGetMoreData(this.nextToken)) {
                this.future = this.sendDataRequestInternal();
            }
            return null;
        }
        if (!this.future.isDone()) {
            return null;
        }
        Page result = this.processBatch((TrinoThriftPageResult)MoreFutures.getFutureValue(this.future));
        this.future = ThriftPageSource.canGetMoreData(this.nextToken) ? this.sendDataRequestInternal() : null;
        return result;
    }

    private static boolean canGetMoreData(TrinoThriftId nextToken) {
        return nextToken != null;
    }

    private CompletableFuture<TrinoThriftPageResult> sendDataRequestInternal() {
        long start = System.nanoTime();
        ListenableFuture rowsBatchFuture = this.client.getRows(this.splitId, this.columnNames, this.maxBytesPerResponse, new TrinoThriftNullableToken(this.nextToken));
        rowsBatchFuture = ThriftExceptions.catchingThriftException(rowsBatchFuture);
        rowsBatchFuture.addListener(() -> this.readTimeNanos.addAndGet(System.nanoTime() - start), MoreExecutors.directExecutor());
        return MoreFutures.toCompletableFuture((ListenableFuture)Futures.nonCancellationPropagating(rowsBatchFuture));
    }

    private Page processBatch(TrinoThriftPageResult rowsBatch) {
        this.firstCall = false;
        this.nextToken = rowsBatch.getNextToken();
        Page page = rowsBatch.toPage(this.columnTypes);
        if (page != null) {
            long pageSize = page.getSizeInBytes();
            this.completedBytes += pageSize;
            this.stats.addScanPageSize(pageSize);
        } else {
            this.stats.addScanPageSize(0L);
        }
        return page;
    }

    public CompletableFuture<?> isBlocked() {
        return this.future == null ? NOT_BLOCKED : this.future;
    }

    public void close() {
        if (this.future != null) {
            this.future.cancel(true);
        }
    }
}

