/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.plugin.thrift.api.TrinoThriftId;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ThriftConnectorSplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(ThriftConnectorSplit.class);
    private final TrinoThriftId splitId;
    private final List<HostAddress> addresses;

    @JsonCreator
    public ThriftConnectorSplit(@JsonProperty(value="splitId") TrinoThriftId splitId, @JsonProperty(value="addresses") List<HostAddress> addresses) {
        this.splitId = Objects.requireNonNull(splitId, "splitId is null");
        this.addresses = ImmutableList.copyOf((Collection)Objects.requireNonNull(addresses, "addresses is null"));
    }

    @JsonProperty
    public TrinoThriftId getSplitId() {
        return this.splitId;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    public Object getInfo() {
        return "";
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.splitId.getRetainedSizeInBytes() + SizeOf.estimatedSizeOf(this.addresses, HostAddress::getRetainedSizeInBytes);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ThriftConnectorSplit other = (ThriftConnectorSplit)obj;
        return Objects.equals(this.splitId, other.splitId) && Objects.equals(this.addresses, other.addresses);
    }

    public int hashCode() {
        return Objects.hash(this.splitId, this.addresses);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("splitId", (Object)this.splitId).add("addresses", this.addresses).toString();
    }
}

