/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift;

import io.airlift.configuration.Config;
import io.airlift.units.DataSize;
import io.airlift.units.MaxDataSize;
import io.airlift.units.MinDataSize;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;

public class ThriftConnectorConfig {
    private DataSize maxResponseSize = DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private int metadataRefreshThreads = 1;
    private int lookupRequestsConcurrency = 1;

    @NotNull
    @MinDataSize(value="1MB")
    @MaxDataSize(value="32MB")
    public @NotNull @MinDataSize(value="1MB") @MaxDataSize(value="32MB") DataSize getMaxResponseSize() {
        return this.maxResponseSize;
    }

    @Config(value="trino-thrift.max-response-size")
    public ThriftConnectorConfig setMaxResponseSize(DataSize maxResponseSize) {
        this.maxResponseSize = maxResponseSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMetadataRefreshThreads() {
        return this.metadataRefreshThreads;
    }

    @Config(value="trino-thrift.metadata-refresh-threads")
    public ThriftConnectorConfig setMetadataRefreshThreads(int metadataRefreshThreads) {
        this.metadataRefreshThreads = metadataRefreshThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getLookupRequestsConcurrency() {
        return this.lookupRequestsConcurrency;
    }

    @Config(value="trino-thrift.lookup-requests-concurrency")
    public ThriftConnectorConfig setLookupRequestsConcurrency(int lookupRequestsConcurrency) {
        this.lookupRequestsConcurrency = lookupRequestsConcurrency;
        return this;
    }
}

