/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class ThriftTableHandle
implements ConnectorTableHandle {
    private final String schemaName;
    private final String tableName;
    private final TupleDomain<ColumnHandle> constraint;
    private final Optional<Set<ColumnHandle>> desiredColumns;

    @JsonCreator
    public ThriftTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="constraint") TupleDomain<ColumnHandle> constraint, @JsonProperty(value="desiredColumns") Optional<Set<ColumnHandle>> desiredColumns) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.constraint = Objects.requireNonNull(constraint, "constraint is null");
        this.desiredColumns = Objects.requireNonNull(desiredColumns, "desiredColumns is null");
    }

    public ThriftTableHandle(SchemaTableName schemaTableName) {
        this(schemaTableName.getSchemaName(), schemaTableName.getTableName(), (TupleDomain<ColumnHandle>)TupleDomain.all(), Optional.empty());
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getConstraint() {
        return this.constraint;
    }

    @JsonProperty
    public Optional<Set<ColumnHandle>> getDesiredColumns() {
        return this.desiredColumns;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ThriftTableHandle other = (ThriftTableHandle)obj;
        return Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableName, other.tableName) && Objects.equals(this.constraint, other.constraint) && Objects.equals(this.desiredColumns, other.desiredColumns);
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.tableName, this.constraint, this.desiredColumns);
    }

    public String toString() {
        return this.schemaName + ":" + this.tableName;
    }
}

