/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.transport.server;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import io.airlift.drift.transport.MethodMetadata;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class ServerInvokeRequest {
    private final MethodMetadata method;
    private final Map<String, String> headers;
    private final Map<Short, Object> parameters;

    public ServerInvokeRequest(MethodMetadata method, Map<String, String> headers, Map<Short, Object> parameters) {
        this.method = Objects.requireNonNull(method, "method is null");
        this.headers = ImmutableMap.copyOf(Objects.requireNonNull(headers, "headers is null"));
        this.parameters = Collections.unmodifiableMap(new HashMap<Short, Object>(Objects.requireNonNull(parameters, "parameters is null")));
    }

    public MethodMetadata getMethod() {
        return this.method;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<Short, Object> getParameters() {
        return this.parameters;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("method", (Object)this.method).add("headers", this.headers.isEmpty() ? null : this.headers).toString();
    }
}

