/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec.guice;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import io.airlift.drift.codec.InternalThriftCodec;
import io.airlift.drift.codec.ThriftCodec;
import io.airlift.drift.codec.ThriftCodecManager;
import io.airlift.drift.codec.internal.ForCompiler;
import io.airlift.drift.codec.internal.ThriftCodecFactory;
import io.airlift.drift.codec.internal.compiler.CompilerThriftCodecFactory;
import io.airlift.drift.codec.metadata.ThriftCatalog;
import java.util.Objects;

public class ThriftCodecModule
implements Module {
    private final ClassLoader parent;

    public ThriftCodecModule() {
        this(ThriftCodecModule.class.getClassLoader());
    }

    public ThriftCodecModule(ClassLoader parent) {
        this.parent = parent;
    }

    public void configure(Binder binder) {
        binder.bind(ThriftCodecFactory.class).to(CompilerThriftCodecFactory.class).in(Scopes.SINGLETON);
        binder.bind(ThriftCatalog.class).in(Scopes.SINGLETON);
        binder.bind(ThriftCodecManager.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, (TypeLiteral)new TypeLiteral<ThriftCodec<?>>(){}, InternalThriftCodec.class).permitDuplicates();
        binder.bind(ClassLoader.class).annotatedWith(ForCompiler.class).toInstance((Object)this.parent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThriftCodecModule that = (ThriftCodecModule)o;
        return Objects.equals(this.parent, that.parent);
    }

    public int hashCode() {
        return Objects.hash(this.parent);
    }
}

