/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec.internal.builtin;

import com.google.errorprone.annotations.Immutable;
import io.airlift.drift.codec.ThriftCodec;
import io.airlift.drift.codec.metadata.ThriftType;
import io.airlift.drift.protocol.TProtocolReader;
import io.airlift.drift.protocol.TProtocolWriter;
import java.util.Objects;

@Immutable
public class DoubleThriftCodec
implements ThriftCodec<Double> {
    @Override
    public ThriftType getType() {
        return ThriftType.DOUBLE;
    }

    @Override
    public Double read(TProtocolReader protocol) throws Exception {
        Objects.requireNonNull(protocol, "protocol is null");
        return protocol.readDouble();
    }

    @Override
    public void write(Double value, TProtocolWriter protocol) throws Exception {
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(protocol, "protocol is null");
        protocol.writeDouble(value.doubleValue());
    }
}

