/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec.internal.compiler;

import com.google.errorprone.annotations.Immutable;
import com.google.inject.Inject;
import io.airlift.bytecode.DynamicClassLoader;
import io.airlift.drift.codec.ThriftCodec;
import io.airlift.drift.codec.ThriftCodecManager;
import io.airlift.drift.codec.internal.ForCompiler;
import io.airlift.drift.codec.internal.ThriftCodecFactory;
import io.airlift.drift.codec.internal.compiler.ThriftCodecByteCodeGenerator;
import io.airlift.drift.codec.metadata.ThriftStructMetadata;
import java.security.AccessController;

@Immutable
public class CompilerThriftCodecFactory
implements ThriftCodecFactory {
    private final boolean debug;
    private final DynamicClassLoader classLoader;

    @Inject
    public CompilerThriftCodecFactory(@ForCompiler ClassLoader parent) {
        this(false, parent);
    }

    public CompilerThriftCodecFactory(boolean debug) {
        this(debug, (ClassLoader)CompilerThriftCodecFactory.getPrivilegedClassLoader(CompilerThriftCodecFactory.class.getClassLoader()));
    }

    public CompilerThriftCodecFactory(boolean debug, ClassLoader parent) {
        this.debug = debug;
        this.classLoader = CompilerThriftCodecFactory.getPrivilegedClassLoader(parent);
    }

    @Override
    public ThriftCodec<?> generateThriftTypeCodec(ThriftCodecManager codecManager, ThriftStructMetadata metadata) {
        ThriftCodecByteCodeGenerator generator = new ThriftCodecByteCodeGenerator(codecManager, metadata, this.classLoader, this.debug);
        return generator.getThriftCodec();
    }

    private static DynamicClassLoader getPrivilegedClassLoader(ClassLoader parent) {
        return AccessController.doPrivileged(() -> new DynamicClassLoader(parent));
    }
}

