/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bytecode;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MoreCollectors;
import com.google.common.reflect.Reflection;
import io.airlift.bytecode.ByteCodeGenerator;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.ClassInfoLoader;
import io.airlift.bytecode.DynamicClassLoader;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ClassGenerator {
    private final DynamicClassLoader classLoader;
    private final ByteCodeGenerator byteCodeGenerator;

    public static ClassGenerator classGenerator(ClassLoader parentClassLoader) {
        return ClassGenerator.classGenerator(parentClassLoader, (Map<Long, MethodHandle>)ImmutableMap.of());
    }

    public static ClassGenerator classGenerator(ClassLoader parentClassLoader, Map<Long, MethodHandle> callSiteBindings) {
        return ClassGenerator.classGenerator(new DynamicClassLoader(parentClassLoader, callSiteBindings));
    }

    public static ClassGenerator classGenerator(DynamicClassLoader classLoader) {
        return new ClassGenerator(classLoader, ByteCodeGenerator.byteCodeGenerator());
    }

    private ClassGenerator(DynamicClassLoader classLoader, ByteCodeGenerator byteCodeGenerator) {
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
        this.byteCodeGenerator = Objects.requireNonNull(byteCodeGenerator, "byteCodeGenerator is null");
    }

    public ClassGenerator fakeLineNumbers(boolean fakeLineNumbers) {
        return new ClassGenerator(this.classLoader, this.byteCodeGenerator.fakeLineNumbers(fakeLineNumbers));
    }

    public ClassGenerator runAsmVerifier(boolean runAsmVerifier) {
        return new ClassGenerator(this.classLoader, this.byteCodeGenerator.runAsmVerifier(runAsmVerifier ? this.classLoader : null));
    }

    public ClassGenerator dumpRawBytecode(boolean dumpRawBytecode) {
        return new ClassGenerator(this.classLoader, this.byteCodeGenerator.dumpRawBytecode(dumpRawBytecode));
    }

    public ClassGenerator outputTo(Writer output) {
        return new ClassGenerator(this.classLoader, this.byteCodeGenerator.outputTo(output));
    }

    public ClassGenerator dumpClassFilesTo(Path dumpClassPath) {
        return this.dumpClassFilesTo(Optional.of(dumpClassPath));
    }

    public ClassGenerator dumpClassFilesTo(Optional<Path> dumpClassPath) {
        return new ClassGenerator(this.classLoader, this.byteCodeGenerator.dumpClassFilesTo(dumpClassPath));
    }

    public <T> Class<? extends T> defineClass(ClassDefinition classDefinition, Class<T> superType) {
        Map<String, Class<?>> classes = this.defineClasses((List<ClassDefinition>)ImmutableList.of((Object)classDefinition));
        return ((Class)classes.values().stream().collect(MoreCollectors.onlyElement())).asSubclass(superType);
    }

    public Map<String, Class<?>> defineClasses(List<ClassDefinition> classDefinitions) {
        ClassInfoLoader classInfoLoader = ClassInfoLoader.createClassInfoLoader(classDefinitions, this.classLoader);
        LinkedHashMap<String, byte[]> bytecodes = new LinkedHashMap<String, byte[]>();
        for (ClassDefinition classDefinition : classDefinitions) {
            byte[] byArray = this.byteCodeGenerator.generateByteCode(classInfoLoader, classDefinition);
            bytecodes.put(classDefinition.getType().getJavaClassName(), byArray);
        }
        Map<String, Class<?>> classes = this.classLoader.defineClasses(bytecodes);
        try {
            for (Class<?> clazz : classes.values()) {
                Reflection.initialize((Class[])new Class[]{clazz});
            }
        }
        catch (VerifyError verifyError) {
            throw new RuntimeException(verifyError);
        }
        return classes;
    }
}

