/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.transport.netty.client;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import io.airlift.configuration.Config;
import io.airlift.drift.transport.netty.codec.Protocol;
import io.airlift.drift.transport.netty.codec.Transport;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MaxDataSize;
import io.airlift.units.MinDuration;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotNull;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class DriftNettyClientConfig {
    private Transport transport = Transport.FRAMED;
    private Protocol protocol = Protocol.BINARY;
    private DataSize maxFrameSize = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private Duration connectTimeout = new Duration(500.0, TimeUnit.MILLISECONDS);
    private Duration requestTimeout = new Duration(1.0, TimeUnit.MINUTES);
    private HostAndPort socksProxy;
    private boolean sslEnabled;
    private List<String> ciphers = ImmutableList.of();
    private File trustCertificate;
    private File key;
    private String keyPassword;
    private long sessionCacheSize = 10000L;
    private Duration sessionTimeout = new Duration(1.0, TimeUnit.DAYS);

    @NotNull
    public Transport getTransport() {
        return this.transport;
    }

    @Config(value="thrift.client.transport")
    public DriftNettyClientConfig setTransport(Transport transport) {
        this.transport = transport;
        return this;
    }

    @NotNull
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Config(value="thrift.client.protocol")
    public DriftNettyClientConfig setProtocol(Protocol protocol) {
        this.protocol = protocol;
        return this;
    }

    @NotNull
    @MinDuration(value="1ms")
    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    @Config(value="thrift.client.connect-timeout")
    public DriftNettyClientConfig setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @NotNull
    @MinDuration(value="1ms")
    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    @Config(value="thrift.client.request-timeout")
    public DriftNettyClientConfig setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public HostAndPort getSocksProxy() {
        return this.socksProxy;
    }

    @Config(value="thrift.client.socks-proxy")
    public DriftNettyClientConfig setSocksProxy(HostAndPort socksProxy) {
        this.socksProxy = socksProxy;
        return this;
    }

    @MaxDataSize(value="1023MB")
    public DataSize getMaxFrameSize() {
        return this.maxFrameSize;
    }

    @Config(value="thrift.client.max-frame-size")
    public DriftNettyClientConfig setMaxFrameSize(DataSize maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
        return this;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    @Config(value="thrift.client.ssl.enabled")
    public DriftNettyClientConfig setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
        return this;
    }

    public File getTrustCertificate() {
        return this.trustCertificate;
    }

    @Config(value="thrift.client.ssl.trust-certificate")
    public DriftNettyClientConfig setTrustCertificate(File trustCertificate) {
        this.trustCertificate = trustCertificate;
        return this;
    }

    public File getKey() {
        return this.key;
    }

    @Config(value="thrift.client.ssl.key")
    public DriftNettyClientConfig setKey(File key) {
        this.key = key;
        return this;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    @Config(value="thrift.client.ssl.key-password")
    public DriftNettyClientConfig setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
        return this;
    }

    public long getSessionCacheSize() {
        return this.sessionCacheSize;
    }

    @Config(value="thrift.client.ssl.session-cache-size")
    public DriftNettyClientConfig setSessionCacheSize(long sessionCacheSize) {
        this.sessionCacheSize = sessionCacheSize;
        return this;
    }

    public Duration getSessionTimeout() {
        return this.sessionTimeout;
    }

    @Config(value="thrift.client.ssl.session-timeout")
    public DriftNettyClientConfig setSessionTimeout(Duration sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
        return this;
    }

    public List<String> getCiphers() {
        return this.ciphers;
    }

    @Config(value="thrift.client.ssl.ciphers")
    public DriftNettyClientConfig setCiphers(String ciphers) {
        this.ciphers = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)Objects.requireNonNull(ciphers, "ciphers is null"));
        return this;
    }

    @AssertTrue(message="Trust certificate must be provided when SSL is enabled")
    public @AssertTrue(message="Trust certificate must be provided when SSL is enabled") boolean isTruststorePathValid() {
        return !this.isSslEnabled() || this.getTrustCertificate() != null;
    }
}

