/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.transport.netty.codec;

import com.google.common.base.Preconditions;
import io.airlift.drift.transport.netty.codec.FrameInfo;
import io.airlift.units.DataSize;
import io.netty.handler.codec.DecoderException;
import java.util.Objects;
import java.util.Optional;

public class FrameTooLargeException
extends DecoderException {
    private final Optional<FrameInfo> frameInfo;
    private final long frameSizeInBytes;
    private final int maxFrameSizeInBytes;

    public FrameTooLargeException(Optional<FrameInfo> frameInfo, long frameSizeInBytes, int maxFrameSizeInBytes) {
        this.frameInfo = Objects.requireNonNull(frameInfo, "sequenceId is null");
        Preconditions.checkArgument((frameSizeInBytes >= 0L ? 1 : 0) != 0, (Object)"frameSizeInBytes cannot be negative");
        this.frameSizeInBytes = frameSizeInBytes;
        Preconditions.checkArgument((maxFrameSizeInBytes >= 0 ? 1 : 0) != 0, (Object)"maxFrameSizeInBytes cannot be negative");
        this.maxFrameSizeInBytes = maxFrameSizeInBytes;
    }

    public Optional<FrameInfo> getFrameInfo() {
        return this.frameInfo;
    }

    public String getMessage() {
        return String.format("Frame size %s exceeded max size %s: %s", DataSize.succinctBytes((long)this.frameSizeInBytes), DataSize.succinctBytes((long)this.maxFrameSizeInBytes), this.frameInfo);
    }
}

