/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.client;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Ordering;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public final class ExceptionClassification {
    public static final ExceptionClassification NORMAL_EXCEPTION = new ExceptionClassification(Optional.empty(), HostStatus.NORMAL);
    private final Optional<Boolean> retry;
    private final HostStatus hostStatus;

    public ExceptionClassification(Optional<Boolean> retry, HostStatus hostStatus) {
        this.retry = Objects.requireNonNull(retry, "retry is null");
        this.hostStatus = Objects.requireNonNull(hostStatus, "hostStatus is null");
    }

    public Optional<Boolean> isRetry() {
        return this.retry;
    }

    public HostStatus getHostStatus() {
        return this.hostStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExceptionClassification that = (ExceptionClassification)o;
        return Objects.equals(this.retry, that.retry) && this.hostStatus == that.hostStatus;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.retry, this.hostStatus});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("retry", this.retry).add("hostStatus", (Object)this.hostStatus).toString();
    }

    public static Collector<ExceptionClassification, ?, ExceptionClassification> mergeExceptionClassifications() {
        return new MergeExceptionClassificationsCollector();
    }

    public static enum HostStatus {
        NORMAL,
        OVERLOADED,
        DOWN;

    }

    private static class MergeExceptionClassificationsCollector
    implements Collector<ExceptionClassification, Accumulator, ExceptionClassification> {
        private MergeExceptionClassificationsCollector() {
        }

        @Override
        public Supplier<Accumulator> supplier() {
            return Accumulator::new;
        }

        @Override
        public BiConsumer<Accumulator, ExceptionClassification> accumulator() {
            return Accumulator::add;
        }

        @Override
        public BinaryOperator<Accumulator> combiner() {
            return Accumulator::add;
        }

        @Override
        public Function<Accumulator, ExceptionClassification> finisher() {
            return Accumulator::toExceptionClassification;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return EnumSet.of(Collector.Characteristics.CONCURRENT, Collector.Characteristics.UNORDERED);
        }

        public static class Accumulator {
            private Optional<Boolean> retry = Optional.empty();
            private HostStatus hostStatus = HostStatus.NORMAL;

            public void add(ExceptionClassification classification) {
                this.retry = Accumulator.mergeRetry(this.retry, classification.isRetry());
                this.hostStatus = (HostStatus)((Object)Ordering.natural().max((Object)this.hostStatus, (Object)classification.getHostStatus()));
            }

            public Accumulator add(Accumulator accumulation) {
                this.retry = Accumulator.mergeRetry(this.retry, accumulation.retry);
                this.hostStatus = (HostStatus)((Object)Ordering.natural().max((Object)this.hostStatus, (Object)accumulation.hostStatus));
                return this;
            }

            public ExceptionClassification toExceptionClassification() {
                return new ExceptionClassification(this.retry, this.hostStatus);
            }

            public static Optional<Boolean> mergeRetry(Optional<Boolean> oldRetry, Optional<Boolean> newRetry) {
                if (!oldRetry.isPresent()) {
                    return newRetry;
                }
                if (!newRetry.isPresent()) {
                    return oldRetry;
                }
                return Optional.of(oldRetry.get() != false && newRetry.get() != false);
            }
        }
    }
}

