/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.transport.netty.server;

import com.google.inject.Inject;
import io.airlift.drift.transport.netty.server.DriftNettyServerConfig;
import io.airlift.drift.transport.netty.server.DriftNettyServerTransport;
import io.airlift.drift.transport.server.ServerMethodInvoker;
import io.airlift.drift.transport.server.ServerTransport;
import io.airlift.drift.transport.server.ServerTransportFactory;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import java.util.Objects;

public class DriftNettyServerTransportFactory
implements ServerTransportFactory {
    private final DriftNettyServerConfig config;
    private final ByteBufAllocator allocator;

    public DriftNettyServerTransportFactory(DriftNettyServerConfig config) {
        this(config, (ByteBufAllocator)PooledByteBufAllocator.DEFAULT);
    }

    @Inject
    public DriftNettyServerTransportFactory(DriftNettyServerConfig config, ByteBufAllocator allocator) {
        this.config = Objects.requireNonNull(config, "config is null");
        this.allocator = Objects.requireNonNull(allocator, "allocator is null");
    }

    public ServerTransport createServerTransport(ServerMethodInvoker methodInvoker) {
        return new DriftNettyServerTransport(methodInvoker, this.config, this.allocator);
    }
}

