/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.Reflection;
import io.airlift.drift.client.DriftClient;
import io.airlift.drift.client.DriftInvocationHandler;
import io.airlift.drift.client.DriftMethodHandler;
import io.airlift.drift.client.ExceptionClassifier;
import io.airlift.drift.client.FilteredMethodInvoker;
import io.airlift.drift.client.MethodInvocationFilter;
import io.airlift.drift.client.RetryPolicy;
import io.airlift.drift.client.address.AddressSelector;
import io.airlift.drift.client.stats.MethodInvocationStat;
import io.airlift.drift.client.stats.MethodInvocationStatsFactory;
import io.airlift.drift.client.stats.NullMethodInvocationStat;
import io.airlift.drift.client.stats.NullMethodInvocationStatsFactory;
import io.airlift.drift.codec.ThriftCodecManager;
import io.airlift.drift.codec.metadata.ThriftMethodMetadata;
import io.airlift.drift.codec.metadata.ThriftServiceMetadata;
import io.airlift.drift.transport.MethodMetadata;
import io.airlift.drift.transport.client.Address;
import io.airlift.drift.transport.client.DriftClientConfig;
import io.airlift.drift.transport.client.MethodInvoker;
import io.airlift.drift.transport.client.MethodInvokerFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;

public class DriftClientFactory {
    private final ThriftCodecManager codecManager;
    private final Supplier<MethodInvoker> methodInvokerSupplier;
    private final AddressSelector<? extends Address> addressSelector;
    private final ExceptionClassifier exceptionClassifier;
    private final ConcurrentMap<Class<?>, ThriftServiceMetadata> serviceMetadataCache = new ConcurrentHashMap();
    private final MethodInvocationStatsFactory methodInvocationStatsFactory;

    public DriftClientFactory(ThriftCodecManager codecManager, Supplier<MethodInvoker> methodInvokerSupplier, AddressSelector<? extends Address> addressSelector, ExceptionClassifier exceptionClassifier, MethodInvocationStatsFactory methodInvocationStatsFactory) {
        this.codecManager = Objects.requireNonNull(codecManager, "codecManager is null");
        this.methodInvokerSupplier = Objects.requireNonNull(methodInvokerSupplier, "methodInvokerSupplier is null");
        this.addressSelector = Objects.requireNonNull(addressSelector, "addressSelector is null");
        this.exceptionClassifier = exceptionClassifier;
        this.methodInvocationStatsFactory = Objects.requireNonNull(methodInvocationStatsFactory, "methodInvocationStatsFactory is null");
    }

    public DriftClientFactory(ThriftCodecManager codecManager, MethodInvokerFactory<?> invokerFactory, AddressSelector<? extends Address> addressSelector, ExceptionClassifier exceptionClassifier) {
        this(codecManager, () -> invokerFactory.createMethodInvoker(null), addressSelector, exceptionClassifier, new NullMethodInvocationStatsFactory());
    }

    public DriftClientFactory(ThriftCodecManager codecManager, MethodInvokerFactory<?> invokerFactory, AddressSelector<? extends Address> addressSelector) {
        this(codecManager, invokerFactory, addressSelector, ExceptionClassifier.NORMAL_RESULT);
    }

    public <T> DriftClient<T> createDriftClient(Class<T> clientInterface) {
        return this.createDriftClient(clientInterface, Optional.empty(), (List<MethodInvocationFilter>)ImmutableList.of(), new DriftClientConfig());
    }

    public <T> DriftClient<T> createDriftClient(Class<T> clientInterface, Optional<Class<? extends Annotation>> qualifierAnnotation, List<MethodInvocationFilter> filters, DriftClientConfig config) {
        ThriftServiceMetadata serviceMetadata = this.serviceMetadataCache.computeIfAbsent(clientInterface, clazz -> new ThriftServiceMetadata(clazz, this.codecManager.getCatalog()));
        MethodInvoker invoker = FilteredMethodInvoker.createFilteredMethodInvoker(filters, this.methodInvokerSupplier.get());
        Optional<String> qualifier = qualifierAnnotation.map(Class::getSimpleName);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ThriftMethodMetadata method : serviceMetadata.getMethods().values()) {
            MethodMetadata metadata = MethodMetadata.toMethodMetadata((ThriftCodecManager)this.codecManager, (ThriftMethodMetadata)method);
            RetryPolicy retryPolicy = new RetryPolicy(config, this.exceptionClassifier);
            MethodInvocationStat statHandler = config.isStatsEnabled() ? this.methodInvocationStatsFactory.getStat(serviceMetadata, qualifier, metadata) : new NullMethodInvocationStat();
            DriftMethodHandler handler = new DriftMethodHandler(metadata, method.getHeaderParameters(), invoker, method.isAsync(), this.addressSelector, retryPolicy, statHandler);
            builder.put((Object)method.getMethod(), (Object)handler);
        }
        ImmutableMap methods = builder.build();
        return (arg_0, arg_1) -> DriftClientFactory.lambda$createDriftClient$1(clientInterface, serviceMetadata, (Map)methods, arg_0, arg_1);
    }

    private static /* synthetic */ Object lambda$createDriftClient$1(Class clientInterface, ThriftServiceMetadata serviceMetadata, Map methods, Optional context, Map headers) {
        return Reflection.newProxy((Class)clientInterface, (InvocationHandler)new DriftInvocationHandler(serviceMetadata.getName(), methods, context, headers));
    }
}

