/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.client.guice;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.lang.annotation.Annotation;
import java.util.Objects;

public abstract class AbstractAnnotatedProvider<T>
implements Provider<T> {
    private final Annotation annotation;
    private Injector injector;

    protected AbstractAnnotatedProvider(Annotation annotation) {
        this.annotation = Objects.requireNonNull(annotation, "annotation is null");
    }

    @Inject
    public final void setInjector(Injector injector) {
        this.injector = injector;
    }

    public final T get() {
        Preconditions.checkState((this.injector != null ? 1 : 0) != 0, (Object)"injector was not set");
        return this.get(this.injector, this.annotation);
    }

    protected abstract T get(Injector var1, Annotation var2);

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractAnnotatedProvider other = (AbstractAnnotatedProvider)obj;
        return Objects.equals(this.annotation, other.annotation);
    }

    public final int hashCode() {
        return Objects.hash(this.annotation);
    }
}

