/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.ConfigBinder;
import io.airlift.drift.client.ExceptionClassification;
import io.airlift.drift.client.guice.DriftClientBinder;
import io.trino.plugin.thrift.ThriftConnector;
import io.trino.plugin.thrift.ThriftConnectorConfig;
import io.trino.plugin.thrift.ThriftConnectorStats;
import io.trino.plugin.thrift.ThriftIndexProvider;
import io.trino.plugin.thrift.ThriftMetadata;
import io.trino.plugin.thrift.ThriftPageSourceProvider;
import io.trino.plugin.thrift.ThriftSplitManager;
import io.trino.plugin.thrift.annotations.ForMetadataRefresh;
import io.trino.plugin.thrift.api.TrinoThriftService;
import io.trino.plugin.thrift.api.TrinoThriftServiceException;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.weakref.jmx.guice.ExportBinder;

public class ThriftModule
implements Module {
    public void configure(Binder binder) {
        DriftClientBinder.driftClientBinder((Binder)binder).bindDriftClient(TrinoThriftService.class).withExceptionClassifier(t -> {
            if (t instanceof TrinoThriftServiceException) {
                TrinoThriftServiceException ttse = (TrinoThriftServiceException)t;
                return new ExceptionClassification(Optional.of(ttse.isRetryable()), ExceptionClassification.HostStatus.NORMAL);
            }
            return ExceptionClassification.NORMAL_EXCEPTION;
        });
        binder.bind(ThriftConnector.class).in(Scopes.SINGLETON);
        binder.bind(ThriftMetadata.class).in(Scopes.SINGLETON);
        binder.bind(ThriftSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(ThriftPageSourceProvider.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(ThriftConnectorConfig.class);
        binder.bind(ThriftIndexProvider.class).in(Scopes.SINGLETON);
        binder.bind(ThriftConnectorStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(ThriftConnectorStats.class).withGeneratedName();
    }

    @Provides
    @Singleton
    @ForMetadataRefresh
    public Executor createMetadataRefreshExecutor(ThriftConnectorConfig config) {
        return Executors.newFixedThreadPool(config.getMetadataRefreshThreads(), Threads.daemonThreadsNamed((String)"metadata-refresh-%s"));
    }
}

