/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec.internal.builtin;

import com.google.errorprone.annotations.Immutable;
import io.airlift.drift.codec.ThriftCodec;
import io.airlift.drift.codec.metadata.ThriftType;
import io.airlift.drift.protocol.TProtocolReader;
import io.airlift.drift.protocol.TProtocolWriter;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.OptionalLong;

@Immutable
public class OptionalLongThriftCodec
implements ThriftCodec<OptionalLong> {
    @Override
    public ThriftType getType() {
        return new ThriftType(ThriftType.I64, (Type)((Object)OptionalLong.class), OptionalLong.empty());
    }

    @Override
    public OptionalLong read(TProtocolReader protocol) throws Exception {
        Objects.requireNonNull(protocol, "protocol is null");
        return OptionalLong.of(protocol.readI64());
    }

    @Override
    public void write(OptionalLong value, TProtocolWriter protocol) throws Exception {
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(protocol, "protocol is null");
        protocol.writeI64(value.orElseThrow(() -> new IllegalArgumentException("value is not present")));
    }

    @Override
    public boolean isNull(OptionalLong value) {
        return value == null || !value.isPresent();
    }
}

